/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.model.Array;
import uk.modl.model.ArrayConditional;
import uk.modl.model.ArrayItem;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.Map;
import uk.modl.model.MapConditional;
import uk.modl.model.Modl;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TopLevelConditional;
import uk.modl.model.TruePrimitive;
import uk.modl.model.ValueConditional;
import uk.modl.model.ValueItem;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.StringEscapeReplacer;

public class JacksonJsonNodeTransform {
    private static final Logger log = LogManager.getLogger(JacksonJsonNodeTransform.class);
    private static final Predicate<Structure> shouldAppearInOutput = s -> {
        if (s instanceof Pair) {
            Pair p = (Pair)s;
            return !p.getKey().startsWith("_") && !p.getKey().startsWith("*") && !p.getKey().equals("?");
        }
        if (s instanceof TopLevelConditional) {
            TopLevelConditional tlc = (TopLevelConditional)s;
            return !tlc.getResult().isEmpty();
        }
        return true;
    };
    private final TransformationContext ctx;

    public JacksonJsonNodeTransform(TransformationContext ctx) {
        this.ctx = ctx;
    }

    public JsonNode apply(Modl modl) {
        ObjectNode result = null;
        Vector filtered = modl.getStructures().filter(shouldAppearInOutput);
        switch (filtered.size()) {
            case 0: {
                break;
            }
            case 1: {
                ObjectNode objectNode;
                Structure structure = (Structure)filtered.get(0);
                if (structure instanceof Array) {
                    ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
                    result = arrayNode;
                    ((Array)structure).getArrayItems().forEach(arrayItem -> this.accept(arrayNode, (ArrayItem)arrayItem));
                    break;
                }
                result = objectNode = JsonNodeFactory.instance.objectNode();
                this.accept(objectNode, structure);
                break;
            }
            default: {
                if (filtered.count(s -> s instanceof Pair) > 0) {
                    ObjectNode objectNode;
                    result = objectNode = JsonNodeFactory.instance.objectNode();
                    filtered.forEach(s -> this.accept(objectNode, (Structure)s));
                    break;
                }
                ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode(filtered.size());
                result = arrayNode;
                filtered.forEach(s -> this.accept(arrayNode, (ArrayItem)((Object)s)));
            }
        }
        return result;
    }

    private Function<Object, Object> addPairToArrayNode(ArrayNode node) {
        return p -> {
            if (p instanceof Pair) {
                Pair pair = (Pair)p;
                if (pair.getKey().startsWith("_")) {
                    return p;
                }
                ObjectNode newNode = JsonNodeFactory.instance.objectNode();
                node.add((JsonNode)newNode);
                this.addPairToObjectNode(newNode).apply(p);
            }
            return p;
        };
    }

    private Function<Object, Object> addPairValueToArrayNode(ArrayNode node) {
        return p -> {
            if (p instanceof PairValue) {
                PairValue pv = (PairValue)p;
                if (pv instanceof StringPrimitive) {
                    Primitive prim = (Primitive)pv;
                    node.add((JsonNode)JsonNodeFactory.instance.textNode(prim.toString()));
                } else if (pv instanceof NumberPrimitive) {
                    NumberPrimitive prim = (NumberPrimitive)pv;
                    Number n = prim.numericValue();
                    if (n instanceof Double || n instanceof Float) {
                        node.add((JsonNode)JsonNodeFactory.instance.numberNode(n.doubleValue()));
                    } else if (n instanceof Integer || n instanceof Long) {
                        node.add((JsonNode)JsonNodeFactory.instance.numberNode(n.longValue()));
                    }
                } else if (pv instanceof TruePrimitive) {
                    node.add((JsonNode)JsonNodeFactory.instance.booleanNode(true));
                } else if (pv instanceof FalsePrimitive) {
                    node.add((JsonNode)JsonNodeFactory.instance.booleanNode(false));
                } else if (pv instanceof NullPrimitive) {
                    node.add((JsonNode)JsonNodeFactory.instance.nullNode());
                }
            }
            return p;
        };
    }

    private Function<Object, Object> addArrayToArrayNode(ArrayNode node) {
        return s -> {
            if (s instanceof Array) {
                Array arr = (Array)s;
                ArrayNode newNode = JsonNodeFactory.instance.arrayNode();
                node.add((JsonNode)newNode);
                arr.getArrayItems().forEach(arrayItem -> this.accept(newNode, (ArrayItem)arrayItem));
            }
            return s;
        };
    }

    private Function<Object, Object> addMapToArrayNode(ArrayNode node) {
        return s -> {
            if (s instanceof Map) {
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                node.add((JsonNode)objectNode);
                Map map = (Map)s;
                this.accept(objectNode, map);
            }
            return s;
        };
    }

    private void accept(ObjectNode node, Map map) {
        Option.of((Object)map).map(this.addMapToObjectNode(node));
    }

    private void accept(ArrayNode node, ArrayItem arrayItem) {
        Option.of((Object)arrayItem).map(this.addArrayToArrayNode(node)).map(this.addMapToArrayNode(node)).map(this.addPairToArrayNode(node)).map(this.addPairValueToArrayNode(node)).map(this.addArrayConditionalToArrayNode(node));
    }

    private void accept(ObjectNode node, Structure structure) {
        Option.of((Object)structure).filter(shouldAppearInOutput).map(this.addMapToObjectNode(node)).map(this.addTopLevelConditionalToObjectNode(node)).map(this.addPairToObjectNode(node));
    }

    private Function<Object, Object> addMapToObjectNode(ObjectNode node) {
        return s -> {
            if (s instanceof Map) {
                Map map = (Map)s;
                map.getMapItems().forEach(mapItem -> {
                    if (mapItem instanceof Pair) {
                        Pair p = (Pair)mapItem;
                        this.accept(node, p);
                    } else if (mapItem instanceof MapConditional) {
                        this.accept(node, (MapConditional)mapItem);
                    } else {
                        log.error("Cannot process object type: {}", (Object)mapItem.getClass().getName());
                    }
                });
            }
            return s;
        };
    }

    private void accept(ObjectNode node, MapConditional mc) {
        Option.of((Object)mc).map(this.addMapConditionalToMapNode(node));
    }

    private Function<Object, Object> addTopLevelConditionalToObjectNode(ObjectNode node) {
        return s -> {
            if (s instanceof TopLevelConditional) {
                ((TopLevelConditional)s).getResult().forEach(structure -> this.accept(node, (Structure)structure));
            }
            return s;
        };
    }

    private Function<Object, Object> addArrayConditionalToArrayNode(ArrayNode node) {
        return s -> {
            if (s instanceof ArrayConditional) {
                ((ArrayConditional)s).getResult().forEach(arrayItem -> this.accept(node, (ArrayItem)arrayItem));
            }
            return s;
        };
    }

    private Function<Object, Object> addMapConditionalToMapNode(ObjectNode node) {
        return s -> {
            if (s instanceof MapConditional) {
                ((MapConditional)s).getResult().forEach(mapItem -> this.accept(node, (ValueItem)((Object)mapItem)));
            }
            return s;
        };
    }

    private void accept(ObjectNode node, Pair pair) {
        Option.of((Object)pair).filter(shouldAppearInOutput).map(this.addPairToObjectNode(node));
    }

    private Function<Object, Object> addPairToObjectNode(ObjectNode node) {
        return p -> {
            if (p instanceof Pair) {
                Pair pair = (Pair)p;
                if (pair.getKey().startsWith("_")) {
                    return p;
                }
                String key = StringEscapeReplacer.replace(pair.getKey());
                if (pair.getValue() instanceof StringPrimitive) {
                    this.handleStringPrimitive(node, (Pair)p, key);
                } else if (pair.getValue() instanceof NumberPrimitive) {
                    this.handleNumberPrimitive(node, (Pair)p, key);
                } else if (pair.getValue() instanceof TruePrimitive) {
                    node.set(key, (JsonNode)JsonNodeFactory.instance.booleanNode(true));
                } else if (pair.getValue() instanceof FalsePrimitive) {
                    node.set(key, (JsonNode)JsonNodeFactory.instance.booleanNode(false));
                } else if (pair.getValue() instanceof NullPrimitive) {
                    node.set(key, (JsonNode)JsonNodeFactory.instance.nullNode());
                } else if (pair.getValue() instanceof Primitive) {
                    Primitive prim = (Primitive)((Pair)p).getValue();
                    node.set(key, (JsonNode)JsonNodeFactory.instance.textNode(prim.toString()));
                } else if (pair.getValue() instanceof Array) {
                    this.handleArray(node, pair, key);
                } else if (pair.getValue() instanceof Map) {
                    this.handleMap(node, pair, key);
                } else if (pair.getValue() instanceof ValueConditional) {
                    this.handleMapConditional(node, pair, key);
                } else if (pair.getValue() instanceof ValueItem) {
                    this.handleValueItem(node, pair, key);
                }
            }
            return p;
        };
    }

    private void handleValueItem(ObjectNode node, Pair pair, String key) {
        ObjectNode newNode = JsonNodeFactory.instance.objectNode();
        node.set(key, (JsonNode)newNode);
        this.accept(newNode, (ValueItem)pair.getValue());
    }

    private void handleMapConditional(ObjectNode node, Pair pair, String key) {
        Vector<ValueItem> valueItems = ((ValueConditional)pair.getValue()).getResult();
        if (valueItems.size() == 1) {
            this.accept(node, Pair.of(this.ctx.getAncestry(), pair, key, (PairValue)valueItems.get(0)));
        } else {
            this.accept(node, Pair.of(this.ctx.getAncestry(), pair, key, Array.of(this.ctx.getAncestry(), pair, (Vector<ArrayItem>)valueItems.map(v -> (ArrayItem)((Object)v)))));
        }
    }

    private void handleMap(ObjectNode node, Pair pair, String key) {
        ObjectNode newNode = JsonNodeFactory.instance.objectNode();
        node.set(key, (JsonNode)newNode);
        this.addMapToObjectNode(newNode).apply(pair.getValue());
    }

    private void handleArray(ObjectNode node, Pair pair, String key) {
        ArrayNode newNode = JsonNodeFactory.instance.arrayNode();
        node.set(key, (JsonNode)newNode);
        ((Array)pair.getValue()).getArrayItems().forEach(ai -> this.accept(newNode, (ArrayItem)ai));
    }

    private void handleNumberPrimitive(ObjectNode node, Pair p, String key) {
        NumberPrimitive prim = (NumberPrimitive)p.getValue();
        Number n = prim.numericValue();
        if (n instanceof Double) {
            node.set(key, (JsonNode)JsonNodeFactory.instance.numberNode(n.doubleValue()));
        } else if (n instanceof Float) {
            node.set(key, (JsonNode)JsonNodeFactory.instance.numberNode(n.floatValue()));
        } else if (n instanceof Integer) {
            node.set(key, (JsonNode)JsonNodeFactory.instance.numberNode(n.intValue()));
        } else if (n instanceof Long) {
            node.set(key, (JsonNode)JsonNodeFactory.instance.numberNode(n.longValue()));
        }
    }

    private void handleStringPrimitive(ObjectNode node, Pair p, String key) {
        Primitive prim = (Primitive)p.getValue();
        String text = StringEscapeReplacer.replace(prim.toString());
        node.set(key, (JsonNode)JsonNodeFactory.instance.textNode(text));
    }

    private void accept(ObjectNode node, ValueItem item) {
        Option.of((Object)item).map(this.addMapToObjectNode(node)).map(this.addPairToObjectNode(node));
    }
}

