/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Vector;
import java.util.Set;
import java.util.TreeSet;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayConditional;
import uk.modl.model.ArrayConditionalReturn;
import uk.modl.model.ArrayItem;
import uk.modl.model.Condition;
import uk.modl.model.ConditionGroup;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.model.ConditionTest;
import uk.modl.model.EqualsOperator;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.GreaterThanOperator;
import uk.modl.model.GreaterThanOrEqualsOperator;
import uk.modl.model.LessThanOperator;
import uk.modl.model.LessThanOrEqualsOperator;
import uk.modl.model.Map;
import uk.modl.model.MapConditional;
import uk.modl.model.MapConditionalReturn;
import uk.modl.model.MapItem;
import uk.modl.model.Modl;
import uk.modl.model.NotEqualsOperator;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Operator;
import uk.modl.model.Pair;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TopLevelConditional;
import uk.modl.model.TopLevelConditionalReturn;
import uk.modl.model.TruePrimitive;
import uk.modl.model.ValueConditional;
import uk.modl.model.ValueConditionalReturn;
import uk.modl.model.ValueItem;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.utils.Util;

public class ModlParsedVisitor {
    private static final Logger log = LogManager.getLogger(ModlParsedVisitor.class);
    final Set<String> immutableNames = new TreeSet<String>();
    private final Ancestry ancestry;
    private Modl modl;
    private int inConditional = 0;
    private int version = 1;

    public ModlParsedVisitor(MODLParser.ModlContext ctx, Ancestry ancestry) {
        log.trace("ModlParsedVisitor()");
        try {
            this.ancestry = ancestry;
            this.modl = Modl.of(ancestry, null, (Vector<Structure>)Vector.empty());
            Vector structures = Vector.ofAll(ctx.modl_structure().stream().map(ctx1 -> this.visitStructure((MODLParser.Modl_structureContext)((Object)ctx1), this.modl)));
            int i = 0;
            for (Structure structure : structures) {
                Pair first;
                String key;
                if (i > 0 && structure instanceof Pair && ((key = (first = (Pair)structure).getKey()).equals("*V") || key.equals("*VERSION"))) {
                    throw new RuntimeException("MODL version should be on the first line if specified.");
                }
                ++i;
            }
            this.modl = this.modl.with(ancestry, (Vector<Structure>)structures);
        }
        catch (RuntimeException e) {
            if (this.version > 1) {
                throw new InterpreterError("Interpreter Error: " + e.getMessage() + " - MODL Version 1 interpreter cannot process this MODL Version " + this.version + " file.");
            }
            throw new InterpreterError("Interpreter Error: " + e.getMessage());
        }
    }

    public void addImmutableName(String name) {
        if (this.immutableNames.contains(name)) {
            throw new RuntimeException("Already defined " + name + " as final.");
        }
        if (StringUtils.isAllUpperCase((CharSequence)name)) {
            this.immutableNames.add(name);
        }
    }

    private Structure visitStructure(MODLParser.Modl_structureContext ctx, Parent parent) {
        log.trace("visitStructure()");
        return ctx.modl_array() != null ? this.visitArray(ctx.modl_array(), parent) : (ctx.modl_map() != null ? this.visitMap(ctx.modl_map(), parent) : (ctx.modl_pair() != null ? this.visitPair(ctx.modl_pair(), parent) : (ctx.modl_top_level_conditional() != null ? this.visitTopLevelConditional(ctx.modl_top_level_conditional(), parent) : null)));
    }

    private TopLevelConditional visitTopLevelConditional(MODLParser.Modl_top_level_conditionalContext ctx, Parent parent) {
        log.trace("visitTopLevelConditional()");
        TopLevelConditional tlc = TopLevelConditional.of(this.ancestry, parent, (Vector<ConditionTest>)Vector.empty(), (Vector<TopLevelConditionalReturn>)Vector.empty(), (Vector<Structure>)Vector.empty());
        Vector tests = ctx.modl_condition_test() != null ? Vector.ofAll(ctx.modl_condition_test().stream().map(ctx2 -> this.visitConditionTest((MODLParser.Modl_condition_testContext)((Object)ctx2), tlc))) : null;
        Vector returns = ctx.modl_top_level_conditional_return() != null ? Vector.ofAll(ctx.modl_top_level_conditional_return().stream().map(ctx1 -> this.visitTopLevelConditionalReturn((MODLParser.Modl_top_level_conditional_returnContext)((Object)ctx1), tlc))) : null;
        return tlc.with(this.ancestry, (Vector<ConditionTest>)tests, (Vector<TopLevelConditionalReturn>)returns);
    }

    private MapConditional visitMapConditional(MODLParser.Modl_map_conditionalContext ctx, Parent parent) {
        log.trace("visitMapConditional()");
        MapConditional mc = MapConditional.of(this.ancestry, parent, (Vector<ConditionTest>)Vector.empty(), (Vector<MapConditionalReturn>)Vector.empty(), (Vector<MapItem>)Vector.empty());
        Vector tests = ctx.modl_condition_test() != null ? Vector.ofAll(ctx.modl_condition_test().stream().map(ctx2 -> this.visitConditionTest((MODLParser.Modl_condition_testContext)((Object)ctx2), mc))) : null;
        Vector returns = ctx.modl_map_conditional_return() != null ? Vector.ofAll(ctx.modl_map_conditional_return().stream().map(ctx1 -> this.visitMapConditionalReturn((MODLParser.Modl_map_conditional_returnContext)((Object)ctx1), mc))) : null;
        return mc.with(this.ancestry, (Vector<ConditionTest>)tests, (Vector<MapConditionalReturn>)returns);
    }

    private MapConditionalReturn visitMapConditionalReturn(MODLParser.Modl_map_conditional_returnContext ctx, Parent parent) {
        log.trace("visitMapConditionalReturn()");
        MapConditionalReturn mcr = MapConditionalReturn.of(this.ancestry, parent, (Vector<MapItem>)Vector.empty());
        Vector items = Vector.ofAll(ctx.modl_map_item().stream().map(ctx1 -> this.visitMapItem((MODLParser.Modl_map_itemContext)((Object)ctx1), mcr)));
        return mcr.with(this.ancestry, (Vector<MapItem>)items);
    }

    private TopLevelConditionalReturn visitTopLevelConditionalReturn(MODLParser.Modl_top_level_conditional_returnContext ctx, Parent parent) {
        log.trace("visitTopLevelConditionalReturn()");
        TopLevelConditionalReturn tlcr = TopLevelConditionalReturn.of(this.ancestry, parent, (Vector<Structure>)Vector.empty());
        Vector structures = ctx.modl_structure() != null ? Vector.ofAll(ctx.modl_structure().stream().map(ctx1 -> this.visitStructure((MODLParser.Modl_structureContext)((Object)ctx1), tlcr))) : null;
        return tlcr.with(this.ancestry, structures);
    }

    private ConditionTest visitConditionTest(MODLParser.Modl_condition_testContext ctx, Parent parent) {
        log.trace("visitConditionTest()");
        ConditionTest ct = ConditionTest.of(this.ancestry, parent, (Vector<Tuple2<ConditionOrConditionGroupInterface, String>>)Vector.empty());
        Vector subConditionList = Vector.empty();
        Tuple2 lastSubCondition = null;
        boolean shouldNegate = false;
        for (ParseTree child : ctx.children) {
            if (child instanceof MODLParser.Modl_condition_groupContext) {
                ConditionGroup conditionGroup = this.visitConditionGroup((MODLParser.Modl_condition_groupContext)child, shouldNegate, ct);
                lastSubCondition = Tuple.of((Object)conditionGroup, null);
                shouldNegate = false;
                continue;
            }
            if (child instanceof MODLParser.Modl_conditionContext) {
                Condition condition = this.visitCondition((MODLParser.Modl_conditionContext)child, shouldNegate, ct);
                lastSubCondition = Tuple.of((Object)condition, null);
                shouldNegate = false;
                continue;
            }
            if (child.getText().equals("!")) {
                shouldNegate = true;
                continue;
            }
            assert (lastSubCondition != null);
            subConditionList = subConditionList.append((Object)lastSubCondition.update2((Object)child.getText()));
            lastSubCondition = null;
        }
        if (lastSubCondition != null) {
            subConditionList = subConditionList.append(lastSubCondition);
        }
        return ct.with(this.ancestry, (Vector<Tuple2<ConditionOrConditionGroupInterface, String>>)subConditionList);
    }

    private ConditionGroup visitConditionGroup(MODLParser.Modl_condition_groupContext ctx, boolean shouldNegate, Parent parent) {
        log.trace("visitConditionGroup()");
        ConditionGroup cg = ConditionGroup.of(this.ancestry, parent, (Vector<Tuple2<ConditionTest, String>>)Vector.empty(), false);
        Vector<Tuple2<ConditionTest, String>> subConditionList = this.handleConditionGroup(ctx, cg);
        return cg.with(this.ancestry, subConditionList, shouldNegate);
    }

    private Vector<Tuple2<ConditionTest, String>> handleConditionGroup(MODLParser.Modl_condition_groupContext ctx, Parent parent) {
        log.trace("handleConditionGroup()");
        Vector subConditionList = Vector.empty();
        String lastOperator = null;
        for (ParseTree child : ctx.children) {
            if (child instanceof MODLParser.Modl_condition_testContext) {
                ConditionTest conditionGroup = this.visitConditionTest((MODLParser.Modl_condition_testContext)child, parent);
                subConditionList = subConditionList.append((Object)Tuple.of((Object)conditionGroup, (Object)lastOperator));
                lastOperator = null;
                continue;
            }
            lastOperator = child.getText();
        }
        return subConditionList;
    }

    private Condition visitCondition(MODLParser.Modl_conditionContext ctx, boolean shouldNegate, Parent parent) {
        String lhs;
        log.trace("visitCondition()");
        Condition c = Condition.of(this.ancestry, parent, NullPrimitive.instance, null, (Vector<ValueItem>)Vector.empty(), false);
        ++this.inConditional;
        Operator op = ctx.modl_operator() != null ? this.visitOperator(ctx.modl_operator()) : null;
        Vector values = ctx.modl_value() != null ? Vector.ofAll(ctx.modl_value().stream().map(ctx1 -> this.visitValue((MODLParser.Modl_valueContext)((Object)ctx1), c))) : Vector.empty();
        String string = lhs = ctx.STRING() != null ? ctx.STRING().getText() : null;
        if (ctx.getText().startsWith("\"") || ctx.getText().startsWith("`")) {
            throw new RuntimeException("Invalid Left Hand Side for conditional: " + ctx.getText());
        }
        --this.inConditional;
        return c.with(this.ancestry, StringPrimitive.of(this.ancestry, c, lhs), op, (Vector<ValueItem>)values, shouldNegate);
    }

    private Operator visitOperator(MODLParser.Modl_operatorContext ctx) {
        boolean lthan;
        log.trace("visitOperator()");
        boolean equals = ctx.EQUALS() != null;
        boolean negate = ctx.EXCLAM() != null;
        boolean gthan = ctx.GTHAN() != null;
        boolean bl = lthan = ctx.LTHAN() != null;
        if (equals) {
            if (gthan) {
                return GreaterThanOrEqualsOperator.instance;
            }
            if (lthan) {
                return LessThanOrEqualsOperator.instance;
            }
            if (negate) {
                return NotEqualsOperator.instance;
            }
            return EqualsOperator.instance;
        }
        if (gthan) {
            return GreaterThanOperator.instance;
        }
        if (lthan) {
            return LessThanOperator.instance;
        }
        return null;
    }

    private Array visitArray(MODLParser.Modl_arrayContext ctx, Parent parent) {
        log.trace("visitArray()");
        Array arr = Array.of(this.ancestry, parent, (Vector<ArrayItem>)Vector.empty());
        Vector items = Vector.empty();
        String prev = "";
        for (ParseTree child : ctx.children) {
            if (child instanceof MODLParser.Modl_array_itemContext) {
                items = items.append((Object)this.visitArrayItem((MODLParser.Modl_array_itemContext)child, arr));
            }
            if (child instanceof MODLParser.Modl_nb_arrayContext) {
                items = items.append((Object)this.visitNbArray((MODLParser.Modl_nb_arrayContext)child, arr));
            }
            if (prev.equals(child.getText())) {
                items = items.append((Object)NullPrimitive.instance);
            }
            prev = child.getText();
        }
        return arr.with(this.ancestry, (Vector<ArrayItem>)items);
    }

    private Array visitNbArray(MODLParser.Modl_nb_arrayContext ctx, Parent parent) {
        log.trace("visitNbArray()");
        Array arr = Array.of(this.ancestry, parent, (Vector<ArrayItem>)Vector.empty());
        Vector items = Vector.empty();
        String prev = "";
        for (ParseTree child : ctx.children) {
            if (child instanceof MODLParser.Modl_array_itemContext) {
                items = items.append((Object)this.visitArrayItem((MODLParser.Modl_array_itemContext)child, arr));
            }
            if (child instanceof MODLParser.Modl_arrayContext) {
                items = items.append((Object)this.visitArray((MODLParser.Modl_arrayContext)child, arr));
            }
            if (prev.equals(child.getText())) {
                items = items.append((Object)NullPrimitive.instance);
            }
            prev = child.getText();
        }
        return arr.with(this.ancestry, (Vector<ArrayItem>)items);
    }

    private ArrayItem visitArrayItem(MODLParser.Modl_array_itemContext ctx, Parent parent) {
        log.trace("visitArrayItem()");
        return ctx.modl_array_conditional() != null ? this.visitArrayConditional(ctx.modl_array_conditional(), parent) : this.visitArrayValueItem(ctx.modl_array_value_item(), parent);
    }

    private ArrayItem visitArrayValueItem(MODLParser.Modl_array_value_itemContext ctx, Parent parent) {
        log.trace("visitArrayValueItem()");
        return ctx.modl_array() != null ? this.visitArray(ctx.modl_array(), parent) : (ctx.modl_map() != null ? this.visitMap(ctx.modl_map(), parent) : (ctx.modl_pair() != null ? this.visitPair(ctx.modl_pair(), parent) : (ArrayItem)((Object)this.visitPrimitive(ctx.modl_primitive(), parent))));
    }

    private ArrayConditional visitArrayConditional(MODLParser.Modl_array_conditionalContext ctx, Parent parent) {
        log.trace("visitArrayConditional()");
        ArrayConditional ac = ArrayConditional.of(this.ancestry, parent, (Vector<ConditionTest>)Vector.empty(), (Vector<ArrayConditionalReturn>)Vector.empty(), (Vector<ArrayItem>)Vector.empty());
        Vector tests = ctx.modl_condition_test() != null ? Vector.ofAll(ctx.modl_condition_test().stream().map(ctx1 -> this.visitConditionTest((MODLParser.Modl_condition_testContext)((Object)ctx1), ac))) : null;
        Vector returns = ctx.modl_array_conditional_return() != null ? Vector.ofAll(ctx.modl_array_conditional_return().stream().map(ctx1 -> this.visitArrayConditionalReturn((MODLParser.Modl_array_conditional_returnContext)((Object)ctx1), ac))) : null;
        return ac.with(this.ancestry, (Vector<ConditionTest>)tests, (Vector<ArrayConditionalReturn>)returns);
    }

    private ArrayConditionalReturn visitArrayConditionalReturn(MODLParser.Modl_array_conditional_returnContext ctx, Parent parent) {
        log.trace("visitMapConditionalReturn()");
        ArrayConditionalReturn acr = ArrayConditionalReturn.of(this.ancestry, parent, (Vector<ArrayItem>)Vector.empty());
        Vector items = Vector.ofAll(ctx.modl_array_item().stream().map(ctx1 -> this.visitArrayItem((MODLParser.Modl_array_itemContext)((Object)ctx1), acr)));
        return acr.with(this.ancestry, (Vector<ArrayItem>)items);
    }

    private Map visitMap(MODLParser.Modl_mapContext ctx, Parent parent) {
        log.trace("visitMap()");
        Map map = Map.of(this.ancestry, parent, (Vector<MapItem>)Vector.empty());
        Vector items = Vector.ofAll(ctx.modl_map_item().stream().map(ctx1 -> this.visitMapItem((MODLParser.Modl_map_itemContext)((Object)ctx1), map)));
        return map.with(this.ancestry, (Vector<MapItem>)items);
    }

    private MapItem visitMapItem(MODLParser.Modl_map_itemContext ctx, Parent parent) {
        log.trace("visitMapItem()");
        return ctx.modl_pair() != null ? this.visitPair(ctx.modl_pair(), parent) : (ctx.modl_map_conditional() != null ? this.visitMapConditional(ctx.modl_map_conditional(), parent) : null);
    }

    private Pair visitPair(MODLParser.Modl_pairContext ctx, Parent parent) {
        log.trace("visitPair()");
        String key = Util.unquote(ctx.QUOTED() != null ? ctx.QUOTED().getText() : (ctx.STRING() != null ? ctx.STRING().getText() : null));
        if (this.inConditional == 0 && key != null && (key.contains("%") || key.contains(" "))) {
            throw new RuntimeException("Invalid key - spaces and % characters are not allowed: " + key);
        }
        Pair p = Pair.of(this.ancestry, parent, key, NullPrimitive.instance);
        ValueItem value = ctx.modl_array() != null ? this.visitArray(ctx.modl_array(), p) : (ctx.modl_map() != null ? this.visitMap(ctx.modl_map(), p) : (ctx.modl_value_item() != null ? this.visitValueItem(ctx.modl_value_item(), p) : null));
        assert (key != null);
        if (key.equals("*VERSION") || p.getKey().equals("*V")) {
            try {
                assert (value != null);
                int version = value.numericValue().intValue();
                if (version <= 0) {
                    throw new RuntimeException("Invalid MODL version: " + value.toString());
                }
                this.version = version;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid MODL version: " + value.toString());
            }
        }
        this.addImmutableName(key);
        return p.with(this.ancestry, key, value);
    }

    private ValueItem visitValueItem(MODLParser.Modl_value_itemContext ctx, Parent parent) {
        log.trace("visitValueItem()");
        if (ctx.modl_value() != null) {
            return this.visitValue(ctx.modl_value(), parent);
        }
        if (ctx.modl_value_conditional() != null) {
            return this.visitValueConditional(ctx.modl_value_conditional(), parent);
        }
        return null;
    }

    private ValueConditional visitValueConditional(MODLParser.Modl_value_conditionalContext ctx, Parent parent) {
        log.trace("visitValueConditional()");
        ValueConditional vc = ValueConditional.of(this.ancestry, parent, (Vector<ConditionTest>)Vector.empty(), (Vector<ValueConditionalReturn>)Vector.empty(), (Vector<ValueItem>)Vector.empty());
        Vector tests = ctx.modl_condition_test() != null ? Vector.ofAll(ctx.modl_condition_test().stream().map(ctx1 -> this.visitConditionTest((MODLParser.Modl_condition_testContext)((Object)ctx1), vc))) : null;
        Vector returns = ctx.modl_value_conditional_return() != null ? Vector.ofAll(ctx.modl_value_conditional_return().stream().map(ctx1 -> this.visitValueConditionReturn((MODLParser.Modl_value_conditional_returnContext)((Object)ctx1), vc))) : null;
        return vc.with(this.ancestry, (Vector<ConditionTest>)tests, (Vector<ValueConditionalReturn>)returns);
    }

    private ValueConditionalReturn visitValueConditionReturn(MODLParser.Modl_value_conditional_returnContext ctx, Parent parent) {
        log.trace("visitValueConditionalReturn()");
        ValueConditionalReturn vcr = ValueConditionalReturn.of(this.ancestry, parent, (Vector<ValueItem>)Vector.empty());
        Vector items = Vector.ofAll(ctx.modl_value_item().stream().map(ctx1 -> this.visitValueItem((MODLParser.Modl_value_itemContext)((Object)ctx1), vcr)));
        return vcr.with(this.ancestry, (Vector<ValueItem>)items);
    }

    private ValueItem visitValue(MODLParser.Modl_valueContext ctx, Parent parent) {
        log.trace("visitValue()");
        return ctx.modl_array() != null ? this.visitArray(ctx.modl_array(), parent) : (ctx.modl_map() != null ? this.visitMap(ctx.modl_map(), parent) : (ctx.modl_pair() != null ? this.visitPair(ctx.modl_pair(), parent) : (ctx.modl_nb_array() != null ? this.visitNbArray(ctx.modl_nb_array(), parent) : (ctx.modl_primitive() != null ? this.visitPrimitive(ctx.modl_primitive(), parent) : null))));
    }

    private ValueItem visitPrimitive(MODLParser.Modl_primitiveContext ctx, Parent parent) {
        log.trace("visitPrimitive()");
        return ctx.FALSE() != null ? FalsePrimitive.instance : (ctx.TRUE() != null ? TruePrimitive.instance : (ctx.STRING() != null ? StringPrimitive.of(this.ancestry, parent, Util.unquote(ctx.STRING().getText())) : (ctx.NULL() != null ? NullPrimitive.instance : (ctx.NUMBER() != null ? NumberPrimitive.of(this.ancestry, parent, ctx.NUMBER().getText()) : (ctx.QUOTED() != null ? StringPrimitive.of(this.ancestry, parent, Util.unquote(ctx.QUOTED().getText())) : null)))));
    }

    public Modl getModl() {
        return this.modl;
    }
}

