/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.ancestry;

import io.vavr.collection.Iterator;
import io.vavr.control.Option;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.Structure;

public class ScopedAncestrySearch {
    private final java.util.Map<Child, Parent> ancestors;

    public ScopedAncestrySearch(java.util.Map<Child, Parent> ancestors) {
        this.ancestors = ancestors;
    }

    public Option<Pair> findByKey(Child child, String key) {
        Option<Pair> result;
        Parent parent = this.ancestors.get(child);
        if (parent != null && (result = this.findByKey(0, parent, child, key)).isDefined() && !((Pair)result.get()).equals(child)) {
            return result;
        }
        return this.checkRootModlObjects(child, key, parent);
    }

    private Option<Pair> checkRootModlObjects(Child child, String key, Parent parent) {
        List roots = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        Pair found = null;
        for (Child root : roots) {
            if (!(root instanceof Modl)) continue;
            Modl modl = (Modl)root;
            found = this.findByKeyInModl(child, key, parent, found, modl);
        }
        return Option.of(found);
    }

    private Pair findByKeyInModl(Child child, String key, Parent parent, Pair found, Modl modl) {
        Structure s;
        Iterator iterator = modl.getStructures().iterator();
        while (iterator.hasNext() && !this.sameAsParentOrChild(child, parent, s = (Structure)iterator.next())) {
            if (!this.pairWithMatchingKey(key, s)) continue;
            found = (Pair)s;
        }
        return found;
    }

    private boolean pairWithMatchingKey(String key, Object o) {
        return o instanceof Pair && ((Pair)o).getKey().equals(key);
    }

    private boolean sameAsParentOrChild(Child child, Parent parent, Structure s) {
        return s != null && (s.equals(parent) || s.equals(child));
    }

    private Option<Pair> findByKey(int depth, Parent parent, Child child, String key) {
        if (this.matchingKeyButNotSelf(depth, child, key)) {
            return Option.of((Object)((Pair)child));
        }
        Option<Pair> found = child instanceof Array ? this.findByKeyInArray(parent, (Array)child, key) : (child instanceof Map ? this.findByKeyInMap(parent, (Map)child, key) : (child instanceof Modl ? this.findByKeyInModl((Modl)child, key) : Option.none()));
        if (found.isEmpty()) {
            return this.lookHigherUpTheTree(depth, parent, child, key);
        }
        return found;
    }

    private Option<Pair> lookHigherUpTheTree(int depth, Parent parent, Child child, String key) {
        Parent grandParent = this.ancestors.get((Child)((Object)parent));
        if (grandParent != null) {
            return this.findByKey(depth + 1, grandParent, (Child)((Object)parent), key);
        }
        return this.checkRootModlObjects(child, key, parent);
    }

    private boolean matchingKeyButNotSelf(int depth, Child child, String key) {
        return depth > 0 && child instanceof Pair && ((Pair)child).getKey().equals(key);
    }

    private Option<Pair> findByKeyInModl(Modl modl, String key) {
        Pair found = null;
        for (Structure s : modl.getStructures()) {
            if (!this.pairWithMatchingKey(key, s)) continue;
            found = (Pair)s;
        }
        return Option.of(found);
    }

    private Option<Pair> findByKeyInMap(Parent parent, Map map, String key) {
        MapItem mapItem;
        Pair found = null;
        Iterator iterator = map.getMapItems().iterator();
        while (iterator.hasNext() && !(mapItem = (MapItem)iterator.next()).equals(parent)) {
            if (!this.pairWithMatchingKey(key, mapItem)) continue;
            found = (Pair)mapItem;
        }
        return Option.of(found);
    }

    private Option<Pair> findByKeyInArray(Parent parent, Array array, String key) {
        ArrayItem arrayItem;
        Pair found = null;
        Iterator iterator = array.getArrayItems().iterator();
        while (iterator.hasNext() && !(arrayItem = (ArrayItem)iterator.next()).equals(parent)) {
            if (!this.pairWithMatchingKey(key, arrayItem)) continue;
            found = (Pair)arrayItem;
        }
        return Option.of(found);
    }
}

