/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.extractors;

import io.vavr.collection.Vector;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import uk.modl.model.Array;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.utils.Util;

public class StarLoadExtractor {
    private Vector<LoadSet> loadSets = Vector.empty();

    public static boolean isLoadInstruction(String key) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)key, (CharSequence[])new CharSequence[]{"*l", "*load"});
    }

    public StarLoadExtractor accept(Pair pair) {
        String key = pair.getKey();
        if (StarLoadExtractor.isLoadInstruction(key)) {
            Vector specs = this.getFilenames(pair.getValue()).map(Util::normalize);
            this.loadSets = this.loadSets.append((Object)new LoadSet(pair, specs));
        }
        return this;
    }

    public Vector<String> getFilenames(PairValue pairValue) {
        if (pairValue instanceof Primitive) {
            Primitive pv = (Primitive)pairValue;
            return Vector.of((Object)pv.toString());
        }
        if (pairValue instanceof Array) {
            Array a = (Array)pairValue;
            return Vector.ofAll((Iterable)a.getArrayItems().map(Objects::toString));
        }
        return Vector.empty();
    }

    public Vector<LoadSet> getLoadSets() {
        return this.loadSets;
    }

    public static final class LoadSet {
        private final Pair pair;
        private final Vector<FileSpec> fileSet;

        private LoadSet(Pair pair, Vector<FileSpec> fileSet) {
            this.pair = pair;
            this.fileSet = fileSet;
        }

        public static LoadSet of(Pair pair, Vector<FileSpec> fileSet) {
            return new LoadSet(pair, fileSet);
        }

        public Pair getPair() {
            return this.pair;
        }

        public Vector<FileSpec> getFileSet() {
            return this.fileSet;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadSet)) {
                return false;
            }
            LoadSet other = (LoadSet)o;
            Pair this$pair = this.getPair();
            Pair other$pair = other.getPair();
            if (this$pair == null ? other$pair != null : !((Object)this$pair).equals(other$pair)) {
                return false;
            }
            Vector<FileSpec> this$fileSet = this.getFileSet();
            Vector<FileSpec> other$fileSet = other.getFileSet();
            return !(this$fileSet == null ? other$fileSet != null : !this$fileSet.equals(other$fileSet));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pair $pair = this.getPair();
            result = result * 59 + ($pair == null ? 43 : ((Object)$pair).hashCode());
            Vector<FileSpec> $fileSet = this.getFileSet();
            result = result * 59 + ($fileSet == null ? 43 : $fileSet.hashCode());
            return result;
        }

        public String toString() {
            return "StarLoadExtractor.LoadSet(pair=" + this.getPair() + ", fileSet=" + this.getFileSet() + ")";
        }
    }

    public static final class FileSpec {
        private final String filename;
        private final boolean forceLoad;

        private FileSpec(String filename, boolean forceLoad) {
            this.filename = filename;
            this.forceLoad = forceLoad;
        }

        public static FileSpec of(String filename, boolean forceLoad) {
            return new FileSpec(filename, forceLoad);
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean isForceLoad() {
            return this.forceLoad;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSpec)) {
                return false;
            }
            FileSpec other = (FileSpec)o;
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            return this.isForceLoad() == other.isForceLoad();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            result = result * 59 + (this.isForceLoad() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "StarLoadExtractor.FileSpec(filename=" + this.getFilename() + ", forceLoad=" + this.isForceLoad() + ")";
        }
    }
}

