/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.Tuple2;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.io.IOUtils;
import uk.modl.interpreter.InterpreterVisitor;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.parser.Parser;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.transforms.JacksonJsonNodeTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.Util;

public class Interpreter {
    private final Parser parser = new Parser();
    private final InterpreterVisitor interpreterVisitor = new InterpreterVisitor();

    public Modl interpret(String modlString) {
        TransformationContext ctx = TransformationContext.baseCtx(null);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return (Modl)interpreted._2;
    }

    public Modl interpret(URL url) throws IOException {
        String modlString = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        TransformationContext ctx = TransformationContext.baseCtx(url);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return (Modl)interpreted._2;
    }

    public Modl interpret(String modlString, URL url) {
        TransformationContext ctx = TransformationContext.baseCtx(url);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return (Modl)interpreted._2;
    }

    public JsonNode interpretToJsonObject(String modlString) {
        TransformationContext ctx = TransformationContext.baseCtx(null);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
    }

    public JsonNode interpretToJsonObject(URL url) throws IOException {
        String modlString = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        TransformationContext ctx = TransformationContext.baseCtx(url);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
    }

    public JsonNode interpretToJsonObject(String modlString, URL url) {
        TransformationContext ctx = TransformationContext.baseCtx(url);
        Tuple2<TransformationContext, Modl> interpreted = this.apply(ctx, modlString);
        return new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
    }

    public String interpretToJsonString(String modlString, URL url) throws JsonProcessingException {
        JsonNode jsonNode = this.interpretToJsonObject(modlString, url);
        return new ObjectMapper().writeValueAsString((Object)jsonNode);
    }

    public String interpretToPrettyJsonString(String modlString) throws JsonProcessingException {
        JsonNode jsonNode = this.interpretToJsonObject(modlString, null);
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    public String interpretToPrettyJsonString(URL url) throws IOException {
        String modlString = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        JsonNode jsonNode = this.interpretToJsonObject(modlString, url);
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    public String interpretToPrettyJsonString(String modlString, URL url) throws JsonProcessingException {
        JsonNode jsonNode = this.interpretToJsonObject(modlString, url);
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)input).map(s -> this.parse(ctx, (String)s)).map(modl -> this.apply(ctx, (Modl)modl)).get();
    }

    public Modl parse(TransformationContext ctx, @NonNull String modlString) {
        if (modlString == null) {
            throw new NullPointerException("modlString is marked non-null but is null");
        }
        try {
            Modl modl = this.parser.apply(modlString, ctx.getAncestry());
            Vector filtered = modl.getStructures().filter(Util::shouldAppearInOutput);
            int numberOfTopLevelPairs = filtered.count(s -> s instanceof Pair);
            if (numberOfTopLevelPairs > 0 && numberOfTopLevelPairs < filtered.size()) {
                throw new InterpreterError("Interpreter Error: Mixed top-level types are not allowed.");
            }
            return modl;
        }
        catch (InterpreterError e) {
            throw e;
        }
        catch (ParseCancellationException e) {
            throw new InterpreterError("Parser Error: " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new InterpreterError("Interpreter Error: " + e.getMessage());
        }
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull Modl modl) {
        if (modl == null) {
            throw new NullPointerException("modl is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)modl).map(m -> this.interpreterVisitor.apply(ctx, (Modl)m)).get();
    }
}

