/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionTest;
import uk.modl.model.ValueConditionalReturn;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;

public final class ValueConditional
implements ValueItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ConditionTest> tests;
    @NonNull
    private final Vector<ValueConditionalReturn> returns;
    @NonNull
    private final Vector<ValueItem> result;

    public static ValueConditional of(Ancestry ancestry, Parent parent, Vector<ConditionTest> tests, Vector<ValueConditionalReturn> returns, Vector<ValueItem> result) {
        ValueConditional child = ValueConditional.of(IDSource.nextId(), tests, returns, result);
        ancestry.add(parent, child);
        return child;
    }

    @Override
    public Number numericValue() {
        throw new RuntimeException("Cannot convert a conditional to a numeric value.");
    }

    public ValueConditional with(Ancestry ancestry, Vector<ConditionTest> tests, Vector<ValueConditionalReturn> returns) {
        ValueConditional child = ValueConditional.of(this.id, tests, returns, this.result);
        ancestry.replaceChild(this, child);
        return child;
    }

    public ValueConditional with(Ancestry ancestry, Vector<ValueItem> result) {
        ValueConditional child = ValueConditional.of(this.id, this.tests, this.returns, result);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ValueConditional(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<ValueConditionalReturn> returns, @NonNull Vector<ValueItem> result) {
        if (tests == null) {
            throw new NullPointerException("tests is marked non-null but is null");
        }
        if (returns == null) {
            throw new NullPointerException("returns is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.id = id;
        this.tests = tests;
        this.returns = returns;
        this.result = result;
    }

    public static ValueConditional of(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<ValueConditionalReturn> returns, @NonNull Vector<ValueItem> result) {
        return new ValueConditional(id, tests, returns, result);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ConditionTest> getTests() {
        return this.tests;
    }

    @NonNull
    public Vector<ValueConditionalReturn> getReturns() {
        return this.returns;
    }

    @NonNull
    public Vector<ValueItem> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueConditional)) {
            return false;
        }
        ValueConditional other = (ValueConditional)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ValueConditional(tests=" + this.getTests() + ", returns=" + this.getReturns() + ", result=" + this.getResult() + ")";
    }
}

