/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionTest;
import uk.modl.model.MapConditionalReturn;
import uk.modl.model.MapItem;
import uk.modl.utils.IDSource;

public final class MapConditional
implements MapItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ConditionTest> tests;
    @NonNull
    private final Vector<MapConditionalReturn> returns;
    @NonNull
    private final Vector<MapItem> result;

    public static MapConditional of(Ancestry ancestry, Parent parent, Vector<ConditionTest> tests, Vector<MapConditionalReturn> returns, Vector<MapItem> result) {
        MapConditional child = MapConditional.of(IDSource.nextId(), tests, returns, result);
        ancestry.add(parent, child);
        return child;
    }

    public MapConditional with(Ancestry ancestry, Vector<ConditionTest> tests, Vector<MapConditionalReturn> returns) {
        MapConditional child = MapConditional.of(this.id, tests, returns, this.result);
        ancestry.replaceChild(this, child);
        return child;
    }

    public MapConditional with(Ancestry ancestry, Vector<MapItem> result) {
        MapConditional child = MapConditional.of(this.id, this.tests, this.returns, result);
        ancestry.replaceChild(this, child);
        return child;
    }

    private MapConditional(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<MapConditionalReturn> returns, @NonNull Vector<MapItem> result) {
        if (tests == null) {
            throw new NullPointerException("tests is marked non-null but is null");
        }
        if (returns == null) {
            throw new NullPointerException("returns is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.id = id;
        this.tests = tests;
        this.returns = returns;
        this.result = result;
    }

    public static MapConditional of(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<MapConditionalReturn> returns, @NonNull Vector<MapItem> result) {
        return new MapConditional(id, tests, returns, result);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ConditionTest> getTests() {
        return this.tests;
    }

    @NonNull
    public Vector<MapConditionalReturn> getReturns() {
        return this.returns;
    }

    @NonNull
    public Vector<MapItem> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapConditional)) {
            return false;
        }
        MapConditional other = (MapConditional)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "MapConditional(tests=" + this.getTests() + ", returns=" + this.getReturns() + ", result=" + this.getResult() + ")";
    }
}

