/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import io.vavr.Tuple2;
import io.vavr.control.Option;
import lombok.NonNull;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import uk.modl.interpreter.InterpreterVisitor;
import uk.modl.model.Modl;
import uk.modl.parser.Parser;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.transforms.TransformationContext;

public class Interpreter {
    private final Parser parser = new Parser();
    private final InterpreterVisitor interpreterVisitor = new InterpreterVisitor();

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)input).map(s -> {
            try {
                return this.parser.apply((String)s, ctx.getAncestry());
            }
            catch (InterpreterError e) {
                throw e;
            }
            catch (ParseCancellationException e) {
                throw new InterpreterError("Parser Error: " + e.getMessage());
            }
            catch (RuntimeException e) {
                throw new InterpreterError("Interpreter Error: " + e.getMessage());
            }
        }).map(modl -> this.apply(ctx, (Modl)modl)).get();
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, @NonNull Modl modl) {
        if (modl == null) {
            throw new NullPointerException("modl is marked non-null but is null");
        }
        return (Tuple2)Option.of((Object)modl).map(m -> this.interpreterVisitor.apply(ctx, (Modl)m)).get();
    }
}

