/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.server;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import uk.modl.interpreter.Interpreter;
import uk.modl.modlObject.ModlObject;
import uk.modl.parser.printers.JsonPrinter;

public class ModlServer
extends AbstractHandler {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        server.setHandler((Handler)new ModlServer());
        server.start();
        server.join();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charSet=UTF-8");
        response.addHeader("Access-Control-Allow-Origin", "*");
        String modlInput = request.getParameter("modl");
        ModlObject modlObject = null;
        try {
            if (modlInput != null) {
                modlObject = Interpreter.interpret(modlInput, new ArrayList<String>());
            }
            String jsonOutput = JsonPrinter.printModl(modlObject);
            response.setStatus(200);
            baseRequest.setHandled(true);
            response.getWriter().println(jsonOutput);
        }
        catch (Exception e) {
            response.setStatus(400);
            baseRequest.setHandled(true);
            response.getWriter().println(e.getMessage());
        }
    }
}

