/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.ModlParsed;
import uk.modl.parser.Parser;
import uk.modl.parser.RawModlObject;

public class ModlObjectCreator {
    public static int MODL_VERSION = 1;

    public static RawModlObject processModlParsed(String input) throws IOException {
        ModlParsed modlParsed = Parser.parse(input);
        return ModlObjectCreator.processModlParsed(modlParsed);
    }

    private static RawModlObject processModlParsed(ModlParsed modlParsed) {
        RawModlObject rawModlObject = new RawModlObject();
        for (ModlParsed.Structure parsedStructure : modlParsed.getStructures()) {
            List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(rawModlObject, parsedStructure);
            if (structures == null) continue;
            for (ModlObject.Structure structure : structures) {
                if (structure == null) continue;
                rawModlObject.addStructure(structure);
            }
        }
        return rawModlObject;
    }

    private static List<ModlObject.Structure> processModlParsed(RawModlObject rawModlObject, ModlParsed.Structure parsedStructure) {
        if (parsedStructure == null) {
            return null;
        }
        List<ModlObject.Structure> structures = new LinkedList<ModlObject.Structure>();
        ModlObject.Structure structure = null;
        structure = ModlObjectCreator.processModlParsed(rawModlObject, parsedStructure.getMap());
        if (structure != null) {
            structures.add(structure);
            return structures;
        }
        structure = ModlObjectCreator.processModlParsed(rawModlObject, parsedStructure.getArray());
        if (structure != null) {
            structures.add(structure);
            return structures;
        }
        structures = ModlObjectCreator.processModlParsed(rawModlObject, parsedStructure.getPair());
        if (structures != null) {
            return structures;
        }
        structure = ModlObjectCreator.processModlParsed(rawModlObject, parsedStructure.getTopLevelConditional());
        structures = new LinkedList();
        structures.add(structure);
        return structures;
    }

    private static ModlObject.Map processModlParsed(RawModlObject rawModlObject, ModlParsed.Map parsedMap) {
        if (parsedMap == null) {
            return null;
        }
        ModlObject.Map map = rawModlObject.new ModlObject.Map();
        if (parsedMap.getMapItems() != null) {
            for (ModlParsed.MapItem mapItemParsed : parsedMap.getMapItems()) {
                ModlObject.Pair pair = ModlObjectCreator.processModlParsed(rawModlObject, mapItemParsed);
                if (pair == null) continue;
                map.addPair(pair);
            }
        }
        return map;
    }

    private static ModlObject.Pair processModlParsed(RawModlObject rawModlObject, ModlParsed.MapItem parsedMapItem) {
        if (parsedMapItem == null) {
            return null;
        }
        RawModlObject.MapConditional pair = null;
        pair = ModlObjectCreator.processModlParsed(rawModlObject, parsedMapItem.getMapConditional());
        if (pair != null) {
            return pair;
        }
        List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(rawModlObject, parsedMapItem.getPair());
        if (structures.size() > 0) {
            return (ModlObject.Pair)structures.get(0);
        }
        return null;
    }

    private static ModlValue processModlParsed(RawModlObject rawModlObject, ModlParsed.Value parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        ModlValue value = null;
        List<ModlObject.Structure> pairs = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getPair());
        if (pairs != null && pairs.size() > 0) {
            return pairs.get(0);
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getMap());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getNbArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getQuoted());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getNumber());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getTrueVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getFalseVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getNullVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getString());
        if (value != null) {
            return value;
        }
        return value;
    }

    private static ModlValue processModlParsed(RawModlObject rawModlObject, ModlParsed.ArrayValueItem parsedValue) {
        if (parsedValue == null) {
            return null;
        }
        ModlValue value = null;
        List<ModlObject.Structure> pairs = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getPair());
        if (pairs != null && pairs.size() > 0) {
            return pairs.get(0);
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getMap());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getArray());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getQuoted());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getNumber());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getTrueVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getFalseVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getNullVal());
        if (value != null) {
            return value;
        }
        value = ModlObjectCreator.processModlParsed(rawModlObject, parsedValue.getString());
        if (value != null) {
            return value;
        }
        return value;
    }

    private static RawModlObject.ConditionTest processModlParsed(RawModlObject rawModlObject, ModlParsed.ConditionTest conditionTestParsed) {
        if (conditionTestParsed == null) {
            return null;
        }
        RawModlObject.ConditionTest conditionTest = rawModlObject.new RawModlObject.ConditionTest();
        for (ImmutablePair<ModlParsed.SubCondition, ImmutablePair<String, Boolean>> subConditionPair : conditionTestParsed.subConditionList) {
            ModlParsed.SubCondition subCondition = (ModlParsed.SubCondition)subConditionPair.getLeft();
            ImmutablePair operatorPair = (ImmutablePair)subConditionPair.getRight();
            String operator = (String)operatorPair.getLeft();
            Boolean shouldNegate = (Boolean)operatorPair.getRight();
            if (subCondition instanceof ModlParsed.ConditionGroup) {
                RawModlObject.ConditionGroup conditionGroup = ModlObjectCreator.processModlParsed(rawModlObject, (ModlParsed.ConditionGroup)subCondition);
                conditionTest.addSubCondition(operator, shouldNegate, conditionGroup);
                continue;
            }
            if (!(subCondition instanceof ModlParsed.Condition)) continue;
            RawModlObject.Condition condition = ModlObjectCreator.processModlParsed(rawModlObject, (ModlParsed.Condition)subCondition);
            conditionTest.addSubCondition(operator, shouldNegate, condition);
        }
        return conditionTest;
    }

    private static RawModlObject.Condition processModlParsed(RawModlObject rawModlObject, ModlParsed.Condition conditionParsed) {
        if (conditionParsed == null) {
            return null;
        }
        String key = conditionParsed.key;
        String operator = conditionParsed.operator;
        LinkedList<ModlValue> values = new LinkedList<ModlValue>();
        for (ModlParsed.Value valueParsed : conditionParsed.values) {
            ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed);
            values.add(value);
        }
        RawModlObject rawModlObject2 = rawModlObject;
        rawModlObject2.getClass();
        RawModlObject.Condition condition = rawModlObject2.new RawModlObject.Condition(key, operator, values);
        return condition;
    }

    private static RawModlObject.ConditionGroup processModlParsed(RawModlObject rawModlObject, ModlParsed.ConditionGroup conditionGroupParsed) {
        if (conditionGroupParsed == null) {
            return null;
        }
        RawModlObject.ConditionGroup conditionGroup = rawModlObject.new RawModlObject.ConditionGroup();
        for (ImmutablePair<ModlParsed.ConditionTest, String> conditionTestPair : conditionGroupParsed.conditionsTestList) {
            ModlParsed.ConditionTest conditionTestParsed = (ModlParsed.ConditionTest)conditionTestPair.getLeft();
            String operator = (String)conditionTestPair.getRight();
            RawModlObject.ConditionTest conditionTest = ModlObjectCreator.processModlParsed(rawModlObject, conditionTestParsed);
            conditionGroup.addConditionTest(conditionTest, operator);
        }
        return conditionGroup;
    }

    private static List<ModlObject.Structure> processModlParsed(RawModlObject rawModlObject, ModlParsed.Pair pairParsed) {
        ModlObject.Array array;
        if (pairParsed == null) {
            return null;
        }
        ModlObject.Pair pair = rawModlObject.new ModlObject.Pair();
        RawModlObject rawModlObject2 = rawModlObject;
        rawModlObject2.getClass();
        pair.setKey(rawModlObject2.new ModlObject.String(pairParsed.getKey()));
        if (pairParsed.getKey() != null && (pairParsed.getKey().toLowerCase().equals("*l") || pairParsed.getKey().toLowerCase().equals("*load"))) {
            return ModlObjectCreator.processImportStatement(rawModlObject, pairParsed);
        }
        ModlObject.Map map = ModlObjectCreator.processModlParsed(rawModlObject, pairParsed.getMap());
        if (map != null) {
            pair.addModlValue(map);
        }
        if ((array = ModlObjectCreator.processModlParsed(rawModlObject, pairParsed.getArray())) != null) {
            pair.addModlValue(array);
        }
        if (pairParsed.getValueItem() != null) {
            pair.addModlValue(ModlObjectCreator.processModlParsed(rawModlObject, pairParsed.getValueItem(), pair));
        }
        LinkedList<ModlObject.Structure> pairs = new LinkedList<ModlObject.Structure>();
        pairs.add(pair);
        return pairs;
    }

    private static List<ModlObject.Structure> processImportStatement(RawModlObject rawModlObject, ModlParsed.Pair pairParsed) {
        LinkedList<ModlObject.Structure> structures = new LinkedList<ModlObject.Structure>();
        ModlObject.Array array = ModlObjectCreator.processModlParsed(rawModlObject, pairParsed.getArray());
        if (array == null && pairParsed.getValueItem() != null && pairParsed.getValueItem().getValue() != null) {
            array = ModlObjectCreator.processModlParsed(rawModlObject, pairParsed.getValueItem().getValue().getNbArray());
        }
        if (array != null) {
            int count = 0;
            boolean isFinal = false;
            for (ModlValue v : array.getValues()) {
                if (count++ == array.getValues().size()) {
                    isFinal = true;
                }
                ModlObject.Pair pair = rawModlObject.new ModlObject.Pair();
                String key = pairParsed.getKey();
                if (!isFinal) {
                    key = key.toLowerCase();
                }
                RawModlObject rawModlObject2 = rawModlObject;
                rawModlObject2.getClass();
                pair.setKey(rawModlObject2.new ModlObject.String(key));
                pair.addModlValue(v);
                structures.add(pair);
            }
        } else if (pairParsed.getValueItem() != null) {
            ModlObject.Pair pair = rawModlObject.new ModlObject.Pair();
            RawModlObject rawModlObject3 = rawModlObject;
            rawModlObject3.getClass();
            pair.setKey(rawModlObject3.new ModlObject.String(pairParsed.getKey()));
            ModlParsed.ValueItem valueParsed = pairParsed.getValueItem();
            ModlValue v = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed, pair);
            pair.addModlValue(v);
            structures.add(pair);
        }
        return structures;
    }

    private static ModlObject.Array processModlParsed(RawModlObject rawModlObject, ModlParsed.Array arrayParsed) {
        if (arrayParsed == null) {
            return null;
        }
        ModlObject.Array array = rawModlObject.new ModlObject.Array();
        if (arrayParsed.getAbstractArrayItems() != null) {
            for (ModlParsed.AbstractArrayItem arrayItemParsed : arrayParsed.getAbstractArrayItems()) {
                if (arrayItemParsed instanceof ModlParsed.ArrayItem) {
                    ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, (ModlParsed.ArrayItem)arrayItemParsed);
                    if (value == null) continue;
                    array.addValue(value);
                    continue;
                }
                if (!(arrayItemParsed instanceof ModlParsed.NbArray)) continue;
                ModlObject.Array nbArray = rawModlObject.new ModlObject.Array();
                for (ModlParsed.ArrayItem ai : ((ModlParsed.NbArray)arrayItemParsed).getArrayItems()) {
                    ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, ai);
                    if (value == null) continue;
                    nbArray.addValue(value);
                }
                array.addValue(nbArray);
            }
        }
        return array;
    }

    private static ModlObject.Array processModlParsed(RawModlObject rawModlObject, ModlParsed.NbArray nbArray) {
        if (nbArray == null || nbArray.getArrayItems().size() == 0) {
            return null;
        }
        ModlObject.Array array = rawModlObject.new ModlObject.Array();
        for (ModlParsed.ArrayItem arrayItem : nbArray.getArrayItems()) {
            ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, arrayItem);
            array.addValue(value);
        }
        return array;
    }

    private static ModlValue processModlParsed(RawModlObject rawModlObject, ModlParsed.ArrayItem arrayItemParsed) {
        if (arrayItemParsed == null) {
            return null;
        }
        ModlValue value = null;
        if (arrayItemParsed.getArrayConditional() != null) {
            value = ModlObjectCreator.processModlParsed(rawModlObject, arrayItemParsed.getArrayConditional());
        }
        if (arrayItemParsed.getArrayValueItem() != null) {
            value = ModlObjectCreator.processModlParsed(rawModlObject, arrayItemParsed.getArrayValueItem());
        }
        return value;
    }

    private static ModlValue processModlParsed(RawModlObject rawModlObject, ModlParsed.ValueItem valueItemParsed, ModlObject.Pair parentPair) {
        if (valueItemParsed == null) {
            return null;
        }
        ModlValue value = null;
        if (valueItemParsed.getValueConditional() != null) {
            value = ModlObjectCreator.processModlParsed(rawModlObject, valueItemParsed.getValueConditional(), parentPair);
        }
        if (valueItemParsed.getValue() != null) {
            value = ModlObjectCreator.processModlParsed(rawModlObject, valueItemParsed.getValue());
        }
        return value;
    }

    private static ModlObject.False processModlParsed(RawModlObject rawModlObject, ModlParsed.False falseVal) {
        if (falseVal != null) {
            ModlObject.False f = rawModlObject.new ModlObject.False();
            return f;
        }
        return null;
    }

    private static ModlObject.Null processModlParsed(RawModlObject rawModlObject, ModlParsed.Null val) {
        if (val != null) {
            ModlObject.Null n = rawModlObject.new ModlObject.Null();
            return n;
        }
        return null;
    }

    private static ModlObject.True processModlParsed(RawModlObject rawModlObject, ModlParsed.True trueVal) {
        if (trueVal != null) {
            ModlObject.True t = rawModlObject.new ModlObject.True();
            return t;
        }
        return null;
    }

    private static ModlObject.Number processModlParsed(RawModlObject rawModlObject, ModlParsed.Number number) {
        if (number != null) {
            RawModlObject rawModlObject2 = rawModlObject;
            rawModlObject2.getClass();
            ModlObject.Number n = rawModlObject2.new ModlObject.Number(number.string);
            return n;
        }
        return null;
    }

    private static ModlObject.String processModlParsed(RawModlObject rawModlObject, ModlParsed.String string) {
        if (string != null) {
            RawModlObject rawModlObject2 = rawModlObject;
            rawModlObject2.getClass();
            ModlObject.String str = rawModlObject2.new ModlObject.String(string.string);
            return str;
        }
        return null;
    }

    private static ModlObject.String processModlParsed(RawModlObject rawModlObject, ModlParsed.Quoted quoted) {
        if (quoted != null) {
            String s = quoted.string;
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            RawModlObject rawModlObject2 = rawModlObject;
            rawModlObject2.getClass();
            ModlObject.String str = rawModlObject2.new ModlObject.String(s);
            return str;
        }
        return null;
    }

    private static RawModlObject.ValueConditional processModlParsed(RawModlObject rawModlObject, ModlParsed.ValueConditional conditionalParsed, ModlObject.Pair parentPair) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.ValueConditional conditional = rawModlObject.new RawModlObject.ValueConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.ValueConditionalReturn> conditionalParsedEntry : conditionalParsed.getValueConditionalReturns().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getValue(), parentPair));
        }
        return conditional;
    }

    private static RawModlObject.ValueConditionalReturn processModlParsed(RawModlObject rawModlObject, ModlParsed.ValueConditionalReturn conditionalReturnParsed, ModlObject.Pair parentPair) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.ValueConditionalReturn conditionalReturn = rawModlObject.new RawModlObject.ValueConditionalReturn();
        if (conditionalReturnParsed.getValueItems() != null) {
            for (ModlParsed.ValueItem valueParsed : conditionalReturnParsed.getValueItems()) {
                ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed, parentPair);
                conditionalReturn.addValue(value);
            }
        }
        return conditionalReturn;
    }

    private static ModlValue processModlParsed(RawModlObject rawModlObject, ModlParsed.ArrayConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.ArrayConditional conditional = rawModlObject.new RawModlObject.ArrayConditional();
        if (conditionalParsed.getArrayConditionalReturns() != null) {
            for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.ArrayConditionalReturn> conditionalParsedEntry : conditionalParsed.getArrayConditionalReturns().entrySet()) {
                conditional.addConditional(ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getValue()));
            }
        }
        return conditional;
    }

    private static RawModlObject.ArrayConditionalReturn processModlParsed(RawModlObject rawModlObject, ModlParsed.ArrayConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.ArrayConditionalReturn conditionalReturn = rawModlObject.new RawModlObject.ArrayConditionalReturn();
        if (conditionalReturnParsed.getArrayItems() != null) {
            for (ModlParsed.ArrayItem valueParsed : conditionalReturnParsed.getArrayItems()) {
                ModlValue value = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed);
                conditionalReturn.addValue(value);
            }
        }
        return conditionalReturn;
    }

    private static RawModlObject.MapConditional processModlParsed(RawModlObject rawModlObject, ModlParsed.MapConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.MapConditional conditional = rawModlObject.new RawModlObject.MapConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.MapConditionalReturn> conditionalParsedEntry : conditionalParsed.getMapConditionals().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getValue()));
        }
        return conditional;
    }

    private static ModlObject.Map processModlParsed(RawModlObject rawModlObject, ModlParsed.MapConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        ModlObject.Map map = rawModlObject.new ModlObject.Map();
        if (conditionalReturnParsed.getMapItems() != null) {
            for (ModlParsed.MapItem valueParsed : conditionalReturnParsed.getMapItems()) {
                ModlObject.Pair p = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed);
                map.addPair(p);
            }
        }
        return map;
    }

    private static RawModlObject.TopLevelConditional processModlParsed(RawModlObject rawModlObject, ModlParsed.TopLevelConditional conditionalParsed) {
        if (conditionalParsed == null) {
            return null;
        }
        RawModlObject.TopLevelConditional conditional = rawModlObject.new RawModlObject.TopLevelConditional();
        for (Map.Entry<ModlParsed.ConditionTest, ModlParsed.TopLevelConditionalReturn> conditionalParsedEntry : conditionalParsed.getTopLevelConditionalReturns().entrySet()) {
            conditional.addConditional(ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getKey()), ModlObjectCreator.processModlParsed(rawModlObject, conditionalParsedEntry.getValue()));
        }
        return conditional;
    }

    private static RawModlObject.TopLevelConditionalReturn processModlParsed(RawModlObject rawModlObject, ModlParsed.TopLevelConditionalReturn conditionalReturnParsed) {
        if (conditionalReturnParsed == null) {
            return null;
        }
        RawModlObject.TopLevelConditionalReturn conditionalReturn = rawModlObject.new RawModlObject.TopLevelConditionalReturn();
        if (conditionalReturnParsed.getStructures() != null) {
            for (ModlParsed.Structure valueParsed : conditionalReturnParsed.getStructures()) {
                List<ModlObject.Structure> structures = ModlObjectCreator.processModlParsed(rawModlObject, valueParsed);
                conditionalReturn.addStructure(structures.get(0));
            }
        }
        return conditionalReturn;
    }
}

