/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import uk.modl.interpreter.FileLoader;
import uk.modl.interpreter.ModlClassLoader;
import uk.modl.interpreter.RequireRestart;
import uk.modl.interpreter.StringTransformer;
import uk.modl.interpreter.VariableLoader;
import uk.modl.interpreter.VariableMethodLoader;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.ModlObjectCreator;
import uk.modl.parser.RawModlObject;
import uk.modl.parser.printers.JsonPrinter;

public class Interpreter {
    private static final String IDENTIFIER_REGEX = "\\?|((_|\\*)?[a-zA-Z][0-9a-zA-Z_]*)";
    Map<String, Map<String, Object>> klasses = new LinkedHashMap<String, Map<String, Object>>();
    Map<String, ModlValue> variables = new HashMap<String, ModlValue>();
    Map<Integer, ModlValue> numberedVariables = new HashMap<Integer, ModlValue>();
    Set<String> pairNames;
    Map<String, ModlValue> valuePairs;

    public static String parseToJson(String input) throws IOException {
        ModlObject modlObject = Interpreter.interpret(input);
        JsonPrinter jsonPrinter = new JsonPrinter();
        String json = JsonPrinter.printModl(modlObject);
        return json;
    }

    public static ModlObject interpret(String input) throws IOException {
        RawModlObject rawModlObject = ModlObjectCreator.processModlParsed(input);
        return Interpreter.interpret(rawModlObject);
    }

    public static ModlObject interpret(RawModlObject rawModlObject) {
        Interpreter interpreter = new Interpreter();
        ModlObject modlObject = null;
        while (modlObject == null) {
            try {
                modlObject = interpreter.interpretPrivate(rawModlObject);
            }
            catch (RequireRestart requireRestart) {}
        }
        return modlObject;
    }

    private ModlObject interpretPrivate(RawModlObject rawModlObject) throws RequireRestart {
        ModlObject modlObject = new ModlObject();
        ModlClassLoader.loadModlKlassO(rawModlObject, this.klasses);
        this.pairNames = new HashSet<String>();
        this.valuePairs = new HashMap<String, ModlValue>();
        boolean startedInterpreting = false;
        boolean needRestart = false;
        RawModlObject loadedRawModlObject = null;
        String importFileValue = null;
        for (ModlObject.Structure rawStructure : rawModlObject.getStructures()) {
            List<ModlObject.Structure> structures;
            if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.equals("*V") || ((ModlObject.Pair)rawStructure).getKey().string.equals("*VERSION"))) {
                String versionString = ((ModlObject.Number)((ModlObject.Pair)rawStructure).getModlValue()).number;
                if (versionString.equals(String.valueOf(ModlObjectCreator.MODL_VERSION))) continue;
                throw new UnsupportedOperationException("Can't handle MODL version " + versionString);
            }
            if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.equals("*I") || ((ModlObject.Pair)rawStructure).getKey().string.equals("*IMPORT"))) {
                if (startedInterpreting) {
                    // empty if block
                }
                if (((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.String) {
                    importFileValue = ((ModlObject.String)((ModlObject.Pair)rawStructure).getModlValue()).string;
                    loadedRawModlObject = this.loadConfigFile(importFileValue);
                    needRestart = true;
                    break;
                }
                if (!(((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.Number)) continue;
                importFileValue = ((ModlObject.Number)((ModlObject.Pair)rawStructure).getModlValue()).number.toString();
                loadedRawModlObject = this.loadConfigFile(importFileValue);
                needRestart = true;
                break;
            }
            if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.equals("*class") || ((ModlObject.Pair)rawStructure).getKey().string.equals("*c") || ((ModlObject.Pair)rawStructure).getKey().string.equals("*m") || ((ModlObject.Pair)rawStructure).getKey().string.equals("*method") || ((ModlObject.Pair)rawStructure).getKey().string.equals("?"))) {
                ModlObject.Pair pair = (ModlObject.Pair)rawStructure;
                if (pair.getKey().string.equals("*class") || pair.getKey().string.equals("*c")) {
                    ModlClassLoader.loadClass(rawStructure, this.klasses);
                    continue;
                }
                if (pair.getKey().string.equals("*method") || pair.getKey().string.equals("*m")) {
                    VariableMethodLoader.loadVariableMethod(pair);
                } else if (pair.getKey().string.equals("?")) {
                    VariableLoader.loadConfigNumberedVariables(pair.getModlValue(), this.numberedVariables);
                } else if (pair.getKey().string.startsWith("_")) {
                    VariableLoader.loadConfigVar(pair.getKey().string.replaceFirst("_", ""), pair, this.variables);
                } else if (pair.getKey().string.startsWith("*")) {
                    throw new RuntimeException("Unrecognised configuration instruction : " + pair.getKey());
                }
            } else if (!(rawStructure instanceof ModlObject.Pair) || ((ModlObject.Pair)rawStructure).getKey() == null || ((ModlObject.Pair)rawStructure).getKey().string == null || !((ModlObject.Pair)rawStructure).getKey().string.equals("*V") && !((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*VERSION")) {
                if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && ((ModlObject.Pair)rawStructure).getKey().string.startsWith("*")) {
                    throw new RuntimeException("Unrecognised configuration instruction : " + ((ModlObject.Pair)rawStructure).getKey().string);
                }
                startedInterpreting = true;
            } else if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && ((ModlObject.Pair)rawStructure).getKey().string.startsWith("*")) {
                throw new RuntimeException("Unrecognised configuration instruction : " + ((ModlObject.Pair)rawStructure).getKey().string);
            }
            if ((structures = this.interpret(modlObject, rawStructure)) == null) continue;
            for (ModlObject.Structure structure : structures) {
                modlObject.addStructure(structure);
            }
        }
        if (needRestart) {
            rawModlObject.replaceFirstImport(importFileValue, loadedRawModlObject);
            throw new RequireRestart();
        }
        return modlObject;
    }

    private RawModlObject loadConfigFile(String location) {
        ModlValue value = this.transformString(location);
        if (!(value instanceof ModlObject.String)) {
            throw new RuntimeException("Was expecting String for location, but got " + value.getClass());
        }
        location = ((ModlObject.String)value).string;
        RawModlObject rawModlObject = FileLoader.loadFile(location);
        return rawModlObject;
    }

    private List<ModlObject.Structure> interpret(ModlObject modlObject, ModlObject.Structure rawStructure) {
        if (rawStructure == null) {
            return null;
        }
        LinkedList<ModlObject.Structure> structures = new LinkedList();
        if (!(rawStructure instanceof RawModlObject.TopLevelConditional)) {
            ModlObject.Pair pair;
            ModlObject.Structure structure = null;
            if (rawStructure instanceof ModlObject.Map && (structure = this.interpret(modlObject, (ModlObject.Map)rawStructure, null)) != null) {
                structures.add(structure);
            }
            if (rawStructure instanceof ModlObject.Array && (structure = this.interpret(modlObject, (ModlObject.Array)rawStructure, null)) != null) {
                structures.add(structure);
            }
            if (rawStructure instanceof ModlObject.Pair && (pair = (ModlObject.Pair)(structure = this.interpret(modlObject, (ModlObject.Pair)rawStructure, null))) != null && pair.getKey() != null && pair.getKey().string != null && !pair.getKey().string.startsWith("_") && !pair.getKey().string.startsWith("*") && !pair.getKey().string.equals("?")) {
                structures.add(pair);
            }
        } else {
            structures = this.interpret(modlObject, (RawModlObject.TopLevelConditional)rawStructure);
        }
        return structures;
    }

    private ModlObject.Pair interpret(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair) {
        return this.interpret(modlObject, rawPair, parentPair, true);
    }

    private ModlObject.Pair interpret(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair, boolean addToValuePairs) {
        String originalKey;
        if (rawPair == null) {
            return null;
        }
        if (rawPair.getKey() != null && rawPair.getKey().string != null) {
            if (!rawPair.getKey().string.matches(IDENTIFIER_REGEX)) {
                throw new RuntimeException("Pair name " + rawPair.getKey().string + " is illegal");
            }
            if (rawPair.getKey().string.equals("?")) {
                this.numberedVariables = new HashMap<Integer, ModlValue>();
                VariableLoader.loadConfigNumberedVariables(rawPair.getModlValue(), this.numberedVariables);
                return null;
            }
        }
        ModlObject.Pair pair = new ModlObject.Pair(modlObject);
        if (rawPair.getKey() == null) {
            return null;
        }
        String newKey = originalKey = rawPair.getKey().string;
        if (this.haveModlClass(originalKey)) {
            newKey = this.transformKey(originalKey);
            rawPair = this.transformValue(modlObject, rawPair);
        }
        if (newKey != null && newKey.toUpperCase().equals(newKey) && this.pairNames.contains(newKey) && addToValuePairs) {
            throw new RuntimeException(newKey + " can't be defined again as upper-case keys are immutable");
        }
        if (!this.pairNames.contains("_" + newKey) && newKey != null) {
            if (parentPair == null && !newKey.startsWith("%") && addToValuePairs) {
                this.pairNames.add(newKey);
            }
            this.transformPairKey(modlObject, rawPair, newKey, parentPair);
        }
        if (newKey != null && (newKey.startsWith("_") || newKey.startsWith("*") || newKey.equals("?"))) {
            return null;
        }
        if (this.haveModlClass(originalKey) && this.generateModlClassObject(modlObject, rawPair, pair, originalKey, newKey, parentPair)) {
            return pair;
        }
        ModlObject modlObject2 = modlObject;
        modlObject2.getClass();
        pair.setKey(new ModlObject.String(modlObject2, newKey));
        if (pair.getModlValue() instanceof ModlObject.Array) {
            for (ModlValue value : ((ModlObject.Array)rawPair.getModlValue()).getValues()) {
                this.addValueFromPair(modlObject, rawPair, parentPair, pair, value);
            }
        } else {
            this.addValueFromPair(modlObject, rawPair, parentPair, pair, rawPair.getModlValue());
        }
        return pair;
    }

    private void addValueFromPair(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair, ModlObject.Pair pair, ModlValue value) {
        if (value != null && value instanceof ModlObject.Pair && ((ModlObject.Pair)value).getKey().string.startsWith("%")) {
            String key = ((ModlObject.Pair)value).getKey().string;
            ModlValue newValue = null;
            if (this.pairNames.contains(key.replaceFirst("%", "_"))) {
                ModlValue storedValue = this.valuePairs.get(key.replaceFirst("%", ""));
                if (storedValue instanceof ModlObject.Map) {
                    ModlObject.Map map = (ModlObject.Map)storedValue;
                    ModlObject modlObject2 = modlObject;
                    modlObject2.getClass();
                    ModlObject modlObject3 = modlObject;
                    modlObject3.getClass();
                    newValue = new ModlObject.Pair(modlObject2, new ModlObject.String(modlObject3, "obsolete"), map);
                } else if (storedValue instanceof ModlObject.Array) {
                    List<ModlValue> list = ((ModlObject.Array)storedValue).getValues();
                    Integer index = null;
                    index = ((ModlObject.Pair)value).getModlValue() instanceof ModlObject.Number ? new Integer(((ModlObject.Number)((ModlObject.Pair)value).getModlValue()).number) : new Integer(((ModlObject.Number)((ModlObject.Array)((ModlObject.Pair)value).getModlValue()).get((Integer)Integer.valueOf((int)0))).number);
                    newValue = list.get(index);
                }
            } else {
                newValue = this.transformString(((ModlObject.Pair)value).getKey().string);
            }
            pair.addModlValue(newValue);
        } else {
            pair.addModlValue(this.interpret(modlObject, value, parentPair));
        }
    }

    private boolean generateModlClassObject(ModlObject modlObject, ModlObject.Pair rawPair, ModlObject.Pair pair, String originalKey, String newKey, Object parentPair) {
        boolean hasParams;
        ModlObject modlObject2 = modlObject;
        modlObject2.getClass();
        pair.setKey(new ModlObject.String(modlObject2, newKey));
        int numParams = 0;
        if (rawPair.getModlValue() != null && (rawPair.getModlValue() instanceof ModlObject.Array || rawPair.getModlValue() == null || !(rawPair.getModlValue() instanceof ModlObject.Map))) {
            numParams = rawPair.getModlValue() instanceof ModlObject.Array ? ((ModlObject.Array)rawPair.getModlValue()).getValues().size() : 1;
        }
        numParams = this.getNumParams(rawPair, numParams);
        String paramsKeyString = "*params" + numParams;
        Object obj = this.getModlClass(rawPair.getKey().string).get(paramsKeyString);
        boolean bl = hasParams = obj != null;
        if (this.anyClassContainsPairs(originalKey) || this.mapPairAlready(rawPair) || hasParams) {
            ModlObject modlObject3 = modlObject;
            modlObject3.getClass();
            pair.setKey(new ModlObject.String(modlObject3, newKey));
            List<Object> pairs = null;
            boolean wasArray = false;
            if (rawPair.getModlValue() instanceof ModlObject.Array) {
                try {
                    pairs = this.getPairsFromArray(modlObject, (ModlObject.Array)rawPair.getModlValue(), parentPair);
                    if (pairs.size() > 0) {
                        wasArray = true;
                    } else {
                        pairs = null;
                    }
                }
                catch (Exception e) {
                    wasArray = false;
                }
            }
            if (this.mapPairAlready(rawPair)) {
                pairs = new LinkedList();
                this.addMapItemsToPair(modlObject, ((ModlObject.Map)rawPair.getModlValue()).getPairs(), pairs, parentPair);
            }
            if (pairs != null) {
                this.makeNewMapPair(modlObject, pair, pairs, wasArray, parentPair);
            }
            if (!(rawPair.getModlValue() instanceof ModlObject.Pair) && !(rawPair.getModlValue() instanceof ModlObject.Map)) {
                if (!hasParams) {
                    ModlValue value = this.interpret(modlObject, rawPair.getModlValue(), parentPair);
                    pair.addModlValue(value);
                } else {
                    int paramNum = 0;
                    List params = (List)obj;
                    String currentClass = null;
                    LinkedList<ModlValue> values = new LinkedList<ModlValue>();
                    ModlValue pairVal = rawPair.getModlValue();
                    if (pairVal instanceof ModlObject.Array) {
                        for (ModlValue vl : ((ModlObject.Array)pairVal).getValues()) {
                            if (vl instanceof RawModlObject.ArrayConditional) {
                                List<ModlValue> vs = this.interpret(modlObject, (RawModlObject.ArrayConditional)vl, parentPair);
                                for (ModlValue v : vs) {
                                    values.add(v);
                                }
                                continue;
                            }
                            values.add(vl);
                        }
                    } else {
                        values.add(pairVal);
                    }
                    for (ModlValue valueItem : values) {
                        if (params.get(paramNum) instanceof ModlObject.String) {
                            currentClass = ((ModlObject.String)params.get((int)paramNum)).string;
                        }
                        if (valueItem instanceof ModlObject.Array) {
                            RawModlObject rawModlObject = new RawModlObject();
                            Map<String, Object> modlClassObj = this.getModlClass(currentClass);
                            int innerParamNum = 0;
                            ModlObject.Pair innerPair = new ModlObject.Pair(modlObject);
                            ModlObject.Pair valuePair = new ModlObject.Pair(modlObject);
                            String fullClassName = currentClass;
                            try {
                                String nameString = ((ModlObject.String)((ModlValue)this.getModlClass((String)currentClass).get((Object)"*name"))).string;
                                if (nameString == null) {
                                    nameString = ((ModlObject.String)((ModlValue)this.getModlClass((String)currentClass).get((Object)"*n"))).string;
                                }
                                fullClassName = nameString;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ModlObject modlObject4 = modlObject;
                            modlObject4.getClass();
                            valuePair.setKey(new ModlObject.String(modlObject4, fullClassName));
                            for (ModlValue vi : ((ModlObject.Array)valueItem).getValues()) {
                                Map<String, Object> modlClassMap;
                                String superclass;
                                int valueItemSize = 1;
                                if (valueItem instanceof ModlObject.Array) {
                                    valueItemSize = ((ModlObject.Array)valueItem).getValues().size();
                                }
                                if ((superclass = (String)(modlClassMap = this.getModlClass(currentClass)).get("*superclass")).equals("arr")) {
                                    ModlValue v = this.interpret(modlObject, vi, parentPair);
                                    valuePair.addModlValue(v);
                                    continue;
                                }
                                if (superclass.equals("map")) {
                                    ModlObject.String innerClassName = (ModlObject.String)((LinkedList)((Map.Entry)((LinkedHashMap)modlClassObj).entrySet().toArray()[valueItemSize]).getValue()).get(innerParamNum++);
                                    ModlObject.Pair newRawPair = new ModlObject.Pair(rawModlObject);
                                    newRawPair.setKey(innerClassName);
                                    newRawPair.addModlValue(vi);
                                    ModlObject.Pair v = this.interpret(modlObject, newRawPair, parentPair);
                                    valuePair.addModlValue(v);
                                    innerPair.addModlValue(valuePair);
                                    continue;
                                }
                                throw new RuntimeException("Superclass " + superclass + " of " + fullClassName + " is not known!");
                            }
                            pair.addModlValue(valuePair);
                        } else {
                            this.addNewClassParamValue(modlObject, pair, parentPair, currentClass, valueItem);
                        }
                        ++paramNum;
                    }
                }
                this.addAllParentPairs(modlObject, pair, originalKey);
                return true;
            }
            this.addAllParentPairs(modlObject, pair, originalKey);
            return true;
        }
        return false;
    }

    private void addNewClassParamValue(ModlObject modlObject, ModlObject.Pair pair, Object parentPair, String currentClass, ModlValue valueItem) {
        ModlValue newValue = this.interpret(modlObject, valueItem, parentPair);
        ModlObject.Pair valuePair = new ModlObject.Pair(modlObject);
        String fullClassName = currentClass;
        try {
            fullClassName = ((ModlObject.String)((ModlValue)this.getModlClass((String)currentClass).get((Object)"*name"))).string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModlObject modlObject2 = modlObject;
        modlObject2.getClass();
        valuePair.setKey(new ModlObject.String(modlObject2, fullClassName));
        valuePair.addModlValue(newValue);
        pair.addModlValue(valuePair);
    }

    private int getNumParams(ModlObject.Pair originalPair, int numParams) {
        if (originalPair.getModlValue() instanceof ModlObject.Map) {
            numParams = ((ModlObject.Map)originalPair.getModlValue()).getPairs().size();
        } else if (originalPair.getModlValue() instanceof ModlObject.Array) {
            numParams = ((ModlObject.Array)originalPair.getModlValue()).getValues().size();
        } else if (originalPair.getModlValue() != null) {
            numParams = 1;
        }
        return numParams;
    }

    private void transformPairKey(ModlObject rawModlObject, ModlObject.Pair originalPair, String newKey, Object parentPair) {
        String transformedKey = newKey;
        if (transformedKey.startsWith("_")) {
            transformedKey = transformedKey.replaceFirst("_", "");
        }
        if (parentPair == null) {
            if (newKey.startsWith("_")) {
                if (originalPair.getModlValue() instanceof ModlObject.Map) {
                    ModlObject modlObject = rawModlObject;
                    modlObject.getClass();
                    originalPair.setKey(new ModlObject.String(modlObject, transformedKey));
                    HashMap newMap = new HashMap();
                    this.interpret(rawModlObject, (ModlObject.Map)originalPair.getModlValue(), newMap);
                }
                if (originalPair.getModlValue() instanceof ModlObject.Array) {
                    ModlObject modlObject = rawModlObject;
                    modlObject.getClass();
                    originalPair.setKey(new ModlObject.String(modlObject, transformedKey));
                    LinkedList newList = new LinkedList();
                    this.interpret(rawModlObject, (ModlObject.Array)originalPair.getModlValue(), newList);
                }
            }
            if (originalPair.getModlValue() instanceof ModlObject.String) {
                this.valuePairs.put(transformedKey, this.transformString(((ModlObject.String)originalPair.getModlValue()).string));
            } else {
                this.valuePairs.put(transformedKey, originalPair.getModlValue());
            }
        } else if (parentPair instanceof Map) {
            String str = this.getStringFromValue(originalPair);
            ((Map)parentPair).put(transformedKey, str);
        } else if (parentPair instanceof List) {
            String str = this.getStringFromValue(originalPair);
            ((List)parentPair).add(str);
        } else {
            throw new RuntimeException("Expecting Map or Array as parentPair!");
        }
    }

    private String getStringFromValue(ModlObject.Pair originalPair) {
        String str = null;
        ModlValue v = originalPair.getModlValue();
        if (v instanceof ModlObject.Array) {
            v = ((ModlObject.Array)v).get(0);
        }
        if (v != null && v instanceof ModlObject.String) {
            str = ((ModlObject.String)v).string;
        }
        if (v != null && v instanceof ModlObject.Number) {
            str = ((ModlObject.Number)v).number;
        }
        return str;
    }

    public void makeNewMapPair(ModlObject modlObject, ModlObject.Pair pair, List<ModlObject.Pair> rawPairs, boolean wasArray, Object parentPair) {
        for (ModlObject.Pair originalMapPair : rawPairs) {
            ModlObject.Pair newMapPair = originalMapPair;
            if (newMapPair == null) continue;
            if (wasArray) {
                ModlObject.Pair value = null;
                if (newMapPair.getKey().string.startsWith("_")) continue;
                value = newMapPair;
                pair.addModlValue(value);
                continue;
            }
            if (newMapPair.getKey().string.startsWith("_")) continue;
            boolean knownItem = false;
            ModlObject.Map map = null;
            if (pair.getModlValue() != null) {
                map = (ModlObject.Map)pair.getModlValue();
            }
            if (map == null) {
                map = new ModlObject.Map(modlObject);
                pair.addModlValue(map);
            }
            if (map.get(newMapPair.getKey()) != null) {
                knownItem = true;
            }
            if (knownItem) continue;
            map.addPair(newMapPair);
        }
    }

    private ModlValue makeValueString(ModlObject modlObject, ModlValue value) {
        if (value == null) {
            return null;
        }
        String newString = null;
        if (value instanceof ModlObject.String) {
            newString = ((ModlObject.String)value).string;
        }
        if (value instanceof ModlObject.Number) {
            newString = ((ModlObject.Number)value).number;
        }
        if (value instanceof ModlObject.True) {
            newString = "true";
        }
        if (value instanceof ModlObject.False) {
            newString = "false";
        }
        if (value instanceof ModlObject.Null) {
            newString = "null";
        }
        ModlObject modlObject2 = modlObject;
        modlObject2.getClass();
        ModlObject.String v = new ModlObject.String(modlObject2, newString);
        return v;
    }

    private void addMapItemsToPair(ModlObject modlObject, List<ModlObject.Pair> mapItems, List<ModlObject.Pair> pairs, Object parentPair) {
        if (mapItems == null) {
            return;
        }
        for (ModlObject.Pair mapItem : mapItems) {
            if (mapItem instanceof RawModlObject.MapConditional) {
                List<ModlObject.Pair> newPairs = this.interpret(modlObject, (RawModlObject.MapConditional)mapItem, parentPair);
                for (ModlObject.Pair p : newPairs) {
                    pairs.add(p);
                }
                continue;
            }
            if (mapItem == null) continue;
            pairs.add(this.interpret(modlObject, mapItem, parentPair, false));
        }
    }

    private ModlValue interpret(ModlObject modlObject, ModlValue rawValueItem, Object parentPair) {
        if (rawValueItem == null) {
            return null;
        }
        if (rawValueItem instanceof RawModlObject.ValueConditional) {
            return this.interpret(modlObject, (RawModlObject.ValueConditional)rawValueItem, parentPair);
        }
        if (!(rawValueItem instanceof ModlObject.Array)) {
            return this.interpretValue(modlObject, rawValueItem, parentPair);
        }
        ModlObject.Array array = new ModlObject.Array(modlObject);
        for (ModlValue vi : ((ModlObject.Array)rawValueItem).getValues()) {
            if (vi instanceof RawModlObject.ArrayConditional) {
                List<ModlValue> newValues = this.interpret(modlObject, (RawModlObject.ArrayConditional)vi, parentPair);
                for (ModlValue viNew : newValues) {
                    array.addValue(this.interpret(modlObject, viNew, parentPair));
                }
                continue;
            }
            array.addValue(this.interpret(modlObject, vi, parentPair));
        }
        return array;
    }

    private Map<String, Object> getModlClass(String key) {
        for (Map.Entry<String, Map<String, Object>> entry : this.klasses.entrySet()) {
            for (Map.Entry<String, Object> valueEntry : entry.getValue().entrySet()) {
                if (!valueEntry.getKey().equals("*name") && !valueEntry.getKey().equals("*n") && !valueEntry.getKey().equals("*id") && !valueEntry.getKey().equals("*i") || !(valueEntry.getValue() instanceof String ? valueEntry.getValue().equals(key) : ((ModlObject.String)valueEntry.getValue()).string.equals(key))) continue;
                return entry.getValue();
            }
        }
        Map<String, Object> ret = this.klasses.get(key);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private boolean haveModlClass(String originalKey) {
        return this.getModlClass(originalKey) != null;
    }

    private List<ModlObject.Pair> getPairsFromArray(ModlObject modlObject, ModlObject.Array array, Object parentPair) {
        return this.getPairsFromArray(modlObject, array.getValues(), parentPair);
    }

    private List<ModlObject.Pair> getPairsFromArray(ModlObject modlObject, List<ModlValue> arrayItems, Object parentPair) {
        LinkedList<ModlObject.Pair> pairs = new LinkedList<ModlObject.Pair>();
        if (arrayItems != null) {
            for (ModlValue arrayItem : arrayItems) {
                if (arrayItem instanceof RawModlObject.ArrayConditional) {
                    List<ModlValue> newArrayItems = this.interpret(modlObject, (RawModlObject.ArrayConditional)arrayItem, parentPair);
                    for (ModlValue v : newArrayItems) {
                        if (!(v instanceof ModlObject.Pair)) continue;
                        pairs.add((ModlObject.Pair)v);
                    }
                    continue;
                }
                if (arrayItem == null || !(arrayItem instanceof ModlObject.Pair)) continue;
                pairs.add(this.interpret(modlObject, (ModlObject.Pair)arrayItem, parentPair));
            }
        }
        return pairs;
    }

    private void addAllParentPairs(ModlObject modlObject, ModlObject.Pair pair, String originalKey) {
        Map<String, Object> klass = this.getModlClass(originalKey);
        for (Map.Entry<String, Object> entry : klass.entrySet()) {
            if (entry.getKey().startsWith("_") || entry.getKey().startsWith("*") && !entry.getKey().equals("?") || this.pairHasKey(modlObject, pair, entry.getKey())) continue;
            ModlObject.Pair newPair = new ModlObject.Pair(modlObject);
            ModlObject modlObject2 = modlObject;
            modlObject2.getClass();
            newPair.setKey(new ModlObject.String(modlObject2, entry.getKey()));
            newPair.addModlValue(this.interpret(modlObject, (ModlValue)entry.getValue(), null));
            if (pair.getModlValue() != null && pair.getModlValue() instanceof ModlObject.Map) {
                ((ModlObject.Map)pair.getModlValue()).addPair(newPair);
                continue;
            }
            pair.addModlValue(newPair);
        }
    }

    private boolean pairHasKey(ModlObject modlObject, ModlObject.Pair pair, String key) {
        if (pair.getModlValue() == null) {
            return false;
        }
        if (pair.getModlValue() instanceof ModlObject.Pair) {
            if (((ModlObject.Pair)pair.getModlValue()).getKey().equals(key)) {
                return true;
            }
        } else if (pair.getModlValue() instanceof ModlObject.Map) {
            ModlObject.Map map = (ModlObject.Map)pair.getModlValue();
            ModlObject modlObject2 = modlObject;
            modlObject2.getClass();
            if (map.get(new ModlObject.String(modlObject2, key)) != null) {
                return true;
            }
        }
        return false;
    }

    private boolean mapPairAlready(ModlObject.Pair originalPair) {
        return originalPair.getModlValue() instanceof ModlObject.Map;
    }

    private boolean anyClassContainsPairs(String originalKey) {
        Map<String, Object> klass = this.getModlClass(originalKey);
        for (String key : klass.keySet()) {
            if (key.startsWith("_") || key.startsWith("*") || key.equals("?")) continue;
            return true;
        }
        return false;
    }

    private String transformKey(String originalKey) {
        if (this.getModlClass(originalKey) != null) {
            if (this.getModlClass(originalKey).get("*name") != null && this.getModlClass(originalKey).get("*name") instanceof ModlObject.String) {
                return ((ModlObject.String)this.getModlClass((String)originalKey).get((Object)"*name")).string;
            }
            if (this.getModlClass(originalKey).get("*n") != null && this.getModlClass(originalKey).get("*n") instanceof ModlObject.String) {
                return ((ModlObject.String)this.getModlClass((String)originalKey).get((Object)"*n")).string;
            }
        }
        return originalKey;
    }

    private ModlObject.Pair transformValue(ModlObject modlObject, ModlObject.Pair originalPair) {
        RawModlObject rawModlObject = new RawModlObject();
        if (this.getModlClass(originalPair.getKey().string) != null) {
            if (this.getModlClass(originalPair.getKey().string).get("*name") != null && (this.getModlClass(originalPair.getKey().string).get("*name").equals("_v") || this.getModlClass(originalPair.getKey().string).get("*name").equals("var")) || this.getModlClass(originalPair.getKey().string).get("*n") != null && (this.getModlClass(originalPair.getKey().string).get("*n").equals("_v") || this.getModlClass(originalPair.getKey().string).get("*n").equals("var"))) {
                VariableLoader.loadConfigNumberedVariables(originalPair.getModlValue(), this.numberedVariables);
            } else if (this.getModlClass(originalPair.getKey().string).get("*superclass") != null && this.getModlClass(originalPair.getKey().string).get("*superclass").equals("str")) {
                ModlObject.Pair pair = new ModlObject.Pair(rawModlObject);
                pair.setKey(originalPair.getKey());
                if (originalPair.getModlValue() == null) {
                    return originalPair;
                }
                if (originalPair.getModlValue() instanceof ModlObject.String) {
                    return originalPair;
                }
                ModlValue value = this.makeValueString(modlObject, originalPair.getModlValue());
                RawModlObject rawModlObject2 = rawModlObject;
                rawModlObject2.getClass();
                ModlObject.String v = new ModlObject.String(rawModlObject2, ((ModlObject.String)value).string);
                pair.addModlValue(v);
                return pair;
            }
        }
        return originalPair;
    }

    private ModlValue interpretValue(ModlObject modlObject, ModlValue rawValue, Object parentPair) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof ModlObject.Pair) {
            return this.interpret(modlObject, (ModlObject.Pair)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Map) {
            return this.interpret(modlObject, (ModlObject.Map)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Array) {
            return this.interpret(modlObject, (ModlObject.Array)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Number) {
            return this.interpret(modlObject, (ModlObject.Number)rawValue);
        }
        if (rawValue instanceof ModlObject.True) {
            return this.interpret(modlObject, (ModlObject.True)rawValue);
        }
        if (rawValue instanceof ModlObject.False) {
            return this.interpret(modlObject, (ModlObject.False)rawValue);
        }
        if (rawValue instanceof ModlObject.Null) {
            return this.interpret(modlObject, (ModlObject.Null)rawValue);
        }
        if (rawValue instanceof ModlObject.String) {
            return this.interpret((ModlObject.String)rawValue);
        }
        return null;
    }

    private ModlObject.Map interpret(ModlObject modlObject, ModlObject.Map originalMap, Object parentPair) {
        if (originalMap == null) {
            return null;
        }
        ModlObject.Map map = new ModlObject.Map(modlObject);
        if (originalMap.getPairs() != null) {
            for (ModlObject.Pair originalMapItem : originalMap.getPairs()) {
                List<ModlObject.Pair> pairs = this.interpretMapPair(modlObject, originalMapItem, parentPair);
                if (pairs == null) continue;
                for (ModlObject.Pair pair : pairs) {
                    if (pair == null || pair.getKey().string.startsWith("_") || pair.getKey().string.startsWith("*") || pair.getKey().string.equals("?")) continue;
                    map.addPair(pair);
                }
            }
        }
        return map;
    }

    private List<ModlObject.Pair> interpretMapPair(ModlObject modlObject, ModlObject.Pair originalMapItem, Object parentPair) {
        ModlObject.Pair pair;
        if (originalMapItem == null) {
            return null;
        }
        LinkedList<ModlObject.Pair> pairs = new LinkedList();
        if (originalMapItem instanceof RawModlObject.MapConditional) {
            pairs = this.interpret(modlObject, (RawModlObject.MapConditional)originalMapItem, parentPair);
        }
        if ((pair = this.interpret(modlObject, originalMapItem, parentPair)) != null && !pair.getKey().string.startsWith("_")) {
            pairs.add(pair);
        }
        return pairs;
    }

    private ModlObject.Array interpret(ModlObject modlObject, ModlObject.Array rawArray, Object parentPair) {
        if (rawArray == null) {
            return null;
        }
        ModlObject.Array array = new ModlObject.Array(modlObject);
        if (rawArray.getValues() != null) {
            for (ModlValue originalArrayItem : rawArray.getValues()) {
                ModlValue value = this.interpret(modlObject, originalArrayItem, parentPair);
                if (value == null) continue;
                array.addValue(value);
                if (parentPair == null) continue;
                ((List)parentPair).add(value);
            }
        }
        return array;
    }

    private List<ModlValue> interpretArrayItem(ModlObject modlObject, ModlValue rawArrayItem, Object parentPair) {
        if (rawArrayItem == null) {
            return null;
        }
        List<Object> values = new LinkedList();
        if (rawArrayItem instanceof RawModlObject.ArrayConditional) {
            values = this.interpret(modlObject, (RawModlObject.ArrayConditional)rawArrayItem, parentPair);
        } else {
            ModlValue value = this.interpret(modlObject, rawArrayItem, parentPair);
            values.add(value);
        }
        return values;
    }

    private ModlValue interpret(ModlObject modlObject, RawModlObject.ValueConditional originalConditional, Object parentPair) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.ValueConditionalReturn> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (this.evaluates(conditionalTest)) {
                if (originalConditionalEntry.getValue() == null) {
                    return new ModlObject.True(modlObject);
                }
                if (originalConditionalEntry.getValue().getValues().size() == 1) {
                    return this.interpret(modlObject, originalConditionalEntry.getValue().getValues().get(0), parentPair);
                }
                ModlObject.Array returnValue = new ModlObject.Array(modlObject);
                for (ModlValue valueItem : originalConditionalEntry.getValue().getValues()) {
                    ModlValue v = this.interpret(modlObject, valueItem, parentPair);
                    returnValue.addValue(v);
                }
                return returnValue;
            }
            if (originalConditionalEntry.getValue() != null) continue;
            return new ModlObject.False(modlObject);
        }
        return null;
    }

    private List<ModlValue> interpret(ModlObject modlObject, RawModlObject.ArrayConditional rawConditional, Object parentPair) {
        if (rawConditional == null) {
            return null;
        }
        if (rawConditional.getConditionals() != null) {
            for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.ArrayConditionalReturn> originalConditionalEntry : rawConditional.getConditionals().entrySet()) {
                RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
                if (!this.evaluates(conditionalTest)) continue;
                LinkedList<ModlValue> returnValues = new LinkedList<ModlValue>();
                for (ModlValue arrayItem : originalConditionalEntry.getValue().getValues()) {
                    List<ModlValue> values = this.interpretArrayItem(modlObject, arrayItem, parentPair);
                    for (ModlValue v : values) {
                        returnValues.add(v);
                    }
                }
                return returnValues;
            }
        }
        return null;
    }

    private List<ModlObject.Pair> interpret(ModlObject modlObject, RawModlObject.MapConditional originalConditional, Object parentPair) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, ModlObject.Map> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (!this.evaluates(conditionalTest)) continue;
            LinkedList<ModlObject.Pair> returnPairs = new LinkedList<ModlObject.Pair>();
            for (ModlObject.Pair mapItem : originalConditionalEntry.getValue().getPairs()) {
                List<ModlObject.Pair> mapItems = this.interpretMapPair(modlObject, mapItem, parentPair);
                for (ModlObject.Pair p : mapItems) {
                    returnPairs.add(p);
                }
            }
            return returnPairs;
        }
        return null;
    }

    private List<ModlObject.Structure> interpret(ModlObject modlObject, RawModlObject.TopLevelConditional originalConditional) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.TopLevelConditionalReturn> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (!this.evaluates(conditionalTest)) continue;
            LinkedList<ModlObject.Structure> returnStructures = new LinkedList<ModlObject.Structure>();
            for (ModlObject.Structure rawStructure : originalConditionalEntry.getValue().getStructures()) {
                List<ModlObject.Structure> structures = this.interpret(modlObject, rawStructure);
                if (structures == null) continue;
                for (ModlObject.Structure structure : structures) {
                    returnStructures.add(structure);
                }
            }
            return returnStructures;
        }
        return null;
    }

    private boolean evaluates(RawModlObject.ConditionTest conditionalTest) {
        int nullCount = 0;
        LinkedList<Map.Entry<RawModlObject.SubCondition, ImmutablePair<String, Boolean>>> conditionalTestOrderedList = new LinkedList<Map.Entry<RawModlObject.SubCondition, ImmutablePair<String, Boolean>>>();
        for (Map.Entry<RawModlObject.SubCondition, ImmutablePair<String, Boolean>> conditionalTestEntry : conditionalTest.getSubConditionMap().entrySet()) {
            String string = (String)conditionalTestEntry.getValue().getLeft();
            if (string == null) {
                conditionalTestOrderedList.add(nullCount++, conditionalTestEntry);
                continue;
            }
            if (string.equals("|")) {
                conditionalTestOrderedList.add(conditionalTestEntry);
                continue;
            }
            if (!string.equals("&")) continue;
            conditionalTestOrderedList.add(nullCount, conditionalTestEntry);
        }
        boolean result = true;
        for (Map.Entry entry : conditionalTestOrderedList) {
            RawModlObject.SubCondition subCondition = (RawModlObject.SubCondition)entry.getKey();
            ImmutablePair conditionTestOperatorPair = (ImmutablePair)entry.getValue();
            String conditionTestOperator = (String)conditionTestOperatorPair.getLeft();
            Boolean shouldNegate = (Boolean)conditionTestOperatorPair.getRight();
            boolean subConditionReturn = true;
            if (subCondition instanceof RawModlObject.ConditionGroup) {
                subConditionReturn = this.evaluates((RawModlObject.ConditionGroup)subCondition);
            } else if (subCondition instanceof RawModlObject.Condition) {
                subConditionReturn = this.evaluates((RawModlObject.Condition)subCondition);
            }
            if (shouldNegate.booleanValue()) {
                boolean bl = subConditionReturn = !subConditionReturn;
            }
            if (conditionTestOperator == null) {
                result = subConditionReturn;
                continue;
            }
            if (conditionTestOperator.equals("&")) {
                result = result && subConditionReturn;
                continue;
            }
            if (!conditionTestOperator.equals("|")) continue;
            result = result || subConditionReturn;
        }
        return result;
    }

    private boolean evaluates(RawModlObject.ConditionGroup conditionGroup) {
        List<ImmutablePair<RawModlObject.ConditionTest, String>> orderedConditionalTestList = Interpreter.getOrderedConditionalTestList(conditionGroup);
        boolean result = true;
        for (ImmutablePair<RawModlObject.ConditionTest, String> conditionTestPair : orderedConditionalTestList) {
            RawModlObject.ConditionTest ct = (RawModlObject.ConditionTest)conditionTestPair.getLeft();
            String conditionGroupOperator = (String)conditionTestPair.getRight();
            boolean ctReturn = this.evaluates(ct);
            if (conditionGroupOperator == null) {
                result = ctReturn;
                continue;
            }
            if (conditionGroupOperator.equals("&")) {
                result = result && ctReturn;
                continue;
            }
            if (!conditionGroupOperator.equals("|")) continue;
            result = result || ctReturn;
        }
        return result;
    }

    private static List<ImmutablePair<RawModlObject.ConditionTest, String>> getOrderedConditionalTestList(RawModlObject.ConditionGroup conditionGroup) {
        LinkedList<ImmutablePair<RawModlObject.ConditionTest, String>> orderedConditionalTestList = new LinkedList<ImmutablePair<RawModlObject.ConditionTest, String>>();
        int nullCount = 0;
        for (ImmutablePair<RawModlObject.ConditionTest, String> conditionalTestEntry : conditionGroup.getConditionsTestList()) {
            String operator = (String)conditionalTestEntry.getValue();
            if (operator == null) {
                orderedConditionalTestList.add(nullCount++, conditionalTestEntry);
                continue;
            }
            if (operator.equals("|")) {
                orderedConditionalTestList.add(conditionalTestEntry);
                continue;
            }
            if (!operator.equals("&")) continue;
            orderedConditionalTestList.add(nullCount, conditionalTestEntry);
        }
        return orderedConditionalTestList;
    }

    private boolean evaluates(RawModlObject.Condition condition) {
        String keyString = condition.getKey();
        List<ModlValue> values = condition.getValues();
        if (keyString == null) {
            if (values.get(0) instanceof ModlObject.True) {
                return true;
            }
            if (values.get(0) instanceof ModlObject.False) {
                return false;
            }
            ModlValue transformedName = this.transformString(((ModlObject.String)values.get((int)0)).string);
            if (transformedName instanceof ModlObject.True) {
                return true;
            }
            if (transformedName instanceof ModlObject.False) {
                return false;
            }
            if (values.get(0) instanceof ModlObject.String) {
                if (this.valuePairs.get(((ModlObject.String)values.get((int)0)).string) == null) {
                    return false;
                }
                ModlValue valueEntry = this.valuePairs.get(((ModlObject.String)values.get((int)0)).string);
                if (valueEntry instanceof ModlObject.True) {
                    return true;
                }
                return !(valueEntry instanceof ModlObject.False);
            }
        }
        while (keyString.startsWith("_") || keyString.startsWith("%")) {
            keyString = keyString.substring(1, keyString.length());
        }
        String key = this.transformConditionalArgument(keyString);
        String conditionOperator = condition.getOperator();
        if (values.size() > 1) {
            for (ModlValue value : values) {
                String val = this.getObjectFromValueForCondition(value);
                if (!conditionOperator.equals("=") || !this.conditionalEquals(key, val)) continue;
                return true;
            }
            return false;
        }
        String valObj = this.getObjectFromValueForCondition(values.get(0));
        String val = this.transformConditionalArgument(valObj.toString());
        if (val.startsWith("%")) {
            val = val.substring(1, val.length());
        }
        if (conditionOperator.equals("=")) {
            if (this.conditionalEquals(key.toString(), val)) {
                return true;
            }
            if (this.conditionalEquals(key.toString(), valObj)) {
                return true;
            }
            if (this.conditionalEquals(key.toString(), this.transformString(val))) {
                return true;
            }
            return this.conditionalEquals(key.toString(), this.transformString(valObj));
        }
        if (conditionOperator.equals("!=")) {
            return !this.conditionalEquals(key.toString(), val);
        }
        Float valFloat = new Float(val.toString());
        Float keyFloat = new Float(key.toString());
        if (conditionOperator.equals(">")) {
            return keyFloat.compareTo(valFloat) > 0;
        }
        if (conditionOperator.equals("<")) {
            return keyFloat.compareTo(valFloat) < 0;
        }
        if (conditionOperator.equals("<=")) {
            return keyFloat.compareTo(valFloat) <= 0;
        }
        if (conditionOperator.equals(">=")) {
            return keyFloat.compareTo(valFloat) >= 0;
        }
        return false;
    }

    private boolean conditionalEquals(String key, Object val) {
        if (val.toString().contains("*")) {
            return this.conditionalWildcardEquals(key, val.toString());
        }
        return key.equals(val.toString());
    }

    private boolean conditionalWildcardEquals(String key, Object val) {
        String regex = "";
        regex = !val.toString().startsWith("*") ? "^" : ".*";
        String[] splits = val.toString().split("\\*");
        int i = 0;
        for (String split : splits) {
            if (split.equals("")) continue;
            if (i++ > 0) {
                regex = regex + ".*";
            }
            regex = regex + split;
        }
        regex = !val.toString().endsWith("*") ? regex + "$" : regex + ".*";
        return key.matches(regex);
    }

    private String getObjectFromValueForCondition(ModlValue value) {
        if (value instanceof ModlObject.String) {
            return ((ModlObject.String)value).string;
        }
        if (value instanceof ModlObject.Number) {
            return ((ModlObject.Number)value).number;
        }
        return null;
    }

    private String transformConditionalArgument(String origKeyString) {
        StringTransformer stringTransformer = new StringTransformer(this.valuePairs, this.variables, this.numberedVariables);
        ModlValue objectRef = stringTransformer.runObjectReferencing("%" + origKeyString, "%" + origKeyString, false);
        if (objectRef instanceof ModlObject.String) {
            String keyString = ((ModlObject.String)objectRef).string;
            if (keyString.equals("%" + origKeyString) && origKeyString.startsWith("%")) {
                objectRef = stringTransformer.runObjectReferencing(origKeyString, origKeyString, false);
                if (objectRef instanceof ModlObject.String) {
                    keyString = ((ModlObject.String)objectRef).string;
                    if (keyString.equals("%" + origKeyString)) {
                        return origKeyString;
                    }
                    return keyString;
                }
                if (objectRef instanceof ModlObject.Number) {
                    keyString = ((ModlObject.Number)objectRef).number;
                    return keyString;
                }
            }
            return keyString;
        }
        if (objectRef instanceof ModlObject.Number) {
            return ((ModlObject.Number)objectRef).number;
        }
        return origKeyString;
    }

    private ModlObject.False interpret(ModlObject modlObject, ModlObject.False falseVal) {
        if (falseVal != null) {
            ModlObject.False f = new ModlObject.False(modlObject);
            return f;
        }
        return null;
    }

    private ModlObject.Null interpret(ModlObject modlObject, ModlObject.Null val) {
        if (val != null) {
            ModlObject.Null n = new ModlObject.Null(modlObject);
            return n;
        }
        return null;
    }

    private ModlObject.True interpret(ModlObject modlObject, ModlObject.True trueVal) {
        if (trueVal != null) {
            ModlObject.True t = new ModlObject.True(modlObject);
            return t;
        }
        return null;
    }

    private ModlObject.Number interpret(ModlObject modlObject, ModlObject.Number originalNumber) {
        if (originalNumber != null) {
            ModlObject modlObject2 = modlObject;
            modlObject2.getClass();
            ModlObject.Number number = new ModlObject.Number(modlObject2, originalNumber.number);
            return number;
        }
        return null;
    }

    private ModlValue interpret(ModlObject.String string) {
        if (string != null) {
            ModlValue value = this.transformString(string.string);
            return value;
        }
        return null;
    }

    private ModlValue transformString(String s) {
        StringTransformer stringTransformer = new StringTransformer(this.valuePairs, this.variables, this.numberedVariables);
        return stringTransformer.transformString(s);
    }
}

