/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import uk.modl.interpreter.Interpreter;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

class ModlClassLoader {
    private static final Set<String> NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("map", "str", "num", "arr")));

    ModlClassLoader() {
    }

    static void loadClass(ModlObject.Structure structure, Map<String, Map<String, Object>> klasses, Interpreter interpreter) {
        if (structure instanceof ModlObject.Pair) {
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            if (!pair.getKey().string.toLowerCase().equals("*class") && !pair.getKey().string.toLowerCase().equals("*c")) {
                throw new RuntimeException("Expecting '*class' in ModlClassLoader");
            }
            ModlClassLoader.loadClassStructure(structure, klasses, interpreter);
        }
    }

    private static void loadClassStructure(ModlObject.Structure structure, Map<String, Map<String, Object>> klasses, Interpreter interpreter) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        String id = ModlClassLoader.getPairValueFor(structure, "*id", interpreter);
        String name = ModlClassLoader.getPairValueFor(structure, "*name", interpreter);
        if (name == null) {
            name = ModlClassLoader.getPairValueFor(structure, "*n", interpreter);
        }
        if (id == null) {
            id = ModlClassLoader.getPairValueFor(structure, "*i", interpreter);
        }
        if (name == null) {
            name = id;
        }
        ModlClassLoader.checkClassIdForBuiltInNames(id);
        ModlClassLoader.checkClassNameForBuiltInNames(name);
        values.put("*name", name);
        if (id == null) {
            throw new RuntimeException("Can't find *id in *class");
        }
        if (klasses.containsKey(id)) {
            throw new RuntimeException("Interpreter Error: Class name or id already defined - cannot redefine: " + id + ", " + name);
        }
        values.put("*id", id);
        String superclass = ModlClassLoader.getPairValueFor(structure, "*superclass", interpreter);
        if (superclass == null) {
            superclass = ModlClassLoader.getPairValueFor(structure, "*s", interpreter);
        }
        values.put("*superclass", superclass);
        if (NAMES.contains(name)) {
            throw new RuntimeException("Interpreter Error: Reserved class id - cannot redefine: " + name);
        }
        if (NAMES.contains(id)) {
            throw new RuntimeException("Interpreter Error: Reserved class id - cannot redefine: " + id);
        }
        if (klasses.containsKey(name)) {
            throw new RuntimeException("Interpreter Error: Class name or id already defined - cannot redefine: " + id + ", " + name);
        }
        for (Map<String, Object> kl : klasses.values()) {
            String existingName = kl.get("*name").toString();
            if (!existingName.equals(name) && !existingName.equals(id)) continue;
            throw new RuntimeException("Interpreter Error: Class name or id already defined - cannot redefine: " + id + ", " + name);
        }
        klasses.put(id, values);
        for (ModlObject.Pair mapItem : ((ModlObject.Map)((ModlObject.Pair)structure).getModlValue()).getPairs()) {
            if (mapItem.getKey().string.toLowerCase().equals("*id") || mapItem.getKey().string.toLowerCase().equals("*i") || mapItem.getKey().string.toLowerCase().equals("*superclass") || mapItem.getKey().string.toLowerCase().equals("*s")) continue;
            if (mapItem.getKey().string.toLowerCase().equals("*assign") || mapItem.getKey().string.toLowerCase().equals("*a")) {
                interpreter.addToUpperCaseInstructions(mapItem.getKey().string, "ERROR MESSAGE: %s");
                if (!(mapItem.getModlValue() instanceof ModlObject.Array)) continue;
                ModlClassLoader.loadParams(values, (ModlObject.Array)mapItem.getModlValue());
                continue;
            }
            if (mapItem.getKey().string.toLowerCase().equals("*n") || mapItem.getKey().string.toLowerCase().equals("*name")) {
                values.put("*name", mapItem.getModlValue());
                continue;
            }
            values.put(mapItem.getKey().string, mapItem.getModlValue());
        }
    }

    private static void checkClassNameForBuiltInNames(String s) {
        if (s != null && (s.equals("arr") || s.equals("map") || s.equals("num") || s.equals("str"))) {
            throw new RuntimeException("Interpreter Error: Reserved class name - cannot redefine: " + s);
        }
    }

    private static void checkClassIdForBuiltInNames(String s) {
        if (s != null && (s.equals("arr") || s.equals("map") || s.equals("num") || s.equals("str"))) {
            throw new RuntimeException("Interpreter Error: Reserved class id - cannot redefine: " + s);
        }
    }

    private static void loadParams(HashMap<String, Object> values, ModlObject.Array array) {
        int previousParamSize = -1;
        for (ModlValue v : array.getValues()) {
            ModlObject.Array a = (ModlObject.Array)v;
            int numberOfParams = a.getValues().size();
            if (numberOfParams <= previousParamSize) {
                throw new RuntimeException("Interpreter Error: Error: Key lists in *assign are not in ascending order of list length: " + a.toString());
            }
            previousParamSize = numberOfParams;
            String key = "*params" + numberOfParams;
            LinkedList<ModlValue> vs = new LinkedList<ModlValue>(a.getValues());
            values.put(key, vs);
        }
    }

    static String getPairValueFor(ModlObject.Structure structure, String pairValue, Interpreter interpreter) {
        for (ModlObject.Pair mapItem : ((ModlObject.Map)((ModlObject.Pair)structure).getModlValue()).getPairs()) {
            if (!mapItem.getKey().string.toLowerCase().equals(pairValue.toLowerCase())) continue;
            interpreter.addToUpperCaseInstructions(mapItem.getKey().string, "ERROR MESSAGE: %s");
            return ((ModlObject.String)mapItem.getModlValue()).string;
        }
        return null;
    }
}

