/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.net.IDN;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import uk.modl.interpreter.StringEscapeReplacer;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

public class StringTransformer {
    Map<String, ModlValue> valuePairs;
    Map<String, Function<String, String>> variableMethods;
    Map<String, ModlValue> variables;
    Map<Integer, ModlValue> numberedVariables;

    public StringTransformer(Map<String, ModlValue> valuePairs, Map<String, Function<String, String>> variableMethods, Map<String, ModlValue> variables, Map<Integer, ModlValue> numberedVariables) {
        this.valuePairs = valuePairs;
        this.variableMethods = variableMethods;
        this.variables = variables;
        this.numberedVariables = numberedVariables;
    }

    protected ModlValue transformString(String stringToTransform) {
        ModlValue ret;
        if (stringToTransform == null) {
            return null;
        }
        ModlObject modlObject = new ModlObject();
        if (stringToTransform.toLowerCase().equals("true")) {
            return new ModlObject.True(modlObject);
        }
        if (stringToTransform.toLowerCase().equals("false")) {
            return new ModlObject.False(modlObject);
        }
        stringToTransform = StringEscapeUtils.unescapeJava((String)stringToTransform);
        List<String> graveParts = this.getGravePartsFromString(stringToTransform);
        for (String gravePart : graveParts) {
            String newGravePart = null;
            if (gravePart.startsWith("`%")) {
                ret = this.runObjectReferencing(gravePart, stringToTransform, true);
                if (ret instanceof ModlObject.String) {
                    stringToTransform = ((ModlObject.String)ret).string;
                    String nonGravePart = gravePart.substring(1, gravePart.length() - 1);
                    stringToTransform = stringToTransform.replace(gravePart, nonGravePart);
                    continue;
                }
                throw new RuntimeException("Can't have non-string in string transformation!");
            }
            newGravePart = this.replacePunycode(gravePart);
            stringToTransform = stringToTransform.replace(gravePart, newGravePart);
        }
        List<String> percentParts = this.getPercentPartsFromString(stringToTransform);
        for (String percentPart : percentParts) {
            ret = this.runObjectReferencing(percentPart, stringToTransform, false);
            if (ret instanceof ModlObject.String) {
                stringToTransform = ((ModlObject.String)ret).string;
                continue;
            }
            if (ret instanceof ModlObject.Number) {
                if (percentPart.equals(stringToTransform)) {
                    return ret;
                }
                String number = ((ModlObject.Number)ret).number;
                stringToTransform = stringToTransform.replace(percentPart, number);
                continue;
            }
            return ret;
        }
        stringToTransform = this.replaceEscapedStrings(stringToTransform);
        ModlObject modlObject2 = modlObject;
        modlObject2.getClass();
        return new ModlObject.String(modlObject2, stringToTransform);
    }

    private List<String> getPercentPartsFromString(String stringToTransform) {
        LinkedList<String> percentParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            finished = true;
            Integer startIndex = this.getNextPercent(stringToTransform, currentIndex);
            if (startIndex == null) continue;
            Integer endIndex = null;
            if (startIndex < stringToTransform.length() - 1 && !this.isNumber(stringToTransform.substring(startIndex + 1, startIndex + 2))) {
                int spaceEndIndex = stringToTransform.indexOf(" ", (int)startIndex);
                int colonEndIndex = stringToTransform.indexOf(":", (int)startIndex);
                if (spaceEndIndex == -1) {
                    spaceEndIndex = 99999;
                }
                if (colonEndIndex == -1) {
                    colonEndIndex = 99999;
                }
                if ((endIndex = Integer.valueOf(Math.min(spaceEndIndex, colonEndIndex))) > stringToTransform.length()) {
                    endIndex = stringToTransform.length();
                }
            } else {
                if (startIndex == stringToTransform.length() - 1) {
                    return percentParts;
                }
                endIndex = this.getEndOfNumber(stringToTransform, startIndex + 1);
            }
            if (endIndex == null || endIndex == -1) continue;
            if (endIndex > startIndex + 1) {
                String gravePart = stringToTransform.substring(startIndex, endIndex);
                percentParts.add(gravePart);
                currentIndex = endIndex + 1;
            }
            finished = false;
        }
        return percentParts;
    }

    private Integer getEndOfNumber(String stringToTransform, Integer startIndex) {
        Integer n;
        Integer currentIndex = startIndex;
        if (currentIndex.intValue() == stringToTransform.length()) {
            return currentIndex;
        }
        while (this.isNumber(stringToTransform.substring(currentIndex, currentIndex + 1))) {
            Integer n2 = currentIndex;
            n = currentIndex = Integer.valueOf(currentIndex + 1);
            if (currentIndex.intValue() != stringToTransform.length()) continue;
            return currentIndex;
        }
        if (!stringToTransform.substring(currentIndex, currentIndex + 1).equals(".")) {
            return currentIndex;
        }
        String newMethod = "";
        while (true) {
            n = currentIndex;
            Integer n3 = currentIndex = Integer.valueOf(currentIndex + 1);
            if (currentIndex > stringToTransform.length() - 1) {
                return currentIndex;
            }
            String nextChar = stringToTransform.substring(currentIndex, currentIndex + 1);
            if (nextChar.equals(".")) {
                if (newMethod.length() > 0) {
                    newMethod = "";
                    continue;
                }
                return currentIndex;
            }
            if (!Character.isLetter(nextChar.charAt(0))) {
                return currentIndex;
            }
            if (!this.isVariableMethod(newMethod + nextChar)) break;
            newMethod = newMethod + nextChar;
        }
        if (newMethod.length() > 0) {
            return currentIndex;
        }
        return currentIndex - 1;
    }

    private boolean isVariableMethod(String s) {
        for (Map.Entry<String, Function<String, String>> entry : this.variableMethods.entrySet()) {
            if (!s.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private boolean isNumber(String substring) {
        return substring.equals("0") || substring.equals("1") || substring.equals("2") || substring.equals("3") || substring.equals("4") || substring.equals("5") || substring.equals("6") || substring.equals("7") || substring.equals("8") || substring.equals("9");
    }

    private Integer getNextPercent(String stringToTransform, Integer startIndex) {
        int index = stringToTransform.indexOf("%", (int)startIndex);
        if (index == -1) {
            return null;
        }
        return index;
    }

    private List<String> getGravePartsFromString(String stringToTransform) {
        LinkedList<String> graveParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            Integer endIndex;
            finished = true;
            Integer startIndex = this.getNextNonPrefixedGrave(stringToTransform, currentIndex);
            if (startIndex == null || (endIndex = this.getNextNonPrefixedGrave(stringToTransform, startIndex + 1)) == null) continue;
            String gravePart = stringToTransform.substring(startIndex, endIndex + 1);
            graveParts.add(gravePart);
            currentIndex = endIndex + 1;
            finished = false;
        }
        return graveParts;
    }

    private Integer getNextNonPrefixedGrave(String stringToTransform, Integer startIndex) {
        int index = stringToTransform.indexOf("`", (int)startIndex);
        if (index == -1) {
            return null;
        }
        if (index > startIndex) {
            String prefix = stringToTransform.substring(index - 1, index);
            if (prefix.equals("~") || prefix.equals("\\")) {
                return this.getNextNonPrefixedGrave(stringToTransform, index + 1);
            }
            return index;
        }
        return startIndex;
    }

    private String replaceEscapedStrings(String stringToTransform) {
        return StringEscapeReplacer.replace(stringToTransform);
    }

    private String replacePunycode(String stringToTransform) {
        if (stringToTransform == null) {
            return stringToTransform;
        }
        if (stringToTransform.startsWith("`") && stringToTransform.endsWith("`")) {
            String originalString = stringToTransform = stringToTransform.substring(1, stringToTransform.length() - 1);
            stringToTransform = "xn--" + stringToTransform;
            String newStringToTransform = IDN.toUnicode(stringToTransform);
            stringToTransform = newStringToTransform.equals(stringToTransform) ? originalString : newStringToTransform;
        }
        return stringToTransform;
    }

    public ModlValue runObjectReferencing(String percentPart, String stringToTransform, boolean isGraved) {
        ModlValue value;
        int startOffset = 1;
        int endOffset = 0;
        if (isGraved) {
            startOffset = 2;
            endOffset = 1;
        }
        ModlObject modlObject = new ModlObject();
        String subject = percentPart.substring(startOffset, percentPart.length() - endOffset);
        String methodChain = null;
        int indexOfDot = percentPart.indexOf(".");
        if (indexOfDot != -1) {
            subject = percentPart.substring(startOffset, indexOfDot);
            methodChain = percentPart.substring(indexOfDot + 1, percentPart.length() - endOffset);
        }
        if ((value = this.getValueForReference(subject)) == null) {
            ModlObject modlObject2 = modlObject;
            modlObject2.getClass();
            return new ModlObject.String(modlObject2, stringToTransform);
        }
        if (!(value instanceof ModlObject.String)) {
            return value;
        }
        subject = ((ModlObject.String)value).string;
        if (methodChain != null) {
            String[] methods = methodChain.split("\\.");
            if (methods.length == 0) {
                methods = new String[]{methodChain};
            }
            for (String method : methods) {
                if (method.indexOf("(") >= 0) {
                    int startParamsIndex = method.indexOf("(");
                    String paramsString = method.substring(startParamsIndex + 1, method.length() - 1);
                    String methodString = method.substring(0, startParamsIndex);
                    subject = this.variableMethods.get(methodString).apply(subject + "," + paramsString);
                    continue;
                }
                subject = this.variableMethods.get(method) == null ? subject + "." + method : this.variableMethods.get(method).apply(subject);
            }
        }
        stringToTransform = stringToTransform.replace(percentPart, subject);
        ModlObject modlObject3 = modlObject;
        modlObject3.getClass();
        return new ModlObject.String(modlObject3, stringToTransform);
    }

    private ModlValue getValueForReference(String subject) {
        ModlValue value = null;
        boolean found = false;
        Integer i = 0;
        while (i < this.numberedVariables.size()) {
            if (subject.equals(i.toString())) {
                value = this.numberedVariables.get(i) instanceof ModlObject.String ? this.numberedVariables.get(i) : this.numberedVariables.get(i);
                found = true;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        for (Map.Entry<String, ModlValue> variableEntry : this.variables.entrySet()) {
            if (!subject.equals(variableEntry.getKey())) continue;
            value = variableEntry.getValue();
            found = true;
        }
        for (Map.Entry<String, ModlValue> variableEntry : this.valuePairs.entrySet()) {
            if (!subject.equals(variableEntry.getKey()) && !subject.equals("_" + variableEntry.getKey())) continue;
            value = variableEntry.getValue();
            found = true;
        }
        if (!found) {
            return null;
        }
        return value;
    }
}

