/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import uk.co.real_logic.artio.decoder.DictionaryAcceptor;
import uk.co.real_logic.artio.decoder.ExampleMessageDecoder;
import uk.co.real_logic.artio.decoder.ExecutionReportDecoder;
import uk.co.real_logic.artio.decoder.HeartbeatDecoder;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.decoder.LogoutDecoder;
import uk.co.real_logic.artio.decoder.NewOrderSingleDecoder;
import uk.co.real_logic.artio.decoder.RejectDecoder;
import uk.co.real_logic.artio.decoder.ResendRequestDecoder;
import uk.co.real_logic.artio.decoder.SequenceResetDecoder;
import uk.co.real_logic.artio.decoder.TestRequestDecoder;
import uk.co.real_logic.artio.decoder.UserRequestDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;

public final class DictionaryDecoder {
    private final DictionaryAcceptor acceptor;
    private final HeartbeatDecoder heartbeat = new HeartbeatDecoder();
    private final TestRequestDecoder testRequest = new TestRequestDecoder();
    private final ExampleMessageDecoder exampleMessage = new ExampleMessageDecoder();
    private final ResendRequestDecoder resendRequest = new ResendRequestDecoder();
    private final RejectDecoder reject = new RejectDecoder();
    private final SequenceResetDecoder sequenceReset = new SequenceResetDecoder();
    private final LogoutDecoder logout = new LogoutDecoder();
    private final LogonDecoder logon = new LogonDecoder();
    private final UserRequestDecoder userRequest = new UserRequestDecoder();
    private final NewOrderSingleDecoder newOrderSingle = new NewOrderSingleDecoder();
    private final ExecutionReportDecoder executionReport = new ExecutionReportDecoder();

    public DictionaryDecoder(DictionaryAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void onMessage(AsciiBuffer buffer, int offset, int length, long messageType) {
        if (messageType == 48L) {
            this.heartbeat.decode(buffer, offset, length);
            this.acceptor.onHeartbeat(this.heartbeat);
            this.heartbeat.reset();
        } else if (messageType == 49L) {
            this.testRequest.decode(buffer, offset, length);
            this.acceptor.onTestRequest(this.testRequest);
            this.testRequest.reset();
        } else if (messageType == 66L) {
            this.exampleMessage.decode(buffer, offset, length);
            this.acceptor.onExampleMessage(this.exampleMessage);
            this.exampleMessage.reset();
        } else if (messageType == 50L) {
            this.resendRequest.decode(buffer, offset, length);
            this.acceptor.onResendRequest(this.resendRequest);
            this.resendRequest.reset();
        } else if (messageType == 51L) {
            this.reject.decode(buffer, offset, length);
            this.acceptor.onReject(this.reject);
            this.reject.reset();
        } else if (messageType == 52L) {
            this.sequenceReset.decode(buffer, offset, length);
            this.acceptor.onSequenceReset(this.sequenceReset);
            this.sequenceReset.reset();
        } else if (messageType == 53L) {
            this.logout.decode(buffer, offset, length);
            this.acceptor.onLogout(this.logout);
            this.logout.reset();
        } else if (messageType == 65L) {
            this.logon.decode(buffer, offset, length);
            this.acceptor.onLogon(this.logon);
            this.logon.reset();
        } else if (messageType == 17730L) {
            this.userRequest.decode(buffer, offset, length);
            this.acceptor.onUserRequest(this.userRequest);
            this.userRequest.reset();
        } else if (messageType == 68L) {
            this.newOrderSingle.decode(buffer, offset, length);
            this.acceptor.onNewOrderSingle(this.newOrderSingle);
            this.newOrderSingle.reset();
        } else if (messageType == 56L) {
            this.executionReport.decode(buffer, offset, length);
            this.acceptor.onExecutionReport(this.executionReport);
            this.executionReport.reset();
        }
    }
}

