/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class OrderQtyDataEncoder {
    private static final int orderQtyHeaderLength = 3;
    private static final byte[] orderQtyHeader = new byte[]{51, 56, 61};
    private final DecimalFloat orderQty = new DecimalFloat();
    private boolean hasOrderQty;

    public boolean hasOrderQty() {
        return this.hasOrderQty;
    }

    public OrderQtyDataEncoder orderQty(DecimalFloat value) {
        this.orderQty.set(value);
        this.hasOrderQty = true;
        return this;
    }

    public OrderQtyDataEncoder orderQty(long value, int scale) {
        this.orderQty.set(value, scale);
        this.hasOrderQty = true;
        return this;
    }

    public DecimalFloat orderQty() {
        return this.orderQty;
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int position = offset;
        if (this.hasOrderQty) {
            buffer.putBytes(position, orderQtyHeader, 0, 3);
            position += 3;
            position += buffer.putFloatAscii(position, this.orderQty);
            buffer.putSeparator(position);
            ++position;
        }
        return position - offset;
    }

    public void reset() {
        this.resetOrderQty();
    }

    public void resetOrderQty() {
        this.hasOrderQty = false;
    }

    public String toString() {
        String entries = this.hasOrderQty() ? String.format("  \"OrderQty\": \"%s\",\n", this.orderQty) : "";
        entries = "{\n  \"MessageName\": \"OrderQtyData\",\n" + entries + "}";
        return entries;
    }
}

