/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder_flyweight;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.UserRequestType;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractUserRequestDecoder;
import uk.co.real_logic.artio.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.decoder_flyweight.MessageDecoder;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class UserRequestDecoder
implements MessageDecoder,
AbstractUserRequestDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(6);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final long MESSAGE_TYPE = 17730L;
    public static final String MESSAGE_TYPE_AS_STRING = "BE";
    public static final char[] MESSAGE_TYPE_CHARS = "BE".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "BE".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private char[] userRequestID;
    private int userRequestIDOffset;
    private int userRequestIDLength;
    private int userRequestType;
    private int userRequestTypeOffset;
    private int userRequestTypeLength;
    private final CharArrayWrapper userRequestTypeWrapper;
    private char[] username;
    private int usernameOffset;
    private int usernameLength;
    private char[] password;
    private boolean hasPassword;
    private int passwordOffset;
    private int passwordLength;
    private char[] newPassword;
    private boolean hasNewPassword;
    private int newPasswordOffset;
    private int newPasswordLength;
    private AsciiBuffer buffer;

    public UserRequestDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(923);
            this.REQUIRED_FIELDS.add(924);
            this.REQUIRED_FIELDS.add(553);
        }
        this.alreadyVisitedFields = new IntHashSet(10);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(6);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(42);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(923);
        this.messageFields.add(924);
        this.messageFields.add(553);
        this.messageFields.add(554);
        this.messageFields.add(925);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.userRequestID = new char[1];
        this.userRequestTypeWrapper = new CharArrayWrapper();
        this.username = new char[1];
        this.password = new char[1];
        this.newPassword = new char[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !UserRequestType.isValid(this.userRequestType())) {
            this.invalidTagId = 924;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public char[] userRequestID() {
        if (this.buffer != null && this.userRequestIDLength > 0) {
            this.userRequestID = this.buffer.getChars(this.userRequestID, this.userRequestIDOffset, this.userRequestIDLength);
        }
        return this.userRequestID;
    }

    public int userRequestIDLength() {
        return this.userRequestIDLength;
    }

    public String userRequestIDAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.userRequestIDOffset, this.userRequestIDLength) : "";
    }

    public void userRequestID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.userRequestIDOffset, this.userRequestIDLength);
    }

    public int userRequestType() {
        if (this.buffer != null && this.userRequestTypeLength > 0) {
            this.userRequestType = this.buffer.parseIntAscii(this.userRequestTypeOffset, this.userRequestTypeLength);
        }
        return this.userRequestType;
    }

    public int userRequestTypeLength() {
        return this.userRequestTypeLength;
    }

    public UserRequestType userRequestTypeAsEnum() {
        return UserRequestType.decode(this.userRequestType());
    }

    public char[] username() {
        if (this.buffer != null && this.usernameLength > 0) {
            this.username = this.buffer.getChars(this.username, this.usernameOffset, this.usernameLength);
        }
        return this.username;
    }

    public int usernameLength() {
        return this.usernameLength;
    }

    public String usernameAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength) : "";
    }

    public void username(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.usernameOffset, this.usernameLength);
    }

    public char[] password() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        if (this.buffer != null && this.passwordLength > 0) {
            this.password = this.buffer.getChars(this.password, this.passwordOffset, this.passwordLength);
        }
        return this.password;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public int passwordLength() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.passwordLength;
    }

    public String passwordAsString() {
        return this.hasPassword ? this.buffer.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength) : null;
    }

    public void password(AsciiSequenceView view) {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        view.wrap((DirectBuffer)this.buffer, this.passwordOffset, this.passwordLength);
    }

    public char[] newPassword() {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        if (this.buffer != null && this.newPasswordLength > 0) {
            this.newPassword = this.buffer.getChars(this.newPassword, this.newPasswordOffset, this.newPasswordLength);
        }
        return this.newPassword;
    }

    public boolean hasNewPassword() {
        return this.hasNewPassword;
    }

    public int newPasswordLength() {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        return this.newPasswordLength;
    }

    public String newPasswordAsString() {
        return this.hasNewPassword ? this.buffer.getStringWithoutLengthAscii(this.newPasswordOffset, this.newPasswordLength) : null;
    }

    public void newPassword(AsciiSequenceView view) {
        if (!this.hasNewPassword) {
            throw new IllegalArgumentException("No value for optional field: NewPassword");
        }
        view.wrap((DirectBuffer)this.buffer, this.newPasswordOffset, this.newPasswordLength);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 923: {
                    this.userRequestIDOffset = valueOffset;
                    this.userRequestIDLength = valueLength;
                    break;
                }
                case 924: {
                    this.userRequestTypeOffset = valueOffset;
                    this.userRequestTypeLength = valueLength;
                    break;
                }
                case 553: {
                    this.usernameOffset = valueOffset;
                    this.usernameLength = valueLength;
                    break;
                }
                case 554: {
                    this.hasPassword = true;
                    this.passwordOffset = valueOffset;
                    this.passwordLength = valueLength;
                    break;
                }
                case 925: {
                    this.hasNewPassword = true;
                    this.newPasswordOffset = valueOffset;
                    this.newPasswordLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetUserRequestID();
        this.resetUserRequestType();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
    }

    public void resetUserRequestID() {
        this.userRequestIDOffset = 0;
        this.userRequestIDLength = 0;
    }

    public void resetUserRequestType() {
        this.userRequestTypeLength = 0;
        this.userRequestType = Integer.MIN_VALUE;
    }

    public void resetUsername() {
        this.usernameOffset = 0;
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.hasPassword = false;
    }

    public void resetNewPassword() {
        this.hasNewPassword = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"UserRequestID\": \"%s\",\n", this.userRequestIDAsString()) + String.format("  \"UserRequestType\": \"%s\",\n", this.userRequestType()) + String.format("  \"Username\": \"%s\",\n", this.usernameAsString()) + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", this.passwordAsString()) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", this.newPasswordAsString()) : "");
        entries = "{\n  \"MessageName\": \"UserRequest\",\n" + entries + "}";
        return entries;
    }
}

