/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.ExecType;
import uk.co.real_logic.artio.OrdStatus;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.InstrumentDecoder;
import uk.co.real_logic.artio.decoder.MessageDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class ExecutionReportDecoder
implements InstrumentDecoder,
MessageDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(12);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final long MESSAGE_TYPE = 56L;
    public static final String MESSAGE_TYPE_AS_STRING = "8";
    public static final char[] MESSAGE_TYPE_CHARS = "8".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "8".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private char[] orderID;
    private int orderIDOffset;
    private int orderIDLength;
    private char[] execID;
    private int execIDOffset;
    private int execIDLength;
    private char execType;
    private final CharArrayWrapper execTypeWrapper;
    private char ordStatus;
    private final CharArrayWrapper ordStatusWrapper;
    private char[] symbol;
    private int symbolOffset;
    private int symbolLength;
    private char side;
    private final CharArrayWrapper sideWrapper;
    private AsciiBuffer buffer;

    public ExecutionReportDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(37);
            this.REQUIRED_FIELDS.add(17);
            this.REQUIRED_FIELDS.add(150);
            this.REQUIRED_FIELDS.add(39);
            this.REQUIRED_FIELDS.add(55);
            this.REQUIRED_FIELDS.add(54);
        }
        this.alreadyVisitedFields = new IntHashSet(12);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(12);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(44);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(37);
        this.messageFields.add(17);
        this.messageFields.add(150);
        this.messageFields.add(39);
        this.messageFields.add(55);
        this.messageFields.add(54);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.orderID = new char[1];
        this.execID = new char[1];
        this.execTypeWrapper = new CharArrayWrapper();
        this.ordStatusWrapper = new CharArrayWrapper();
        this.symbol = new char[1];
        this.sideWrapper = new CharArrayWrapper();
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !ExecType.isValid(this.execType())) {
            this.invalidTagId = 150;
            this.rejectReason = 5;
            return false;
        }
        if (RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !OrdStatus.isValid(this.ordStatus())) {
            this.invalidTagId = 39;
            this.rejectReason = 5;
            return false;
        }
        if (RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !Side.isValid(this.side())) {
            this.invalidTagId = 54;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public char[] orderID() {
        return this.orderID;
    }

    public int orderIDLength() {
        return this.orderIDLength;
    }

    public String orderIDAsString() {
        return new String(this.orderID, 0, this.orderIDLength);
    }

    public void orderID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.orderIDOffset, this.orderIDLength);
    }

    public char[] execID() {
        return this.execID;
    }

    public int execIDLength() {
        return this.execIDLength;
    }

    public String execIDAsString() {
        return new String(this.execID, 0, this.execIDLength);
    }

    public void execID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.execIDOffset, this.execIDLength);
    }

    public char execType() {
        return this.execType;
    }

    public ExecType execTypeAsEnum() {
        return ExecType.decode(this.execType);
    }

    public char ordStatus() {
        return this.ordStatus;
    }

    public OrdStatus ordStatusAsEnum() {
        return OrdStatus.decode(this.ordStatus);
    }

    @Override
    public char[] symbol() {
        return this.symbol;
    }

    @Override
    public int symbolLength() {
        return this.symbolLength;
    }

    public String symbolAsString() {
        return new String(this.symbol, 0, this.symbolLength);
    }

    @Override
    public void symbol(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.symbolOffset, this.symbolLength);
    }

    public char side() {
        return this.side;
    }

    public Side sideAsEnum() {
        return Side.decode(this.side);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 37: {
                    this.orderID = buffer.getChars(this.orderID, valueOffset, valueLength);
                    this.orderIDOffset = valueOffset;
                    this.orderIDLength = valueLength;
                    break;
                }
                case 17: {
                    this.execID = buffer.getChars(this.execID, valueOffset, valueLength);
                    this.execIDOffset = valueOffset;
                    this.execIDLength = valueLength;
                    break;
                }
                case 150: {
                    this.execType = buffer.getChar(valueOffset);
                    break;
                }
                case 39: {
                    this.ordStatus = buffer.getChar(valueOffset);
                    break;
                }
                case 55: {
                    this.symbol = buffer.getChars(this.symbol, valueOffset, valueLength);
                    this.symbolOffset = valueOffset;
                    this.symbolLength = valueLength;
                    break;
                }
                case 54: {
                    this.side = buffer.getChar(valueOffset);
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetOrderID();
        this.resetExecID();
        this.resetExecType();
        this.resetOrdStatus();
        this.resetSide();
        this.resetSymbol();
    }

    public void resetOrderID() {
        this.orderIDOffset = 0;
        this.orderIDLength = 0;
    }

    public void resetExecID() {
        this.execIDOffset = 0;
        this.execIDLength = 0;
    }

    public void resetExecType() {
        this.execType = '\u0001';
    }

    public void resetOrdStatus() {
        this.ordStatus = '\u0001';
    }

    public void resetSide() {
        this.side = '\u0001';
    }

    public void resetSymbol() {
        this.symbolOffset = 0;
        this.symbolLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"OrderID\": \"%s\",\n", this.orderIDAsString()) + String.format("  \"ExecID\": \"%s\",\n", this.execIDAsString()) + String.format("  \"ExecType\": \"%s\",\n", Character.valueOf(this.execType)) + String.format("  \"OrdStatus\": \"%s\",\n", Character.valueOf(this.ordStatus)) + String.format("  \"Symbol\": \"%s\",\n", this.symbolAsString()) + String.format("  \"Side\": \"%s\",\n", Character.valueOf(this.side));
        entries = "{\n  \"MessageName\": \"ExecutionReport\",\n" + entries + "}";
        return entries;
    }
}

