/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder_flyweight;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.SessionRejectReason;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.decoder_flyweight.MessageDecoder;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class RejectDecoder
implements MessageDecoder,
AbstractRejectDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(2);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final int MESSAGE_TYPE = 51;
    public static final String MESSAGE_TYPE_AS_STRING = "3";
    public static final char[] MESSAGE_TYPE_CHARS = "3".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "3".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private int refSeqNum;
    private int refSeqNumOffset;
    private int refSeqNumLength;
    private int refTagID;
    private boolean hasRefTagID;
    private int refTagIDOffset;
    private int refTagIDLength;
    private char[] refMsgType;
    private boolean hasRefMsgType;
    private int refMsgTypeOffset;
    private int refMsgTypeLength;
    private int sessionRejectReason;
    private boolean hasSessionRejectReason;
    private int sessionRejectReasonOffset;
    private int sessionRejectReasonLength;
    private final CharArrayWrapper sessionRejectReasonWrapper;
    private char[] text;
    private boolean hasText;
    private int textOffset;
    private int textLength;
    private AsciiBuffer buffer;

    public RejectDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(45);
        }
        this.alreadyVisitedFields = new IntHashSet(10);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(2);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(42);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(45);
        this.messageFields.add(371);
        this.messageFields.add(372);
        this.messageFields.add(373);
        this.messageFields.add(58);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.refMsgType = new char[1];
        this.sessionRejectReasonWrapper = new CharArrayWrapper();
        this.text = new char[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (this.hasSessionRejectReason && RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !SessionRejectReason.isValid(this.sessionRejectReason())) {
            this.invalidTagId = 373;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public int refSeqNum() {
        if (this.buffer != null && this.refSeqNumLength > 0) {
            this.refSeqNum = this.buffer.parseIntAscii(this.refSeqNumOffset, this.refSeqNumLength);
        }
        return this.refSeqNum;
    }

    public int refSeqNumLength() {
        return this.refSeqNumLength;
    }

    public int refTagID() {
        if (!this.hasRefTagID) {
            throw new IllegalArgumentException("No value for optional field: RefTagID");
        }
        if (this.buffer != null && this.refTagIDLength > 0) {
            this.refTagID = this.buffer.parseIntAscii(this.refTagIDOffset, this.refTagIDLength);
        }
        return this.refTagID;
    }

    public boolean hasRefTagID() {
        return this.hasRefTagID;
    }

    public int refTagIDLength() {
        if (!this.hasRefTagID) {
            throw new IllegalArgumentException("No value for optional field: RefTagID");
        }
        return this.refTagIDLength;
    }

    public char[] refMsgType() {
        if (!this.hasRefMsgType) {
            throw new IllegalArgumentException("No value for optional field: RefMsgType");
        }
        if (this.buffer != null && this.refMsgTypeLength > 0) {
            this.refMsgType = this.buffer.getChars(this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
        }
        return this.refMsgType;
    }

    public boolean hasRefMsgType() {
        return this.hasRefMsgType;
    }

    public int refMsgTypeLength() {
        if (!this.hasRefMsgType) {
            throw new IllegalArgumentException("No value for optional field: RefMsgType");
        }
        return this.refMsgTypeLength;
    }

    public String refMsgTypeAsString() {
        return this.hasRefMsgType ? this.buffer.getStringWithoutLengthAscii(this.refMsgTypeOffset, this.refMsgTypeLength) : null;
    }

    public void refMsgType(AsciiSequenceView view) {
        if (!this.hasRefMsgType) {
            throw new IllegalArgumentException("No value for optional field: RefMsgType");
        }
        view.wrap((DirectBuffer)this.buffer, this.refMsgTypeOffset, this.refMsgTypeLength);
    }

    public int sessionRejectReason() {
        if (!this.hasSessionRejectReason) {
            throw new IllegalArgumentException("No value for optional field: SessionRejectReason");
        }
        if (this.buffer != null && this.sessionRejectReasonLength > 0) {
            this.sessionRejectReason = this.buffer.parseIntAscii(this.sessionRejectReasonOffset, this.sessionRejectReasonLength);
        }
        return this.sessionRejectReason;
    }

    public boolean hasSessionRejectReason() {
        return this.hasSessionRejectReason;
    }

    public int sessionRejectReasonLength() {
        if (!this.hasSessionRejectReason) {
            throw new IllegalArgumentException("No value for optional field: SessionRejectReason");
        }
        return this.sessionRejectReasonLength;
    }

    public SessionRejectReason sessionRejectReasonAsEnum() {
        if (!this.hasSessionRejectReason) {
            return SessionRejectReason.NULL_VAL;
        }
        return SessionRejectReason.decode(this.sessionRejectReason());
    }

    public char[] text() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        if (this.buffer != null && this.textLength > 0) {
            this.text = this.buffer.getChars(this.text, this.textOffset, this.textLength);
        }
        return this.text;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public int textLength() {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        return this.textLength;
    }

    public String textAsString() {
        return this.hasText ? this.buffer.getStringWithoutLengthAscii(this.textOffset, this.textLength) : null;
    }

    public void text(AsciiSequenceView view) {
        if (!this.hasText) {
            throw new IllegalArgumentException("No value for optional field: Text");
        }
        view.wrap((DirectBuffer)this.buffer, this.textOffset, this.textLength);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 45: {
                    this.refSeqNumOffset = valueOffset;
                    this.refSeqNumLength = valueLength;
                    break;
                }
                case 371: {
                    this.hasRefTagID = true;
                    this.refTagIDOffset = valueOffset;
                    this.refTagIDLength = valueLength;
                    break;
                }
                case 372: {
                    this.hasRefMsgType = true;
                    this.refMsgTypeOffset = valueOffset;
                    this.refMsgTypeLength = valueLength;
                    break;
                }
                case 373: {
                    this.hasSessionRejectReason = true;
                    this.sessionRejectReasonOffset = valueOffset;
                    this.sessionRejectReasonLength = valueLength;
                    break;
                }
                case 58: {
                    this.hasText = true;
                    this.textOffset = valueOffset;
                    this.textLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetRefSeqNum();
        this.resetRefTagID();
        this.resetRefMsgType();
        this.resetSessionRejectReason();
        this.resetText();
    }

    public void resetRefSeqNum() {
        this.refSeqNumLength = 0;
        this.refSeqNum = Integer.MIN_VALUE;
    }

    public void resetRefTagID() {
        this.hasRefTagID = false;
    }

    public void resetRefMsgType() {
        this.hasRefMsgType = false;
    }

    public void resetSessionRejectReason() {
        this.hasSessionRejectReason = false;
    }

    public void resetText() {
        this.hasText = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"RefSeqNum\": \"%s\",\n", this.refSeqNum()) + (this.hasRefTagID() ? String.format("  \"RefTagID\": \"%s\",\n", this.refTagID()) : "") + (this.hasRefMsgType() ? String.format("  \"RefMsgType\": \"%s\",\n", this.refMsgTypeAsString()) : "") + (this.hasSessionRejectReason() ? String.format("  \"SessionRejectReason\": \"%s\",\n", this.sessionRejectReason()) : "") + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", this.textAsString()) : "");
        entries = "{\n  \"MessageName\": \"Reject\",\n" + entries + "}";
        return entries;
    }
}

