/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder_flyweight;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.MsgType;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class HeaderDecoder
implements Decoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(14);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    private final TrailerDecoder trailer;
    private char[] beginString;
    private int beginStringOffset;
    private int beginStringLength;
    private int bodyLength;
    private int bodyLengthOffset;
    private int bodyLengthLength;
    private char[] msgType;
    private int msgTypeOffset;
    private int msgTypeLength;
    private final CharArrayWrapper msgTypeWrapper;
    private char[] senderCompID;
    private int senderCompIDOffset;
    private int senderCompIDLength;
    private char[] targetCompID;
    private int targetCompIDOffset;
    private int targetCompIDLength;
    private int msgSeqNum;
    private int msgSeqNumOffset;
    private int msgSeqNumLength;
    private char[] senderSubID;
    private boolean hasSenderSubID;
    private int senderSubIDOffset;
    private int senderSubIDLength;
    private char[] senderLocationID;
    private boolean hasSenderLocationID;
    private int senderLocationIDOffset;
    private int senderLocationIDLength;
    private char[] targetSubID;
    private boolean hasTargetSubID;
    private int targetSubIDOffset;
    private int targetSubIDLength;
    private char[] targetLocationID;
    private boolean hasTargetLocationID;
    private int targetLocationIDOffset;
    private int targetLocationIDLength;
    private boolean possDupFlag;
    private boolean hasPossDupFlag;
    private boolean possResend;
    private boolean hasPossResend;
    private byte[] sendingTime;
    private int sendingTimeOffset;
    private int sendingTimeLength;
    private byte[] origSendingTime;
    private boolean hasOrigSendingTime;
    private int origSendingTimeOffset;
    private int origSendingTimeLength;
    private int lastMsgSeqNumProcessed;
    private boolean hasLastMsgSeqNumProcessed;
    private int lastMsgSeqNumProcessedOffset;
    private int lastMsgSeqNumProcessedLength;
    private AsciiBuffer buffer;

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        this.msgTypeWrapper.wrap(this.msgType(), this.msgTypeLength);
        if (!MsgType.isValid(this.msgTypeWrapper)) {
            this.invalidTagId = 35;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    public HeaderDecoder() {
        this(new TrailerDecoder());
    }

    public HeaderDecoder(TrailerDecoder trailer) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(8);
            this.REQUIRED_FIELDS.add(9);
            this.REQUIRED_FIELDS.add(35);
            this.REQUIRED_FIELDS.add(49);
            this.REQUIRED_FIELDS.add(56);
            this.REQUIRED_FIELDS.add(34);
            this.REQUIRED_FIELDS.add(52);
        }
        this.alreadyVisitedFields = new IntHashSet(30);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(14);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.beginString = new char[1];
        this.msgType = new char[1];
        this.msgTypeWrapper = new CharArrayWrapper();
        this.senderCompID = new char[1];
        this.targetCompID = new char[1];
        this.senderSubID = new char[1];
        this.senderLocationID = new char[1];
        this.targetSubID = new char[1];
        this.targetLocationID = new char[1];
        this.sendingTime = new byte[24];
        this.origSendingTime = new byte[24];
        this.trailer = trailer;
    }

    public char[] beginString() {
        if (this.buffer != null && this.beginStringLength > 0) {
            this.beginString = this.buffer.getChars(this.beginString, this.beginStringOffset, this.beginStringLength);
        }
        return this.beginString;
    }

    public int beginStringLength() {
        return this.beginStringLength;
    }

    public String beginStringAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.beginStringOffset, this.beginStringLength) : "";
    }

    public void beginString(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.beginStringOffset, this.beginStringLength);
    }

    public int bodyLength() {
        if (this.buffer != null && this.bodyLengthLength > 0) {
            this.bodyLength = this.buffer.parseIntAscii(this.bodyLengthOffset, this.bodyLengthLength);
        }
        return this.bodyLength;
    }

    public int bodyLengthLength() {
        return this.bodyLengthLength;
    }

    public char[] msgType() {
        if (this.buffer != null && this.msgTypeLength > 0) {
            this.msgType = this.buffer.getChars(this.msgType, this.msgTypeOffset, this.msgTypeLength);
        }
        return this.msgType;
    }

    public int msgTypeLength() {
        return this.msgTypeLength;
    }

    public String msgTypeAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.msgTypeOffset, this.msgTypeLength) : "";
    }

    public void msgType(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.msgTypeOffset, this.msgTypeLength);
    }

    public MsgType msgTypeAsEnum() {
        this.msgTypeWrapper.wrap(this.msgType(), this.msgTypeLength);
        return MsgType.decode(this.msgTypeWrapper);
    }

    public char[] senderCompID() {
        if (this.buffer != null && this.senderCompIDLength > 0) {
            this.senderCompID = this.buffer.getChars(this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength);
        }
        return this.senderCompID;
    }

    public int senderCompIDLength() {
        return this.senderCompIDLength;
    }

    public String senderCompIDAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.senderCompIDOffset, this.senderCompIDLength) : "";
    }

    public void senderCompID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.senderCompIDOffset, this.senderCompIDLength);
    }

    public char[] targetCompID() {
        if (this.buffer != null && this.targetCompIDLength > 0) {
            this.targetCompID = this.buffer.getChars(this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength);
        }
        return this.targetCompID;
    }

    public int targetCompIDLength() {
        return this.targetCompIDLength;
    }

    public String targetCompIDAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.targetCompIDOffset, this.targetCompIDLength) : "";
    }

    public void targetCompID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.targetCompIDOffset, this.targetCompIDLength);
    }

    public int msgSeqNum() {
        if (this.buffer != null && this.msgSeqNumLength > 0) {
            this.msgSeqNum = this.buffer.parseIntAscii(this.msgSeqNumOffset, this.msgSeqNumLength);
        }
        return this.msgSeqNum;
    }

    public int msgSeqNumLength() {
        return this.msgSeqNumLength;
    }

    public char[] senderSubID() {
        if (!this.hasSenderSubID) {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }
        if (this.buffer != null && this.senderSubIDLength > 0) {
            this.senderSubID = this.buffer.getChars(this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength);
        }
        return this.senderSubID;
    }

    public boolean hasSenderSubID() {
        return this.hasSenderSubID;
    }

    public int senderSubIDLength() {
        if (!this.hasSenderSubID) {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }
        return this.senderSubIDLength;
    }

    public String senderSubIDAsString() {
        return this.hasSenderSubID ? this.buffer.getStringWithoutLengthAscii(this.senderSubIDOffset, this.senderSubIDLength) : null;
    }

    public void senderSubID(AsciiSequenceView view) {
        if (!this.hasSenderSubID) {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }
        view.wrap((DirectBuffer)this.buffer, this.senderSubIDOffset, this.senderSubIDLength);
    }

    public char[] senderLocationID() {
        if (!this.hasSenderLocationID) {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }
        if (this.buffer != null && this.senderLocationIDLength > 0) {
            this.senderLocationID = this.buffer.getChars(this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength);
        }
        return this.senderLocationID;
    }

    public boolean hasSenderLocationID() {
        return this.hasSenderLocationID;
    }

    public int senderLocationIDLength() {
        if (!this.hasSenderLocationID) {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }
        return this.senderLocationIDLength;
    }

    public String senderLocationIDAsString() {
        return this.hasSenderLocationID ? this.buffer.getStringWithoutLengthAscii(this.senderLocationIDOffset, this.senderLocationIDLength) : null;
    }

    public void senderLocationID(AsciiSequenceView view) {
        if (!this.hasSenderLocationID) {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }
        view.wrap((DirectBuffer)this.buffer, this.senderLocationIDOffset, this.senderLocationIDLength);
    }

    public char[] targetSubID() {
        if (!this.hasTargetSubID) {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }
        if (this.buffer != null && this.targetSubIDLength > 0) {
            this.targetSubID = this.buffer.getChars(this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength);
        }
        return this.targetSubID;
    }

    public boolean hasTargetSubID() {
        return this.hasTargetSubID;
    }

    public int targetSubIDLength() {
        if (!this.hasTargetSubID) {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }
        return this.targetSubIDLength;
    }

    public String targetSubIDAsString() {
        return this.hasTargetSubID ? this.buffer.getStringWithoutLengthAscii(this.targetSubIDOffset, this.targetSubIDLength) : null;
    }

    public void targetSubID(AsciiSequenceView view) {
        if (!this.hasTargetSubID) {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }
        view.wrap((DirectBuffer)this.buffer, this.targetSubIDOffset, this.targetSubIDLength);
    }

    public char[] targetLocationID() {
        if (!this.hasTargetLocationID) {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }
        if (this.buffer != null && this.targetLocationIDLength > 0) {
            this.targetLocationID = this.buffer.getChars(this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength);
        }
        return this.targetLocationID;
    }

    public boolean hasTargetLocationID() {
        return this.hasTargetLocationID;
    }

    public int targetLocationIDLength() {
        if (!this.hasTargetLocationID) {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }
        return this.targetLocationIDLength;
    }

    public String targetLocationIDAsString() {
        return this.hasTargetLocationID ? this.buffer.getStringWithoutLengthAscii(this.targetLocationIDOffset, this.targetLocationIDLength) : null;
    }

    public void targetLocationID(AsciiSequenceView view) {
        if (!this.hasTargetLocationID) {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }
        view.wrap((DirectBuffer)this.buffer, this.targetLocationIDOffset, this.targetLocationIDLength);
    }

    public boolean possDupFlag() {
        if (!this.hasPossDupFlag) {
            throw new IllegalArgumentException("No value for optional field: PossDupFlag");
        }
        return this.possDupFlag;
    }

    public boolean hasPossDupFlag() {
        return this.hasPossDupFlag;
    }

    public boolean possResend() {
        if (!this.hasPossResend) {
            throw new IllegalArgumentException("No value for optional field: PossResend");
        }
        return this.possResend;
    }

    public boolean hasPossResend() {
        return this.hasPossResend;
    }

    public byte[] sendingTime() {
        if (this.buffer != null && this.sendingTimeLength > 0) {
            this.sendingTime = this.buffer.getBytes(this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength);
        }
        return this.sendingTime;
    }

    public int sendingTimeLength() {
        return this.sendingTimeLength;
    }

    public String sendingTimeAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.sendingTimeOffset, this.sendingTimeLength) : "";
    }

    public void sendingTime(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.sendingTimeOffset, this.sendingTimeLength);
    }

    public byte[] origSendingTime() {
        if (!this.hasOrigSendingTime) {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }
        if (this.buffer != null && this.origSendingTimeLength > 0) {
            this.origSendingTime = this.buffer.getBytes(this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength);
        }
        return this.origSendingTime;
    }

    public boolean hasOrigSendingTime() {
        return this.hasOrigSendingTime;
    }

    public int origSendingTimeLength() {
        if (!this.hasOrigSendingTime) {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }
        return this.origSendingTimeLength;
    }

    public String origSendingTimeAsString() {
        return this.hasOrigSendingTime ? this.buffer.getStringWithoutLengthAscii(this.origSendingTimeOffset, this.origSendingTimeLength) : null;
    }

    public void origSendingTime(AsciiSequenceView view) {
        if (!this.hasOrigSendingTime) {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }
        view.wrap((DirectBuffer)this.buffer, this.origSendingTimeOffset, this.origSendingTimeLength);
    }

    public int lastMsgSeqNumProcessed() {
        if (!this.hasLastMsgSeqNumProcessed) {
            throw new IllegalArgumentException("No value for optional field: LastMsgSeqNumProcessed");
        }
        if (this.buffer != null && this.lastMsgSeqNumProcessedLength > 0) {
            this.lastMsgSeqNumProcessed = this.buffer.parseIntAscii(this.lastMsgSeqNumProcessedOffset, this.lastMsgSeqNumProcessedLength);
        }
        return this.lastMsgSeqNumProcessed;
    }

    public boolean hasLastMsgSeqNumProcessed() {
        return this.hasLastMsgSeqNumProcessed;
    }

    public int lastMsgSeqNumProcessedLength() {
        if (!this.hasLastMsgSeqNumProcessed) {
            throw new IllegalArgumentException("No value for optional field: LastMsgSeqNumProcessed");
        }
        return this.lastMsgSeqNumProcessedLength;
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                } else if (seenFieldCount == 0 && tag != 8) {
                    this.invalidTagId = tag;
                    this.rejectReason = 14;
                } else if (seenFieldCount == 1 && tag != 9) {
                    this.invalidTagId = tag;
                    this.rejectReason = 14;
                } else if (seenFieldCount == 2 && tag != 35) {
                    this.invalidTagId = tag;
                    this.rejectReason = 14;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 8: {
                    this.beginStringOffset = valueOffset;
                    this.beginStringLength = valueLength;
                    break;
                }
                case 9: {
                    this.bodyLengthOffset = valueOffset;
                    this.bodyLengthLength = valueLength;
                    break;
                }
                case 35: {
                    this.msgTypeOffset = valueOffset;
                    this.msgTypeLength = valueLength;
                    break;
                }
                case 49: {
                    this.senderCompIDOffset = valueOffset;
                    this.senderCompIDLength = valueLength;
                    break;
                }
                case 56: {
                    this.targetCompIDOffset = valueOffset;
                    this.targetCompIDLength = valueLength;
                    break;
                }
                case 34: {
                    this.msgSeqNumOffset = valueOffset;
                    this.msgSeqNumLength = valueLength;
                    break;
                }
                case 50: {
                    this.hasSenderSubID = true;
                    this.senderSubIDOffset = valueOffset;
                    this.senderSubIDLength = valueLength;
                    break;
                }
                case 142: {
                    this.hasSenderLocationID = true;
                    this.senderLocationIDOffset = valueOffset;
                    this.senderLocationIDLength = valueLength;
                    break;
                }
                case 57: {
                    this.hasTargetSubID = true;
                    this.targetSubIDOffset = valueOffset;
                    this.targetSubIDLength = valueLength;
                    break;
                }
                case 143: {
                    this.hasTargetLocationID = true;
                    this.targetLocationIDOffset = valueOffset;
                    this.targetLocationIDLength = valueLength;
                    break;
                }
                case 43: {
                    this.hasPossDupFlag = true;
                    this.possDupFlag = buffer.getBoolean(valueOffset);
                    break;
                }
                case 97: {
                    this.hasPossResend = true;
                    this.possResend = buffer.getBoolean(valueOffset);
                    break;
                }
                case 52: {
                    this.sendingTimeOffset = valueOffset;
                    this.sendingTimeLength = valueLength;
                    break;
                }
                case 122: {
                    this.hasOrigSendingTime = true;
                    this.origSendingTimeOffset = valueOffset;
                    this.origSendingTimeLength = valueLength;
                    break;
                }
                case 369: {
                    this.hasLastMsgSeqNumProcessed = true;
                    this.lastMsgSeqNumProcessedOffset = valueOffset;
                    this.lastMsgSeqNumProcessedLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        // empty if block
                    }
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        return position - offset;
    }

    public void reset() {
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetLastMsgSeqNumProcessed();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetSenderCompID() {
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = 0;
    }

    public void resetTargetCompID() {
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = 0;
    }

    public void resetMsgSeqNum() {
        this.msgSeqNumLength = 0;
        this.msgSeqNum = Integer.MIN_VALUE;
    }

    public void resetSenderSubID() {
        this.hasSenderSubID = false;
    }

    public void resetSenderLocationID() {
        this.hasSenderLocationID = false;
    }

    public void resetTargetSubID() {
        this.hasTargetSubID = false;
    }

    public void resetTargetLocationID() {
        this.hasTargetLocationID = false;
    }

    public void resetPossDupFlag() {
        this.hasPossDupFlag = false;
    }

    public void resetPossResend() {
        this.hasPossResend = false;
    }

    public void resetSendingTime() {
    }

    public void resetOrigSendingTime() {
        this.hasOrigSendingTime = false;
    }

    public void resetLastMsgSeqNumProcessed() {
        this.hasLastMsgSeqNumProcessed = false;
    }

    public String toString() {
        String entries = String.format("  \"BeginString\": \"%s\",\n", this.beginStringAsString()) + "" + String.format("  \"MsgType\": \"%s\",\n", this.msgTypeAsString()) + String.format("  \"SenderCompID\": \"%s\",\n", this.senderCompIDAsString()) + String.format("  \"TargetCompID\": \"%s\",\n", this.targetCompIDAsString()) + String.format("  \"MsgSeqNum\": \"%s\",\n", this.msgSeqNum()) + (this.hasSenderSubID() ? String.format("  \"SenderSubID\": \"%s\",\n", this.senderSubIDAsString()) : "") + (this.hasSenderLocationID() ? String.format("  \"SenderLocationID\": \"%s\",\n", this.senderLocationIDAsString()) : "") + (this.hasTargetSubID() ? String.format("  \"TargetSubID\": \"%s\",\n", this.targetSubIDAsString()) : "") + (this.hasTargetLocationID() ? String.format("  \"TargetLocationID\": \"%s\",\n", this.targetLocationIDAsString()) : "") + (this.hasPossDupFlag() ? String.format("  \"PossDupFlag\": \"%s\",\n", this.possDupFlag()) : "") + (this.hasPossResend() ? String.format("  \"PossResend\": \"%s\",\n", this.possResend()) : "") + String.format("  \"SendingTime\": \"%s\",\n", this.sendingTimeAsString()) + (this.hasOrigSendingTime() ? String.format("  \"OrigSendingTime\": \"%s\",\n", this.origSendingTimeAsString()) : "") + (this.hasLastMsgSeqNumProcessed() ? String.format("  \"LastMsgSeqNumProcessed\": \"%s\",\n", this.lastMsgSeqNumProcessed()) : "");
        entries = "{\n  \"MessageName\": \"Header\",\n" + entries + "}";
        return entries;
    }
}

