/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.MessageDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class LogonDecoder
implements MessageDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(4);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final int MESSAGE_TYPE = 65;
    public static final String MESSAGE_TYPE_AS_STRING = "A";
    public static final char[] MESSAGE_TYPE_CHARS = "A".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "A".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private TrailerDecoder trailer;
    private HeaderDecoder header;
    private int encryptMethod;
    private final CharArrayWrapper encryptMethodWrapper;
    private int heartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private char[] username;
    private boolean hasUsername;
    private int usernameOffset;
    private int usernameLength;
    private char[] password;
    private boolean hasPassword;
    private int passwordOffset;
    private int passwordLength;
    private AsciiBuffer buffer;

    public LogonDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(98);
            this.REQUIRED_FIELDS.add(108);
        }
        this.alreadyVisitedFields = new IntHashSet(20);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(4);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(52);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(98);
        this.messageFields.add(108);
        this.messageFields.add(95);
        this.messageFields.add(96);
        this.messageFields.add(141);
        this.messageFields.add(789);
        this.messageFields.add(383);
        this.messageFields.add(464);
        this.messageFields.add(553);
        this.messageFields.add(554);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.encryptMethodWrapper = new CharArrayWrapper();
        this.rawData = new byte[1];
        this.username = new char[1];
        this.password = new char[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (!EncryptMethod.isValid(this.encryptMethod())) {
            this.invalidTagId = 98;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public EncryptMethod encryptMethodAsEnum() {
        return EncryptMethod.decode(this.encryptMethod);
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public int rawDataLength() {
        if (!this.hasRawDataLength) {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }
        return this.rawDataLength;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public byte[] rawData() {
        if (!this.hasRawData) {
            throw new IllegalArgumentException("No value for optional field: RawData");
        }
        return this.rawData;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public boolean resetSeqNumFlag() {
        if (!this.hasResetSeqNumFlag) {
            throw new IllegalArgumentException("No value for optional field: ResetSeqNumFlag");
        }
        return this.resetSeqNumFlag;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public int nextExpectedMsgSeqNum() {
        if (!this.hasNextExpectedMsgSeqNum) {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public int maxMessageSize() {
        if (!this.hasMaxMessageSize) {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }
        return this.maxMessageSize;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public boolean testMessageIndicator() {
        if (!this.hasTestMessageIndicator) {
            throw new IllegalArgumentException("No value for optional field: TestMessageIndicator");
        }
        return this.testMessageIndicator;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public char[] username() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return this.username;
    }

    public boolean hasUsername() {
        return this.hasUsername;
    }

    public int usernameLength() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return this.usernameLength;
    }

    public String usernameAsString() {
        return this.hasUsername ? new String(this.username, 0, this.usernameLength) : null;
    }

    public void username(AsciiSequenceView view) {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        view.wrap((DirectBuffer)this.buffer, this.usernameOffset, this.usernameLength);
    }

    public char[] password() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.password;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public int passwordLength() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.passwordLength;
    }

    public String passwordAsString() {
        return this.hasPassword ? new String(this.password, 0, this.passwordLength) : null;
    }

    public void password(AsciiSequenceView view) {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        view.wrap((DirectBuffer)this.buffer, this.passwordOffset, this.passwordLength);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 98: {
                    this.encryptMethod = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 108: {
                    this.heartBtInt = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 95: {
                    this.hasRawDataLength = true;
                    this.rawDataLength = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 96: {
                    this.hasRawData = true;
                    this.rawData = buffer.getBytes(this.rawData, valueOffset, this.rawDataLength);
                    endOfField = valueOffset + this.rawDataLength;
                    break;
                }
                case 141: {
                    this.hasResetSeqNumFlag = true;
                    this.resetSeqNumFlag = buffer.getBoolean(valueOffset);
                    break;
                }
                case 789: {
                    this.hasNextExpectedMsgSeqNum = true;
                    this.nextExpectedMsgSeqNum = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 383: {
                    this.hasMaxMessageSize = true;
                    this.maxMessageSize = buffer.getInt(valueOffset, endOfField);
                    break;
                }
                case 464: {
                    this.hasTestMessageIndicator = true;
                    this.testMessageIndicator = buffer.getBoolean(valueOffset);
                    break;
                }
                case 553: {
                    this.hasUsername = true;
                    this.username = buffer.getChars(this.username, valueOffset, valueLength);
                    this.usernameOffset = valueOffset;
                    this.usernameLength = valueLength;
                    break;
                }
                case 554: {
                    this.hasPassword = true;
                    this.password = buffer.getChars(this.password, valueOffset, valueLength);
                    this.passwordOffset = valueOffset;
                    this.passwordLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag) && !this.messageFields.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
    }

    public void resetEncryptMethod() {
        this.encryptMethod = Integer.MIN_VALUE;
    }

    public void resetHeartBtInt() {
        this.heartBtInt = Integer.MIN_VALUE;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.hasUsername = false;
    }

    public void resetPassword() {
        this.hasPassword = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) + String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", this.usernameAsString()) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", this.passwordAsString()) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }
}

