/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.OrdType;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.InstrumentEncoder;
import uk.co.real_logic.artio.builder.OrderQtyDataEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class NewOrderSingleEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int clOrdIDHeaderLength = 3;
    private static final byte[] clOrdIDHeader = new byte[]{49, 49, 61};
    private static final int sideHeaderLength = 3;
    private static final byte[] sideHeader = new byte[]{53, 52, 61};
    private static final int transactTimeHeaderLength = 3;
    private static final byte[] transactTimeHeader = new byte[]{54, 48, 61};
    private static final int ordTypeHeaderLength = 3;
    private static final byte[] ordTypeHeader = new byte[]{52, 48, 61};
    private static final int priceHeaderLength = 3;
    private static final byte[] priceHeader = new byte[]{52, 52, 61};
    private final MutableDirectBuffer clOrdID = new UnsafeBuffer();
    private int clOrdIDOffset = 0;
    private int clOrdIDLength = 0;
    private final InstrumentEncoder instrument = new InstrumentEncoder();
    private char side;
    private boolean hasSide;
    private final MutableDirectBuffer transactTime = new UnsafeBuffer();
    private int transactTimeOffset = 0;
    private int transactTimeLength = 0;
    private final OrderQtyDataEncoder orderQtyData = new OrderQtyDataEncoder();
    private char ordType;
    private boolean hasOrdType;
    private final DecimalFloat price = new DecimalFloat();
    private boolean hasPrice;

    public int messageType() {
        return 68;
    }

    public NewOrderSingleEncoder() {
        this.header.msgType("D");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public NewOrderSingleEncoder clOrdID(DirectBuffer value, int offset, int length) {
        this.clOrdID.wrap(value);
        this.clOrdIDOffset = offset;
        this.clOrdIDLength = length;
        return this;
    }

    public NewOrderSingleEncoder clOrdID(DirectBuffer value, int length) {
        return this.clOrdID(value, 0, length);
    }

    public NewOrderSingleEncoder clOrdID(DirectBuffer value) {
        return this.clOrdID(value, 0, value.capacity());
    }

    public NewOrderSingleEncoder clOrdID(byte[] value, int offset, int length) {
        this.clOrdID.wrap(value);
        this.clOrdIDOffset = offset;
        this.clOrdIDLength = length;
        return this;
    }

    public NewOrderSingleEncoder clOrdID(byte[] value, int length) {
        return this.clOrdID(value, 0, length);
    }

    public NewOrderSingleEncoder clOrdID(byte[] value) {
        return this.clOrdID(value, 0, value.length);
    }

    public boolean hasClOrdID() {
        return this.clOrdIDLength > 0;
    }

    public MutableDirectBuffer clOrdID() {
        return this.clOrdID;
    }

    public NewOrderSingleEncoder clOrdID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.clOrdID);
        this.clOrdIDOffset = 0;
        this.clOrdIDLength = value.length();
        return this;
    }

    public NewOrderSingleEncoder clOrdID(char[] value) {
        return this.clOrdID(value, 0, value.length);
    }

    public NewOrderSingleEncoder clOrdID(char[] value, int length) {
        return this.clOrdID(value, 0, length);
    }

    public NewOrderSingleEncoder clOrdID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.clOrdID, (int)offset, (int)length);
        this.clOrdIDOffset = 0;
        this.clOrdIDLength = length;
        return this;
    }

    public InstrumentEncoder instrument() {
        return this.instrument;
    }

    public boolean hasSide() {
        return this.hasSide;
    }

    public NewOrderSingleEncoder side(char value) {
        this.side = value;
        this.hasSide = true;
        return this;
    }

    public char side() {
        return this.side;
    }

    public NewOrderSingleEncoder side(Side value) {
        return this.side(value.representation());
    }

    public NewOrderSingleEncoder transactTime(DirectBuffer value, int offset, int length) {
        this.transactTime.wrap(value);
        this.transactTimeOffset = offset;
        this.transactTimeLength = length;
        return this;
    }

    public NewOrderSingleEncoder transactTime(DirectBuffer value, int length) {
        return this.transactTime(value, 0, length);
    }

    public NewOrderSingleEncoder transactTime(DirectBuffer value) {
        return this.transactTime(value, 0, value.capacity());
    }

    public NewOrderSingleEncoder transactTime(byte[] value, int offset, int length) {
        this.transactTime.wrap(value);
        this.transactTimeOffset = offset;
        this.transactTimeLength = length;
        return this;
    }

    public NewOrderSingleEncoder transactTime(byte[] value, int length) {
        return this.transactTime(value, 0, length);
    }

    public NewOrderSingleEncoder transactTime(byte[] value) {
        return this.transactTime(value, 0, value.length);
    }

    public boolean hasTransactTime() {
        return this.transactTimeLength > 0;
    }

    public MutableDirectBuffer transactTime() {
        return this.transactTime;
    }

    public OrderQtyDataEncoder orderQtyData() {
        return this.orderQtyData;
    }

    public boolean hasOrdType() {
        return this.hasOrdType;
    }

    public NewOrderSingleEncoder ordType(char value) {
        this.ordType = value;
        this.hasOrdType = true;
        return this;
    }

    public char ordType() {
        return this.ordType;
    }

    public NewOrderSingleEncoder ordType(OrdType value) {
        return this.ordType(value.representation());
    }

    public boolean hasPrice() {
        return this.hasPrice;
    }

    public NewOrderSingleEncoder price(DecimalFloat value) {
        this.price.set(value);
        this.hasPrice = true;
        return this;
    }

    public NewOrderSingleEncoder price(long value, int scale) {
        this.price.set(value, scale);
        this.hasPrice = true;
        return this;
    }

    public DecimalFloat price() {
        return this.price;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.clOrdIDLength > 0) {
            buffer.putBytes(position, clOrdIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.clOrdID, this.clOrdIDOffset, this.clOrdIDLength);
            buffer.putSeparator(position += this.clOrdIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: ClOrdID");
        }
        position += this.instrument.encode(buffer, position);
        buffer.putBytes(position, sideHeader, 0, 3);
        position += 3;
        position += buffer.putCharAscii(position, this.side);
        buffer.putSeparator(position);
        ++position;
        if (this.transactTimeLength > 0) {
            buffer.putBytes(position, transactTimeHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.transactTime, this.transactTimeOffset, this.transactTimeLength);
            buffer.putSeparator(position += this.transactTimeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TransactTime");
        }
        position += this.orderQtyData.encode(buffer, position);
        buffer.putBytes(position, ordTypeHeader, 0, 3);
        position += 3;
        position += buffer.putCharAscii(position, this.ordType);
        buffer.putSeparator(position);
        ++position;
        if (this.hasPrice) {
            buffer.putBytes(position, priceHeader, 0, 3);
            position += 3;
            position += buffer.putFloatAscii(position, this.price);
            buffer.putSeparator(position);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetClOrdID();
        this.resetSide();
        this.resetTransactTime();
        this.resetOrdType();
        this.resetPrice();
        this.instrument.reset();
        this.orderQtyData.reset();
    }

    public void resetClOrdID() {
        this.clOrdIDLength = 0;
    }

    public void resetSide() {
        this.side = '\u0001';
    }

    public void resetTransactTime() {
        this.transactTimeLength = 0;
    }

    public void resetOrdType() {
        this.ordType = '\u0001';
    }

    public void resetPrice() {
        this.hasPrice = false;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasClOrdID() ? String.format("  \"ClOrdID\": \"%s\",\n", this.clOrdID.getStringWithoutLengthAscii(this.clOrdIDOffset, this.clOrdIDLength)) : "") + String.format("  \"Instrument\":  %s\n", this.instrument.toString().replace("\n", "\n  ")) + String.format("  \"Side\": \"%s\",\n", Character.valueOf(this.side)) + (this.hasTransactTime() ? String.format("  \"TransactTime\": \"%s\",\n", this.transactTime.getStringWithoutLengthAscii(this.transactTimeOffset, this.transactTimeLength)) : "") + String.format("  \"OrderQtyData\":  %s\n", this.orderQtyData.toString().replace("\n", "\n  ")) + String.format("  \"OrdType\": \"%s\",\n", Character.valueOf(this.ordType)) + (this.hasPrice() ? String.format("  \"Price\": \"%s\",\n", this.price) : "");
        entries = "{\n  \"MessageName\": \"NewOrderSingle\",\n" + entries + "}";
        return entries;
    }
}

