/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class TrailerEncoder {
    private static final int checkSumHeaderLength = 3;
    private static final byte[] checkSumHeader = new byte[]{49, 48, 61};
    private byte[] checkSum = new byte[1];
    private int checkSumOffset = 0;
    private int checkSumLength = 0;

    public TrailerEncoder checkSum(byte[] value, int length) {
        this.checkSum = value;
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value, int offset, int length) {
        this.checkSum = value;
        this.checkSumOffset = offset;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(byte[] value) {
        return this.checkSum(value, value.length);
    }

    public boolean hasCheckSum() {
        return this.checkSumLength > 0;
    }

    public byte[] checkSum() {
        return this.checkSum;
    }

    public TrailerEncoder checkSum(CharSequence value) {
        this.checkSum = CodecUtil.toBytes((CharSequence)value, (byte[])this.checkSum);
        this.checkSumOffset = 0;
        this.checkSumLength = value.length();
        return this;
    }

    public TrailerEncoder checkSum(char[] value) {
        return this.checkSum(value, value.length);
    }

    public TrailerEncoder checkSum(char[] value, int length) {
        this.checkSum = CodecUtil.toBytes((char[])value, (byte[])this.checkSum, (int)length);
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    public TrailerEncoder checkSum(char[] value, int offset, int length) {
        this.checkSum = CodecUtil.toBytes((char[])value, (byte[])this.checkSum, (int)offset, (int)length);
        this.checkSumOffset = 0;
        this.checkSumLength = length;
        return this;
    }

    long finishMessage(MutableAsciiBuffer buffer, int messageStart, int offset) {
        int position = offset;
        int checkSum = buffer.computeChecksum(messageStart, position);
        buffer.putBytes(position, checkSumHeader, 0, 3);
        buffer.putNaturalPaddedIntAscii(position += 3, 3, checkSum);
        buffer.putSeparator(position += 3);
        return Encoder.result((int)(++position - messageStart), (int)messageStart);
    }

    int startTrailer(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset;
        return position - start;
    }

    public void reset() {
    }

    public String toString() {
        String entries = this.hasCheckSum() ? String.format("  \"CheckSum\": \"%s\",\n", new String(this.checkSum, this.checkSumOffset, this.checkSumLength, StandardCharsets.US_ASCII)) : "";
        entries = "{\n  \"MessageName\": \"Trailer\",\n" + entries + "}";
        return entries;
    }
}

