/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogoutEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private byte[] text = new byte[1];
    private int textOffset = 0;
    private int textLength = 0;

    public int messageType() {
        return 53;
    }

    public LogoutEncoder() {
        this.header.msgType("5");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public LogoutEncoder text(byte[] value, int length) {
        this.text = value;
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(byte[] value, int offset, int length) {
        this.text = value;
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(byte[] value) {
        return this.text(value, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public byte[] text() {
        return this.text;
    }

    public LogoutEncoder text(CharSequence value) {
        this.text = CodecUtil.toBytes((CharSequence)value, (byte[])this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public LogoutEncoder text(char[] value) {
        return this.text(value, value.length);
    }

    public LogoutEncoder text(char[] value, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public LogoutEncoder text(char[] value, int offset, int length) {
        this.text = CodecUtil.toBytes((char[])value, (byte[])this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetText();
    }

    public void resetText() {
        this.textLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasText() ? String.format("  \"Text\": \"%s\",\n", new String(this.text, this.textOffset, this.textLength, StandardCharsets.US_ASCII)) : "");
        entries = "{\n  \"MessageName\": \"Logout\",\n" + entries + "}";
        return entries;
    }
}

