/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class LogonEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int encryptMethodHeaderLength = 3;
    private static final byte[] encryptMethodHeader = new byte[]{57, 56, 61};
    private static final int heartBtIntHeaderLength = 4;
    private static final byte[] heartBtIntHeader = new byte[]{49, 48, 56, 61};
    private static final int rawDataLengthHeaderLength = 3;
    private static final byte[] rawDataLengthHeader = new byte[]{57, 53, 61};
    private static final int rawDataHeaderLength = 3;
    private static final byte[] rawDataHeader = new byte[]{57, 54, 61};
    private static final int resetSeqNumFlagHeaderLength = 4;
    private static final byte[] resetSeqNumFlagHeader = new byte[]{49, 52, 49, 61};
    private static final int nextExpectedMsgSeqNumHeaderLength = 4;
    private static final byte[] nextExpectedMsgSeqNumHeader = new byte[]{55, 56, 57, 61};
    private static final int maxMessageSizeHeaderLength = 4;
    private static final byte[] maxMessageSizeHeader = new byte[]{51, 56, 51, 61};
    private static final int testMessageIndicatorHeaderLength = 4;
    private static final byte[] testMessageIndicatorHeader = new byte[]{52, 54, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private int encryptMethod;
    private boolean hasEncryptMethod;
    private int heartBtInt;
    private boolean hasHeartBtInt;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private byte[] rawData;
    private boolean hasRawData;
    private boolean resetSeqNumFlag;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private boolean testMessageIndicator;
    private boolean hasTestMessageIndicator;
    private byte[] username = new byte[1];
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private byte[] password = new byte[1];
    private int passwordOffset = 0;
    private int passwordLength = 0;
    public static int MAX_HEADER_PREFIX_LENGTH = 22;

    public int messageType() {
        return 65;
    }

    public LogonEncoder() {
        this.header.msgType("A");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasEncryptMethod() {
        return this.hasEncryptMethod;
    }

    public LogonEncoder encryptMethod(int value) {
        this.encryptMethod = value;
        this.hasEncryptMethod = true;
        return this;
    }

    public int encryptMethod() {
        return this.encryptMethod;
    }

    public LogonEncoder encryptMethod(EncryptMethod value) {
        return this.encryptMethod(value.representation());
    }

    public boolean hasHeartBtInt() {
        return this.hasHeartBtInt;
    }

    public LogonEncoder heartBtInt(int value) {
        this.heartBtInt = value;
        this.hasHeartBtInt = true;
        return this;
    }

    public int heartBtInt() {
        return this.heartBtInt;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public LogonEncoder rawDataLength(int value) {
        this.rawDataLength = value;
        this.hasRawDataLength = true;
        return this;
    }

    public int rawDataLength() {
        return this.rawDataLength;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public LogonEncoder rawData(byte[] value) {
        this.rawData = value;
        this.hasRawData = true;
        return this;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public LogonEncoder resetSeqNumFlag(boolean value) {
        this.resetSeqNumFlag = value;
        this.hasResetSeqNumFlag = true;
        return this;
    }

    public boolean resetSeqNumFlag() {
        return this.resetSeqNumFlag;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public LogonEncoder nextExpectedMsgSeqNum(int value) {
        this.nextExpectedMsgSeqNum = value;
        this.hasNextExpectedMsgSeqNum = true;
        return this;
    }

    public int nextExpectedMsgSeqNum() {
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public LogonEncoder maxMessageSize(int value) {
        this.maxMessageSize = value;
        this.hasMaxMessageSize = true;
        return this;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public LogonEncoder testMessageIndicator(boolean value) {
        this.testMessageIndicator = value;
        this.hasTestMessageIndicator = true;
        return this;
    }

    public boolean testMessageIndicator() {
        return this.testMessageIndicator;
    }

    public LogonEncoder username(byte[] value, int length) {
        this.username = value;
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value, int offset, int length) {
        this.username = value;
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(byte[] value) {
        return this.username(value, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public byte[] username() {
        return this.username;
    }

    public LogonEncoder username(CharSequence value) {
        this.username = CodecUtil.toBytes((CharSequence)value, (byte[])this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public LogonEncoder username(char[] value) {
        return this.username(value, value.length);
    }

    public LogonEncoder username(char[] value, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder username(char[] value, int offset, int length) {
        this.username = CodecUtil.toBytes((char[])value, (byte[])this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int length) {
        this.password = value;
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value, int offset, int length) {
        this.password = value;
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(byte[] value) {
        return this.password(value, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public byte[] password() {
        return this.password;
    }

    public LogonEncoder password(CharSequence value) {
        this.password = CodecUtil.toBytes((CharSequence)value, (byte[])this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public LogonEncoder password(char[] value) {
        return this.password(value, value.length);
    }

    public LogonEncoder password(char[] value, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public LogonEncoder password(char[] value, int offset, int length) {
        this.password = CodecUtil.toBytes((char[])value, (byte[])this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + MAX_HEADER_PREFIX_LENGTH;
        position += this.header.encode(buffer, position);
        if (this.hasEncryptMethod) {
            buffer.putBytes(position, encryptMethodHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.encryptMethod);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: EncryptMethod");
        }
        if (this.hasHeartBtInt) {
            buffer.putBytes(position, heartBtIntHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.heartBtInt);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: HeartBtInt");
        }
        if (this.hasRawDataLength) {
            buffer.putBytes(position, rawDataLengthHeader, 0, 3);
            position += 3;
            position += buffer.putAsciiInt(position, this.rawDataLength);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasRawData) {
            buffer.putBytes(position, rawDataHeader, 0, 3);
            buffer.putBytes(position += 3, this.rawData);
            buffer.putSeparator(position += this.rawData.length);
            ++position;
        }
        if (this.hasResetSeqNumFlag) {
            buffer.putBytes(position, resetSeqNumFlagHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiBoolean(position, this.resetSeqNumFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasNextExpectedMsgSeqNum) {
            buffer.putBytes(position, nextExpectedMsgSeqNumHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.nextExpectedMsgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasMaxMessageSize) {
            buffer.putBytes(position, maxMessageSizeHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiInt(position, this.maxMessageSize);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasTestMessageIndicator) {
            buffer.putBytes(position, testMessageIndicatorHeader, 0, 4);
            position += 4;
            position += buffer.putAsciiBoolean(position, this.testMessageIndicator);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        position += this.trailer.encode(buffer, position, start);
        int realStart = this.trailer.realStart;
        return Encoder.result((int)(position - realStart), (int)realStart);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
    }

    public void resetEncryptMethod() {
        this.hasEncryptMethod = false;
    }

    public void resetHeartBtInt() {
        this.hasHeartBtInt = false;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasEncryptMethod() ? String.format("  \"EncryptMethod\": \"%s\",\n", this.encryptMethod) : "") + (this.hasHeartBtInt() ? String.format("  \"HeartBtInt\": \"%s\",\n", this.heartBtInt) : "") + (this.hasRawDataLength() ? String.format("  \"RawDataLength\": \"%s\",\n", this.rawDataLength) : "") + (this.hasRawData() ? String.format("  \"RawData\": \"%s\",\n", Arrays.toString(this.rawData)) : "") + (this.hasResetSeqNumFlag() ? String.format("  \"ResetSeqNumFlag\": \"%s\",\n", this.resetSeqNumFlag) : "") + (this.hasNextExpectedMsgSeqNum() ? String.format("  \"NextExpectedMsgSeqNum\": \"%s\",\n", this.nextExpectedMsgSeqNum) : "") + (this.hasMaxMessageSize() ? String.format("  \"MaxMessageSize\": \"%s\",\n", this.maxMessageSize) : "") + (this.hasTestMessageIndicator() ? String.format("  \"TestMessageIndicator\": \"%s\",\n", this.testMessageIndicator) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", new String(this.username, this.usernameOffset, this.usernameLength, StandardCharsets.US_ASCII)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", new String(this.password, this.passwordOffset, this.passwordLength, StandardCharsets.US_ASCII)) : "");
        entries = "{\n  \"MessageName\": \"Logon\",\n" + entries + "}";
        return entries;
    }
}

