/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractBusinessMessageRejectEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class BusinessMessageRejectEncoder
implements AbstractBusinessMessageRejectEncoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int refSeqNumHeaderLength = 3;
    private static final byte[] refSeqNumHeader = new byte[]{52, 53, 61};
    private static final int refMsgTypeHeaderLength = 4;
    private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
    private static final int businessRejectRefIDHeaderLength = 4;
    private static final byte[] businessRejectRefIDHeader = new byte[]{51, 55, 57, 61};
    private static final int businessRejectReasonHeaderLength = 4;
    private static final byte[] businessRejectReasonHeader = new byte[]{51, 56, 48, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private int refSeqNum;
    private boolean hasRefSeqNum;
    private final MutableDirectBuffer refMsgType = new UnsafeBuffer();
    private int refMsgTypeOffset = 0;
    private int refMsgTypeLength = 0;
    private final MutableDirectBuffer businessRejectRefID = new UnsafeBuffer();
    private int businessRejectRefIDOffset = 0;
    private int businessRejectRefIDLength = 0;
    private int businessRejectReason;
    private boolean hasBusinessRejectReason;
    private final MutableDirectBuffer text = new UnsafeBuffer();
    private int textOffset = 0;
    private int textLength = 0;

    public long messageType() {
        return 106L;
    }

    public BusinessMessageRejectEncoder() {
        this.header.msgType("j");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasRefSeqNum() {
        return this.hasRefSeqNum;
    }

    public BusinessMessageRejectEncoder refSeqNum(int value) {
        this.refSeqNum = value;
        this.hasRefSeqNum = true;
        return this;
    }

    public int refSeqNum() {
        return this.refSeqNum;
    }

    public BusinessMessageRejectEncoder refMsgType(DirectBuffer value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder refMsgType(DirectBuffer value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public BusinessMessageRejectEncoder refMsgType(DirectBuffer value) {
        return this.refMsgType(value, 0, value.capacity());
    }

    public BusinessMessageRejectEncoder refMsgType(byte[] value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder refMsgTypeAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.refMsgType, (byte[])value, (int)offset, (int)length);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder refMsgType(byte[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public BusinessMessageRejectEncoder refMsgType(byte[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public boolean hasRefMsgType() {
        return this.refMsgTypeLength > 0;
    }

    public MutableDirectBuffer refMsgType() {
        return this.refMsgType;
    }

    public String refMsgTypeAsString() {
        return this.refMsgType.getStringWithoutLengthAscii(this.refMsgTypeOffset, this.refMsgTypeLength);
    }

    public BusinessMessageRejectEncoder refMsgType(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.refMsgType);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = value.length();
        return this;
    }

    public BusinessMessageRejectEncoder refMsgType(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.refMsgType.wrap(buffer);
            this.refMsgTypeOffset = value.offset();
            this.refMsgTypeLength = value.length();
        }
        return this;
    }

    public BusinessMessageRejectEncoder refMsgType(char[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public BusinessMessageRejectEncoder refMsgType(char[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public BusinessMessageRejectEncoder refMsgType(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.refMsgType, (int)offset, (int)length);
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefID(DirectBuffer value, int offset, int length) {
        this.businessRejectRefID.wrap(value);
        this.businessRejectRefIDOffset = offset;
        this.businessRejectRefIDLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefID(DirectBuffer value, int length) {
        return this.businessRejectRefID(value, 0, length);
    }

    public BusinessMessageRejectEncoder businessRejectRefID(DirectBuffer value) {
        return this.businessRejectRefID(value, 0, value.capacity());
    }

    public BusinessMessageRejectEncoder businessRejectRefID(byte[] value, int offset, int length) {
        this.businessRejectRefID.wrap(value);
        this.businessRejectRefIDOffset = offset;
        this.businessRejectRefIDLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefIDAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.businessRejectRefID, (byte[])value, (int)offset, (int)length);
        this.businessRejectRefIDOffset = offset;
        this.businessRejectRefIDLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefID(byte[] value, int length) {
        return this.businessRejectRefID(value, 0, length);
    }

    public BusinessMessageRejectEncoder businessRejectRefID(byte[] value) {
        return this.businessRejectRefID(value, 0, value.length);
    }

    public boolean hasBusinessRejectRefID() {
        return this.businessRejectRefIDLength > 0;
    }

    public MutableDirectBuffer businessRejectRefID() {
        return this.businessRejectRefID;
    }

    public String businessRejectRefIDAsString() {
        return this.businessRejectRefID.getStringWithoutLengthAscii(this.businessRejectRefIDOffset, this.businessRejectRefIDLength);
    }

    public BusinessMessageRejectEncoder businessRejectRefID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.businessRejectRefID);
        this.businessRejectRefIDOffset = 0;
        this.businessRejectRefIDLength = value.length();
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.businessRejectRefID.wrap(buffer);
            this.businessRejectRefIDOffset = value.offset();
            this.businessRejectRefIDLength = value.length();
        }
        return this;
    }

    public BusinessMessageRejectEncoder businessRejectRefID(char[] value) {
        return this.businessRejectRefID(value, 0, value.length);
    }

    public BusinessMessageRejectEncoder businessRejectRefID(char[] value, int length) {
        return this.businessRejectRefID(value, 0, length);
    }

    public BusinessMessageRejectEncoder businessRejectRefID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.businessRejectRefID, (int)offset, (int)length);
        this.businessRejectRefIDOffset = 0;
        this.businessRejectRefIDLength = length;
        return this;
    }

    public boolean hasBusinessRejectReason() {
        return this.hasBusinessRejectReason;
    }

    public BusinessMessageRejectEncoder businessRejectReason(int value) {
        this.businessRejectReason = value;
        this.hasBusinessRejectReason = true;
        return this;
    }

    public int businessRejectReason() {
        return this.businessRejectReason;
    }

    public BusinessMessageRejectEncoder text(DirectBuffer value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder text(DirectBuffer value, int length) {
        return this.text(value, 0, length);
    }

    public BusinessMessageRejectEncoder text(DirectBuffer value) {
        return this.text(value, 0, value.capacity());
    }

    public BusinessMessageRejectEncoder text(byte[] value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder textAsCopy(byte[] value, int offset, int length) {
        CodecUtil.copyInto((MutableDirectBuffer)this.text, (byte[])value, (int)offset, (int)length);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public BusinessMessageRejectEncoder text(byte[] value, int length) {
        return this.text(value, 0, length);
    }

    public BusinessMessageRejectEncoder text(byte[] value) {
        return this.text(value, 0, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public MutableDirectBuffer text() {
        return this.text;
    }

    public String textAsString() {
        return this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength);
    }

    public BusinessMessageRejectEncoder text(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.text);
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public BusinessMessageRejectEncoder text(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.text.wrap(buffer);
            this.textOffset = value.offset();
            this.textLength = value.length();
        }
        return this;
    }

    public BusinessMessageRejectEncoder text(char[] value) {
        return this.text(value, 0, value.length);
    }

    public BusinessMessageRejectEncoder text(char[] value, int length) {
        return this.text(value, 0, length);
    }

    public BusinessMessageRejectEncoder text(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.text, (int)offset, (int)length);
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasRefSeqNum) {
            buffer.putBytes(position, refSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.refSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refMsgTypeLength > 0) {
            buffer.putBytes(position, refMsgTypeHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
            buffer.putSeparator(position += this.refMsgTypeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: RefMsgType");
        }
        if (this.businessRejectRefIDLength > 0) {
            buffer.putBytes(position, businessRejectRefIDHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.businessRejectRefID, this.businessRejectRefIDOffset, this.businessRejectRefIDLength);
            buffer.putSeparator(position += this.businessRejectRefIDLength);
            ++position;
        }
        if (this.hasBusinessRejectReason) {
            buffer.putBytes(position, businessRejectReasonHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.businessRejectReason);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: BusinessRejectReason");
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetRefSeqNum();
        this.resetRefMsgType();
        this.resetBusinessRejectRefID();
        this.resetBusinessRejectReason();
        this.resetText();
    }

    public void resetRefSeqNum() {
        this.hasRefSeqNum = false;
    }

    public void resetRefMsgType() {
        this.refMsgTypeLength = 0;
    }

    public void resetBusinessRejectRefID() {
        this.businessRejectRefIDLength = 0;
    }

    public void resetBusinessRejectReason() {
        this.hasBusinessRejectReason = false;
    }

    public void resetText() {
        this.textLength = 0;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"BusinessMessageReject\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasRefSeqNum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RefSeqNum\": \"");
            builder.append(this.refSeqNum);
            builder.append("\",\n");
        }
        if (this.hasRefMsgType()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RefMsgType\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.refMsgType, (int)this.refMsgTypeOffset, (int)this.refMsgTypeLength);
            builder.append("\",\n");
        }
        if (this.hasBusinessRejectRefID()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"BusinessRejectRefID\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.businessRejectRefID, (int)this.businessRejectRefIDOffset, (int)this.businessRejectRefIDLength);
            builder.append("\",\n");
        }
        if (this.hasBusinessRejectReason()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"BusinessRejectReason\": \"");
            builder.append(this.businessRejectReason);
            builder.append("\",\n");
        }
        if (this.hasText()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Text\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.text, (int)this.textOffset, (int)this.textLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public BusinessMessageRejectEncoder copyTo(Encoder encoder) {
        return this.copyTo((BusinessMessageRejectEncoder)encoder);
    }

    public BusinessMessageRejectEncoder copyTo(BusinessMessageRejectEncoder encoder) {
        encoder.reset();
        if (this.hasRefSeqNum()) {
            encoder.refSeqNum(this.refSeqNum());
        }
        if (this.hasRefMsgType()) {
            encoder.refMsgTypeAsCopy(this.refMsgType.byteArray(), 0, this.refMsgTypeLength);
        }
        if (this.hasBusinessRejectRefID()) {
            encoder.businessRejectRefIDAsCopy(this.businessRejectRefID.byteArray(), 0, this.businessRejectRefIDLength);
        }
        if (this.hasBusinessRejectReason()) {
            encoder.businessRejectReason(this.businessRejectReason());
        }
        if (this.hasText()) {
            encoder.textAsCopy(this.text.byteArray(), 0, this.textLength);
        }
        return encoder;
    }
}

