/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_buyer;

import java.util.Collections;
import org.agrona.CloseHelper;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.example_buyer.Buyer;
import uk.co.real_logic.artio.example_exchange.ExchangeApplication;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.library.SessionAcquireHandler;

public class BuyerAgent
implements Agent {
    private FixEngine gateway;
    private FixLibrary library;
    private final Buyer buyer = new Buyer();

    public void onStart() {
        EngineConfiguration engineConfiguration = new EngineConfiguration().libraryAeronChannel("aeron:ipc");
        engineConfiguration.aeronContext().aeronDirectoryName("buyer");
        engineConfiguration.aeronArchiveContext().recordingEventsChannel("aeron:udp?endpoint=localhost:9030").aeronDirectoryName("buyer");
        ExchangeApplication.cleanupOldLogFileDir(engineConfiguration);
        this.gateway = FixEngine.launch((EngineConfiguration)engineConfiguration);
        LibraryConfiguration libraryConfiguration = new LibraryConfiguration().libraryAeronChannels(Collections.singletonList("aeron:ipc")).libraryConnectHandler((LibraryConnectHandler)this.buyer).sessionAcquireHandler((SessionAcquireHandler)this.buyer);
        libraryConfiguration.aeronContext().aeronDirectoryName("buyer");
        this.library = FixLibrary.connect((LibraryConfiguration)libraryConfiguration);
    }

    public int doWork() {
        int actions = this.library.poll(10);
        return actions + this.buyer.poll();
    }

    public void onClose() {
        CloseHelper.close((AutoCloseable)this.gateway);
    }

    public String roleName() {
        return "Buyer";
    }
}

