/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_exchange;

import java.util.Collections;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.example_exchange.ExchangeSessionHandler;
import uk.co.real_logic.artio.example_exchange.LoggingLibraryConnectHandler;
import uk.co.real_logic.artio.library.AcquiringSessionExistsHandler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public class ExchangeAgent
implements Agent {
    private static final int FRAGMENT_LIMIT = 10;
    private FixLibrary library;

    public void onStart() {
        MessageValidationStrategy validationStrategy = MessageValidationStrategy.targetCompId((String)"exexchange").and(MessageValidationStrategy.senderCompId(Collections.singletonList("extrader")));
        LibraryConfiguration configuration = new LibraryConfiguration();
        configuration.libraryConnectHandler((LibraryConnectHandler)new LoggingLibraryConnectHandler()).sessionAcquireHandler(this::onAcquire).sessionExistsHandler((SessionExistsHandler)new AcquiringSessionExistsHandler(true)).libraryAeronChannels(Collections.singletonList("aeron:ipc"));
        this.library = FixLibrary.connect((LibraryConfiguration)configuration);
        System.out.println("Connecting library");
    }

    private SessionHandler onAcquire(Session session, boolean isSlow) {
        System.out.println(session.compositeKey() + " logged in");
        return new ExchangeSessionHandler(session);
    }

    public int doWork() {
        return this.library.poll(10);
    }

    public String roleName() {
        return "Exchange";
    }
}

