/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.reproduction;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.IoUtil;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SigInt;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.AcquiringSessionExistsHandler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.reproduction.SampleSessionHandler;
import uk.co.real_logic.artio.session.Session;

public final class SampleServer {
    public static final String ACCEPTOR_COMP_ID = "acceptor";
    public static final String INITIATOR_COMP_ID = "initiator";
    private static Session session;

    public static void main(String[] args) throws Exception {
        String aeronName = "./logs/aeron";
        EngineConfiguration configuration = new EngineConfiguration().bindTo(System.getProperty("socketHost", "localhost"), Integer.parseInt(System.getProperty("socketPort", "9999"))).libraryAeronChannel("aeron:ipc").logFileDir("./logs/");
        configuration.aeronContext().aeronDirectoryName("./logs/aeron");
        configuration.framerIdleStrategy((IdleStrategy)new BusySpinIdleStrategy());
        SampleServer.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.DEDICATED).dirDeleteOnStart(true).aeronDirectoryName("./logs/aeron");
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.DEDICATED).deleteArchiveOnStart(true).aeronDirectoryName("./logs/aeron").archiveDirectoryName("./logs/aeron-archive");
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);
             FixEngine gateway = FixEngine.launch((EngineConfiguration)configuration);){
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
            libraryConfiguration.sessionAcquireHandler(SampleServer::onConnect).sessionExistsHandler((SessionExistsHandler)new AcquiringSessionExistsHandler()).libraryAeronChannels(Collections.singletonList("aeron:ipc"));
            libraryConfiguration.aeronContext().aeronDirectoryName("./logs/aeron");
            try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                AtomicBoolean running = new AtomicBoolean(true);
                SigInt.register(() -> running.set(false));
                System.out.println("start to polling messsages");
                while (running.get()) {
                    library.poll(1);
                }
            }
        }
        System.exit(0);
    }

    public static void cleanupOldLogFileDir(EngineConfiguration configuration) {
        IoUtil.delete((File)new File(configuration.logFileDir()), (boolean)true);
    }

    private static SessionHandler onConnect(Session session, boolean isSlow) {
        System.out.println("session acquired");
        SampleServer.session = session;
        return new SampleSessionHandler(session);
    }
}

