/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import java.util.List;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;

public class LibraryAndSessionDumper {
    private final IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
    private final FixEngine engine;

    public LibraryAndSessionDumper(FixEngine engine) {
        this.engine = engine;
    }

    public void printLibraries() {
        Reply reply = this.engine.libraries();
        while (reply.isExecuting()) {
            this.idleStrategy.idle();
        }
        this.idleStrategy.reset();
        for (LibraryInfo library : (List)reply.resultIfPresent()) {
            System.out.println("--------------------------------");
            System.out.printf("Library %d%n", library.libraryId());
            System.out.println("--------------------------------%n");
            System.out.println("| Id   | Remote Address %n");
            for (SessionInfo session : library.sessions()) {
                System.out.printf("| %4d | %s", session.connectionId(), session.address());
            }
            System.out.println("--------------------------------%n");
        }
    }
}

