/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.client.TestReqIdFinder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.stress.Server;
import uk.co.real_logic.artio.stress.StressConfiguration;
import uk.co.real_logic.artio.stress.StressUtil;

public final class ConcurrentConnections {
    public static void main(String[] args) throws Exception {
        SystemUtil.loadPropertiesFiles((String[])args);
        AgentRunner server = Server.createServer((IdleStrategy)new SleepingIdleStrategy(100L), Throwable::printStackTrace);
        AgentRunner.startOnThread((AgentRunner)server);
        String aeronChannel = "aeron:udp?endpoint=localhost:10002";
        EngineConfiguration engineConfiguration = new EngineConfiguration().libraryAeronChannel("aeron:udp?endpoint=localhost:10002").logFileDir("stress-client-logs");
        engineConfiguration.authenticationStrategy(logon -> true);
        System.out.println("Client Logs at " + engineConfiguration.logFileDir());
        StressUtil.cleanupOldLogFileDir(engineConfiguration);
        Random random = new Random(StressConfiguration.SEED);
        long startTime = System.currentTimeMillis();
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)engineConfiguration);){
            CyclicBarrier barrier = new CyclicBarrier(StressConfiguration.NUM_SESSIONS);
            Thread[] threads = new Thread[StressConfiguration.NUM_SESSIONS];
            for (int i = 0; i < StressConfiguration.NUM_SESSIONS; ++i) {
                System.out.format("Starting session %d / %d%n", i + 1, StressConfiguration.NUM_SESSIONS);
                int id = i;
                threads[i] = new Thread(() -> ConcurrentConnections.runThread("aeron:udp?endpoint=localhost:10002", random, barrier, id));
                threads[i].start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
        server.close();
        System.out.format("Sessions %d. Messages %d per session.%n", StressConfiguration.NUM_SESSIONS, StressConfiguration.MESSAGES_EXCHANGED);
        System.out.format("Stress test executed in %dms%n", System.currentTimeMillis() - startTime);
        System.exit(0);
    }

    private static void runThread(String aeronChannel, Random random, CyclicBarrier barrier, int id) {
        String targetCompId = "ACC-" + id;
        String senderCompId = "INIT-" + id;
        String[] messagePool = StressUtil.constructMessagePool(String.valueOf(id), random);
        TestReqIdFinder testReqIdFinder = new TestReqIdFinder();
        SessionConfiguration sessionConfiguration = SessionConfiguration.builder().address("localhost", StressConfiguration.PORT).targetCompId(targetCompId).senderCompId(senderCompId).build();
        LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
        libraryConfiguration.authenticationStrategy(logon -> true);
        libraryConfiguration.sessionAcquireHandler((session, isSlow) -> testReqIdFinder).libraryAeronChannels(Collections.singletonList(aeronChannel));
        try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
            barrier.await();
            SleepingIdleStrategy idleStrategy = new SleepingIdleStrategy(100L);
            Reply reply = library.initiate(sessionConfiguration);
            while (reply.isExecuting()) {
                idleStrategy.idle(library.poll(1));
            }
            if (!reply.hasCompleted()) {
                System.err.println("Unable to initiate the session, " + reply.state());
                reply.error().printStackTrace();
                System.exit(-1);
            }
            Session session2 = (Session)reply.resultIfPresent();
            if (StressConfiguration.PRINT_EXCHANGE) {
                System.out.println(session2.id() + " Replied with: " + reply.state());
            }
            while (!session2.canSendMessage()) {
                idleStrategy.idle(library.poll(1));
            }
            StressUtil.exchangeMessages(library, session2, (IdleStrategy)idleStrategy, testReqIdFinder, messagePool, random, senderCompId);
            session2.startLogout();
            session2.requestDisconnect();
            while (session2.state() != SessionState.DISCONNECTED) {
                idleStrategy.idle(library.poll(1));
            }
            if (StressConfiguration.PRINT_EXCHANGE) {
                System.out.println(session2.id() + " Disconnected");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

