/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_buyer;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.example_buyer.BuyerAgent;

public final class BuyerApplication {
    public static final String AERON_DIRECTORY_NAME = "buyer";
    public static final String AERON_ARCHIVE_DIRECTORY_NAME = "buyer-archive";
    public static final String RECORDING_EVENTS_CHANNEL = "aeron:udp?endpoint=localhost:9030";

    public static void main(String[] args) throws InterruptedException {
        System.setProperty("aeron.archive.control.channel", "aeron:udp?endpoint=localhost:9010");
        System.setProperty("aeron.archive.control.response.channel", "aeron:udp?endpoint=localhost:9020");
        System.setProperty("aeron.archive.replication.channel", "aeron:udp?endpoint=localhost:0");
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirDeleteOnStart(true).aeronDirectoryName(AERON_DIRECTORY_NAME);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).deleteArchiveOnStart(true).aeronDirectoryName(AERON_DIRECTORY_NAME).recordingEventsChannel(RECORDING_EVENTS_CHANNEL).archiveDirectoryName(AERON_ARCHIVE_DIRECTORY_NAME);
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);){
            SampleUtil.runAgentUntilSignal(new BuyerAgent(), driver.mediaDriver());
        }
    }
}

