/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.stress.StressConfiguration;
import uk.co.real_logic.artio.stress.StressUtil;

public final class SoleEngine {
    static final String AERON_CHANNEL = "aeron:udp?endpoint=localhost:10000";

    public static void main(String[] args) {
        System.setProperty("aeron.archive.control.channel", "aeron:udp?endpoint=localhost:8010");
        System.setProperty("aeron.archive.control.response.channel", "aeron:udp?endpoint=localhost:8020");
        EngineConfiguration configuration = new EngineConfiguration().bindTo("localhost", StressConfiguration.PORT).logFileDir("stress-server-logs").libraryAeronChannel(AERON_CHANNEL).errorIfDuplicateEngineDetected(false);
        configuration.slowConsumerTimeoutInMs(1000L);
        configuration.replyTimeoutInMs(1000L);
        System.out.println("Server Logs at " + configuration.logFileDir());
        StressUtil.cleanupOldLogFileDir(configuration);
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)configuration);){
            StressUtil.awaitKeyPress();
        }
    }
}

