/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_fixp_exchange;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.agrona.collections.CollectionUtil;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointConnection;
import uk.co.real_logic.artio.example_exchange.LoggingLibraryConnectHandler;
import uk.co.real_logic.artio.example_fixp_exchange.FixPExchangeSessionHandler;
import uk.co.real_logic.artio.fixp.FixPConnectionHandler;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.FixPConnectionExistsHandler;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.SessionReplyStatus;

public class FixPExchangeAgent
implements Agent {
    private static final int FRAGMENT_LIMIT = 10;
    private final AcquiringFixPExistsHandler existsHandler = new AcquiringFixPExistsHandler();
    private FixLibrary library;

    public void onStart() {
        LibraryConfiguration configuration = new LibraryConfiguration();
        configuration.libraryConnectHandler((LibraryConnectHandler)new LoggingLibraryConnectHandler()).fixPConnectionAcquiredHandler(connection -> this.onAcquire((BinaryEntryPointConnection)connection)).fixPConnectionExistsHandler((FixPConnectionExistsHandler)this.existsHandler).libraryAeronChannels(Collections.singletonList("aeron:ipc"));
        this.library = FixLibrary.connect((LibraryConfiguration)configuration);
        System.out.println("Connecting library");
    }

    private FixPConnectionHandler onAcquire(BinaryEntryPointConnection connection) {
        System.out.println(connection.key() + " logged in with sessionId=" + connection.sessionId());
        return new FixPExchangeSessionHandler(connection);
    }

    public int doWork() {
        return this.library.poll(10) + this.existsHandler.poll();
    }

    public String roleName() {
        return "Exchange";
    }

    static class AcquiringFixPExistsHandler
    implements FixPConnectionExistsHandler {
        private final List<Reply<SessionReplyStatus>> replies = new ArrayList<Reply<SessionReplyStatus>>();

        AcquiringFixPExistsHandler() {
        }

        public ControlledFragmentHandler.Action onConnectionExists(FixLibrary library, long surrogateSessionId, FixPProtocolType protocol, FixPContext context) {
            System.out.println("context = " + context + ", protocol = " + protocol + " connected");
            Reply reply = library.requestSession(surrogateSessionId, -1, -1, 5000L);
            this.replies.add((Reply<SessionReplyStatus>)reply);
            return ControlledFragmentHandler.Action.CONTINUE;
        }

        int poll() {
            List<Reply<SessionReplyStatus>> replies = this.replies;
            return CollectionUtil.removeIf(replies, reply -> {
                if (reply.isExecuting()) {
                    return false;
                }
                if (reply.hasErrored()) {
                    reply.error().printStackTrace();
                } else if (reply.hasTimedOut()) {
                    System.err.println(reply + " has timed out");
                }
                return true;
            });
        }
    }
}

