/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.Session;

public class SessionScheduler {
    static ScheduledExecutorService timeEventPool = Executors.newScheduledThreadPool(1);
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final FixLibrary library;
    private final SessionConfiguration sessionConfiguration;
    private final Set<DayOfWeek> daysOfWeek;
    private final LocalTime startTime;
    private final LocalTime endTime;
    private volatile boolean duringDay;
    private State state = State.DISCONNECTED;
    private Reply<Session> reply;
    private Session session;

    public static SessionScheduler nonStopSession(FixLibrary library, SessionConfiguration sessionConfiguration, String timezoneName, String startDayName, String endDayName, ErrorHandler errorHandler) {
        return new SessionScheduler(Clock.systemDefaultZone(), library, sessionConfiguration, ZoneId.of(timezoneName), DayOfWeek.valueOf(startDayName), DayOfWeek.valueOf(endDayName), LocalTime.of(0, 0), LocalTime.of(0, 0), errorHandler);
    }

    public static SessionScheduler fromRawConfig(FixLibrary library, SessionConfiguration sessionConfiguration, String timezoneName, String startDayName, String endDayName, String startTimeConfiguration, String endTimeConfiguration, ErrorHandler errorHandler) {
        return new SessionScheduler(Clock.systemDefaultZone(), library, sessionConfiguration, ZoneId.of(timezoneName), DayOfWeek.valueOf(startDayName), DayOfWeek.valueOf(endDayName), LocalTime.parse(startTimeConfiguration), LocalTime.parse(endTimeConfiguration), errorHandler);
    }

    public SessionScheduler(Clock clock, FixLibrary library, SessionConfiguration sessionConfiguration, ZoneId timezone, DayOfWeek startDay, DayOfWeek endDay, LocalTime startTime, LocalTime endTime, ErrorHandler errorHandler) {
        this.clock = clock.withZone(timezone);
        this.library = library;
        this.sessionConfiguration = sessionConfiguration;
        this.startTime = startTime;
        this.endTime = endTime;
        this.errorHandler = errorHandler;
        this.daysOfWeek = Arrays.stream(DayOfWeek.values()).filter(dayOfWeek -> dayOfWeek.compareTo(startDay) >= 0 && dayOfWeek.compareTo(endDay) <= 0).collect(Collectors.toSet());
        this.scheduleStart();
    }

    public boolean duringDay() {
        return this.duringDay;
    }

    public int doWork() {
        switch (this.state) {
            case DISCONNECTED: {
                if (this.duringDay) {
                    this.reply = this.library.initiate(this.sessionConfiguration);
                    this.state = State.CONNECTING;
                    return 1;
                }
                return 0;
            }
            case CONNECTING: {
                switch (this.reply.state()) {
                    case COMPLETED: {
                        this.session = (Session)this.reply.resultIfPresent();
                        this.state = State.CONNECTED;
                        this.scheduleEnd();
                        return 1;
                    }
                    case ERRORED: {
                        this.errorHandler.onError(this.reply.error());
                        this.reply = null;
                        this.state = State.DISCONNECTED;
                        return 1;
                    }
                    case TIMED_OUT: {
                        this.errorHandler.onError((Throwable)new TimeoutException("Timeout connected to Session"));
                        this.reply = null;
                        this.state = State.DISCONNECTED;
                        return 1;
                    }
                }
                return 0;
            }
            case CONNECTED: {
                if (!this.duringDay) {
                    long position = this.session.logoutAndDisconnect();
                    if (position > 0L) {
                        this.state = State.DISCONNECTING;
                    }
                    return 1;
                }
                if (!this.session.isConnected()) {
                    this.session = null;
                    this.state = State.DISCONNECTED;
                    return 1;
                }
                return 0;
            }
            case DISCONNECTING: {
                if (this.session.state() == SessionState.DISCONNECTED) {
                    this.session = null;
                    this.state = State.DISCONNECTED;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private void scheduleStart() {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        if (this.daysOfWeek.contains(now.getDayOfWeek())) {
            LocalTime currentTime = now.toLocalTime();
            long startGapMs = Duration.between(currentTime, this.startTime).toMillis();
            if (startGapMs <= 0L) {
                long endGapMs = Duration.between(currentTime, this.endTime).toMillis();
                if (endGapMs > 0L) {
                    this.onDayStart();
                }
            } else {
                this.scheduleEvent(startGapMs, this::onDayStart);
            }
        }
    }

    private void scheduleEnd() {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        if (this.daysOfWeek.contains(now.getDayOfWeek())) {
            LocalTime currentTime = now.toLocalTime();
            long endGapMs = Duration.between(currentTime, this.endTime).toMillis();
            if (endGapMs <= 0L) {
                this.onDayEnd();
            } else {
                this.scheduleEvent(endGapMs, this::onDayEnd);
            }
        }
    }

    private void scheduleEvent(long gapMs, Runnable command) {
        timeEventPool.schedule(command, gapMs, TimeUnit.MILLISECONDS);
    }

    void onDayStart() {
        this.duringDay = true;
    }

    void onDayEnd() {
        this.duringDay = false;
    }

    private static enum State {
        DISCONNECTED,
        CONNECTED,
        CONNECTING,
        DISCONNECTING;

    }
}

