/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import uk.co.real_logic.artio.engine.logger.ReplayIndexExtractor;

public final class ReplayIndexDumper {
    public static void main(String[] args) throws IOException {
        File headerFile = new File(args[0]);
        long fixSessionId = Long.parseLong(args[1]);
        int streamId = Integer.parseInt(args[2]);
        String logFileDir = headerFile.getParent();
        Consumer<ReplayIndexExtractor.ReplayIndexHandler> extract = handler -> ReplayIndexExtractor.extract((File)headerFile, (int)262144, (int)65536, (long)fixSessionId, (int)streamId, (String)logFileDir, (ReplayIndexExtractor.ReplayIndexHandler)handler);
        ReplayIndexExtractor.StartPositionExtractor positionExtractor = new ReplayIndexExtractor.StartPositionExtractor();
        extract.accept((ReplayIndexExtractor.ReplayIndexHandler)positionExtractor);
        System.out.println("positionExtractor.highestSequenceIndex() = " + positionExtractor.highestSequenceIndex());
        System.out.println("positionExtractor.recordingIdToStartPosition() = " + positionExtractor.recordingIdToStartPosition());
        String output = "replay-index-dump.csv";
        try (BufferedWriter out = new BufferedWriter(new FileWriter("replay-index-dump.csv"));){
            extract.accept((ReplayIndexExtractor.ReplayIndexHandler)new ReplayIndexExtractor.PrintError(out));
        }
        ReplayIndexExtractor.ReplayIndexValidator validator = new ReplayIndexExtractor.ReplayIndexValidator();
        extract.accept((ReplayIndexExtractor.ReplayIndexHandler)validator);
        List errors = validator.errors();
        errors.forEach(System.err::println);
    }
}

