/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import java.util.Collections;
import java.util.Random;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.client.TestReqIdFinder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.stress.Server;
import uk.co.real_logic.artio.stress.StressConfiguration;
import uk.co.real_logic.artio.stress.StressUtil;

public final class SerialConnections {
    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        AgentRunner server = Server.createServer((IdleStrategy)new SleepingIdleStrategy(100L), Throwable::printStackTrace);
        AgentRunner.startOnThread((AgentRunner)server);
        String aeronChannel = "aeron:udp?endpoint=localhost:10002";
        EngineConfiguration engineConfiguration = new EngineConfiguration().libraryAeronChannel("aeron:udp?endpoint=localhost:10002").logFileDir("stress-client-logs").bindTo("localhost", 10001);
        System.out.println("Client Logs at " + engineConfiguration.logFileDir());
        StressUtil.cleanupOldLogFileDir(engineConfiguration);
        Random random = new Random(StressConfiguration.SEED);
        String[] messagePool = StressUtil.constructMessagePool("", random);
        long startTime = System.currentTimeMillis();
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)engineConfiguration);){
            for (int i = 0; i < StressConfiguration.NUM_SESSIONS; ++i) {
                System.out.format("Starting session %d / %d%n", i + 1, StressConfiguration.NUM_SESSIONS);
                TestReqIdFinder testReqIdFinder = new TestReqIdFinder();
                SessionConfiguration sessionConfiguration = SessionConfiguration.builder().address("localhost", StressConfiguration.PORT).targetCompId("ACC").senderCompId("INIT").build();
                LibraryConfiguration libraryConfiguration = new LibraryConfiguration().sessionAcquireHandler((session, acquiredInfo) -> testReqIdFinder).libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10002"));
                try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                    SleepingIdleStrategy idleStrategy = new SleepingIdleStrategy(100L);
                    Reply reply = library.initiate(sessionConfiguration);
                    while (reply.isExecuting()) {
                        idleStrategy.idle(library.poll(1));
                    }
                    if (!reply.hasCompleted()) {
                        System.err.println("Unable to initiate the session, " + reply.state());
                        reply.error().printStackTrace();
                        System.exit(-1);
                    }
                    if (StressConfiguration.PRINT_EXCHANGE) {
                        System.out.println("Replied with: " + reply.state());
                    }
                    Session session2 = (Session)reply.resultIfPresent();
                    while (!session2.canSendMessage()) {
                        idleStrategy.idle(library.poll(1));
                    }
                    StressUtil.exchangeMessages(library, session2, (IdleStrategy)idleStrategy, testReqIdFinder, messagePool, random, "INIT");
                    session2.startLogout();
                    while (session2.state() != SessionState.DISCONNECTED) {
                        idleStrategy.idle(library.poll(1));
                    }
                    if (!StressConfiguration.PRINT_EXCHANGE) continue;
                    System.out.println("Disconnected");
                    continue;
                }
            }
        }
        server.close();
        System.out.format("Sessions %d. Messages %d per session.%n", StressConfiguration.NUM_SESSIONS, StressConfiguration.MESSAGES_EXCHANGED);
        System.out.format("Stress test executed in %dms%n", System.currentTimeMillis() - startTime);
    }
}

