/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CodecConfiguration {
    public static final String FIX_CODECS_ALLOW_DUPLICATE_FIELDS_PROPERTY = "fix.codecs.allow_duplicate_fields";
    public static final String PARENT_PACKAGE_PROPERTY = "fix.codecs.parent_package";
    public static final String FLYWEIGHTS_ENABLED_PROPERTY = "fix.codecs.flyweight";
    public static final String REJECT_UNKNOWN_ENUM_VALUE_PROPERTY = "reject.unknown.enum.value";
    public static final String DEFAULT_PARENT_PACKAGE = "uk.co.real_logic.artio";
    private String parentPackage = System.getProperty("fix.codecs.parent_package", "uk.co.real_logic.artio");
    private boolean flyweightsEnabled = Boolean.getBoolean("fix.codecs.flyweight");
    private boolean allowDuplicateFields = Boolean.getBoolean("fix.codecs.allow_duplicate_fields");
    private String codecRejectUnknownEnumValueEnabled;
    private String outputPath;
    private String[] fileNames;
    private InputStream[] fileStreams;

    public CodecConfiguration outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    public CodecConfiguration parentPackage(String parentPackage) {
        this.parentPackage = parentPackage;
        return this;
    }

    public CodecConfiguration flyweightsEnabled(boolean flyweightsEnabled) {
        this.flyweightsEnabled = flyweightsEnabled;
        return this;
    }

    public CodecConfiguration allowDuplicateFields(boolean allowDuplicateFields) {
        this.allowDuplicateFields = allowDuplicateFields;
        return this;
    }

    public CodecConfiguration fileNames(String ... fileNames) {
        this.fileNames = fileNames;
        return this;
    }

    public CodecConfiguration fileStreams(InputStream ... fileStreams) {
        this.fileStreams = fileStreams;
        return this;
    }

    public CodecConfiguration codecRejectUnknownEnumValueEnabled(String codecRejectUnknownEnumValueEnabled) {
        this.codecRejectUnknownEnumValueEnabled = codecRejectUnknownEnumValueEnabled;
        return this;
    }

    public InputStream[] fileStreams() {
        return this.fileStreams;
    }

    public String outputPath() {
        return this.outputPath;
    }

    public String parentPackage() {
        return this.parentPackage;
    }

    public boolean flyweightsEnabled() {
        return this.flyweightsEnabled;
    }

    public boolean allowDuplicateFields() {
        return this.allowDuplicateFields;
    }

    public String codecRejectUnknownEnumValueEnabled() {
        return this.codecRejectUnknownEnumValueEnabled;
    }

    void conclude() throws FileNotFoundException {
        if (this.outputPath() == null) {
            throw new IllegalArgumentException("Missing outputPath() configuration property");
        }
        if (this.codecRejectUnknownEnumValueEnabled == null) {
            String rejectUnknownEnumPropertyValue = System.getProperty(REJECT_UNKNOWN_ENUM_VALUE_PROPERTY);
            String string = this.codecRejectUnknownEnumValueEnabled = rejectUnknownEnumPropertyValue != null ? rejectUnknownEnumPropertyValue : "CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED";
        }
        if (this.fileStreams == null) {
            if (this.fileNames == null) {
                throw new IllegalArgumentException("You must provide either the fileNames or fileStream configuration options");
            }
            int n = this.fileNames.length;
            this.fileStreams = new InputStream[n];
            for (int i = 0; i < n; ++i) {
                File xmlFile = new File(this.fileNames[i]);
                if (!xmlFile.exists()) {
                    throw new IllegalArgumentException("xmlFile does not exist: " + xmlFile.getAbsolutePath());
                }
                if (!xmlFile.isFile()) {
                    throw new IllegalArgumentException(String.format("xmlFile [%s] isn't a file, are the arguments the correct way around?", xmlFile));
                }
                this.fileStreams[i] = new FileInputStream(xmlFile);
            }
        }
    }
}

