/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.util.EpochFractionClock;

public class EpochFractionClocks {
    public static EpochFractionClock millisClock(EpochClock clock) {
        return new MillisBasedClock(clock);
    }

    public static EpochFractionClock create(EpochClock clock, EpochNanoClock nanoClock, EpochFractionFormat format) {
        switch (format) {
            case NANOSECONDS: {
                return new NanoBasedClock(nanoClock);
            }
            case MICROSECONDS: {
                return new MicrosBasedClock(nanoClock);
            }
            case MILLISECONDS: {
                return new MillisBasedClock(clock);
            }
        }
        throw new RuntimeException("Unknown precision: " + (Object)((Object)format));
    }

    static class NanoBasedClock
    implements EpochFractionClock {
        private final EpochNanoClock epochNanoClock;

        NanoBasedClock(EpochNanoClock epochNanoClock) {
            this.epochNanoClock = epochNanoClock;
        }

        @Override
        public long epochFractionTime() {
            return this.epochNanoClock.nanoTime();
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.NANOSECONDS;
        }
    }

    static class MicrosBasedClock
    implements EpochFractionClock {
        private final EpochNanoClock epochNanoClock;

        MicrosBasedClock(EpochNanoClock epochNanoClock) {
            this.epochNanoClock = epochNanoClock;
        }

        @Override
        public long epochFractionTime() {
            return this.epochNanoClock.nanoTime() / 1000L;
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.MICROSECONDS;
        }
    }

    static class MillisBasedClock
    implements EpochFractionClock {
        private final EpochClock clock;

        MillisBasedClock(EpochClock clock) {
            this.clock = clock;
        }

        @Override
        public long epochFractionTime() {
            return this.clock.time();
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.MILLISECONDS;
        }
    }
}

