/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.InputStream;
import org.agrona.generation.OutputManager;
import org.agrona.generation.PackageOutputManager;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.DictionaryParser;
import uk.co.real_logic.artio.dictionary.generation.AcceptorGenerator;
import uk.co.real_logic.artio.dictionary.generation.CodecConfiguration;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EncoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.FixDictionaryGenerator;
import uk.co.real_logic.artio.dictionary.generation.PrinterGenerator;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;

public final class CodecGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(CodecConfiguration configuration) throws Exception {
        configuration.conclude();
        String outputPath = configuration.outputPath();
        boolean allowDuplicates = configuration.allowDuplicateFields();
        InputStream[] fileStreams = configuration.fileStreams();
        DictionaryParser parser = new DictionaryParser(allowDuplicates);
        String codecRejectUnknownEnumValueEnabled = configuration.codecRejectUnknownEnumValueEnabled();
        Dictionary dictionary = null;
        for (InputStream fileStream : fileStreams) {
            try {
                dictionary = parser.parse(fileStream, dictionary);
            }
            finally {
                fileStream.close();
            }
        }
        String parentPackage = configuration.parentPackage();
        String encoderPackage = parentPackage + ".builder";
        String decoderPackage = parentPackage + ".decoder";
        String decoderFlyweightPackage = parentPackage + ".decoder_flyweight";
        PackageOutputManager parentOutput = new PackageOutputManager(outputPath, parentPackage);
        PackageOutputManager decoderOutput = new PackageOutputManager(outputPath, decoderPackage);
        PackageOutputManager encoderOutput = new PackageOutputManager(outputPath, encoderPackage);
        new EnumGenerator(dictionary, parentPackage, (OutputManager)parentOutput).generate();
        new ConstantGenerator(dictionary, parentPackage, (OutputManager)parentOutput).generate();
        new FixDictionaryGenerator(dictionary, (OutputManager)parentOutput, encoderPackage, decoderPackage, parentPackage).generate();
        new EncoderGenerator(dictionary, encoderPackage, parentPackage, (OutputManager)encoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, codecRejectUnknownEnumValueEnabled).generate();
        new DecoderGenerator(dictionary, 1, decoderPackage, parentPackage, encoderPackage, (OutputManager)decoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, false, codecRejectUnknownEnumValueEnabled).generate();
        new PrinterGenerator(dictionary, decoderPackage, (OutputManager)decoderOutput).generate();
        new AcceptorGenerator(dictionary, decoderPackage, (OutputManager)decoderOutput).generate();
        if (configuration.flyweightsEnabled()) {
            PackageOutputManager flyweightDecoderOutput = new PackageOutputManager(outputPath, decoderFlyweightPackage);
            new DecoderGenerator(dictionary, 1, decoderFlyweightPackage, parentPackage, encoderPackage, (OutputManager)flyweightDecoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, true, codecRejectUnknownEnumValueEnabled).generate();
        }
    }
}

