/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public class LastKnownSequenceNumberEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 19;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LastKnownSequenceNumberEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int initialOffset;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 19;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public LastKnownSequenceNumberEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public LastKnownSequenceNumberEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(19).schemaId(666).version(6);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sessionIdId() {
        return 1;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 0;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public LastKnownSequenceNumberEncoder sessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sequenceNumberId() {
        return 2;
    }

    public static int sequenceNumberSinceVersion() {
        return 0;
    }

    public static int sequenceNumberEncodingOffset() {
        return 8;
    }

    public static int sequenceNumberEncodingLength() {
        return 4;
    }

    public static String sequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sequenceNumberNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sequenceNumberMinValue() {
        return -2147483647;
    }

    public static int sequenceNumberMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LastKnownSequenceNumberEncoder sequenceNumber(int value) {
        this.buffer.putInt(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int metaDataPositionId() {
        return 3;
    }

    public static int metaDataPositionSinceVersion() {
        return 1;
    }

    public static int metaDataPositionEncodingOffset() {
        return 12;
    }

    public static int metaDataPositionEncodingLength() {
        return 4;
    }

    public static String metaDataPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metaDataPositionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int metaDataPositionMinValue() {
        return -2147483647;
    }

    public static int metaDataPositionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LastKnownSequenceNumberEncoder metaDataPosition(int value) {
        this.buffer.putInt(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messagePositionId() {
        return 4;
    }

    public static int messagePositionSinceVersion() {
        return 3;
    }

    public static int messagePositionEncodingOffset() {
        return 16;
    }

    public static int messagePositionEncodingLength() {
        return 8;
    }

    public static String messagePositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long messagePositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long messagePositionMinValue() {
        return -9223372036854775807L;
    }

    public static long messagePositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public LastKnownSequenceNumberEncoder messagePosition(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        LastKnownSequenceNumberDecoder decoder = new LastKnownSequenceNumberDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 24, 6);
        return decoder.appendTo(builder);
    }
}

