/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util.float_parsing;

import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.PowerOf10;
import uk.co.real_logic.artio.util.float_parsing.CharReader;

public final class DecimalFloatParser {
    private static final char LOWER_CASE_E = 'e';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final byte DOT = 46;

    public static <Data> DecimalFloat extract(DecimalFloat number, CharReader<Data> charReader, Data data, int offset, int length) {
        boolean negative;
        int index;
        int workingOffset = offset;
        int end = workingOffset + length;
        for (int index2 = end - 1; charReader.isSpace(data, index2) && index2 > workingOffset; --index2) {
            --end;
        }
        int endDiff = 0;
        for (index = end - 1; charReader.isZero(data, index) && index > workingOffset; --index) {
            ++endDiff;
        }
        if (DecimalFloatParser.isFloatingPoint(charReader, workingOffset, end, endDiff, data)) {
            end -= endDiff;
        }
        for (index = workingOffset; charReader.isSpace(data, index) && index < end; ++index) {
            ++workingOffset;
        }
        boolean bl = negative = charReader.charAt(data, workingOffset) == '-';
        if (negative) {
            ++workingOffset;
        }
        for (int index3 = workingOffset; index3 < end && charReader.isZero(data, index3); ++index3) {
            ++workingOffset;
        }
        int workingScale = 0;
        long value = 0L;
        int base10exponent = 0;
        boolean isScientificNotation = false;
        int scaleDecrementValue = 0;
        int scientificExponentMultiplier = -1;
        for (int index4 = workingOffset; index4 < end; ++index4) {
            char charValue = charReader.charAt(data, index4);
            if (charValue == '.') {
                workingScale = end - (index4 + 1);
                scaleDecrementValue = 1;
                continue;
            }
            if (charValue == 'e') {
                isScientificNotation = true;
                workingScale -= scaleDecrementValue;
                continue;
            }
            if (isScientificNotation && charValue == '+') {
                workingScale -= scaleDecrementValue;
                continue;
            }
            if (isScientificNotation && charValue == '-') {
                workingScale -= scaleDecrementValue;
                scientificExponentMultiplier = 1;
                continue;
            }
            int digit = charReader.getDigit(data, index4, charValue);
            if (isScientificNotation) {
                base10exponent = base10exponent * 10 + digit;
                workingScale -= scaleDecrementValue;
                continue;
            }
            if ((value = value * 10L + (long)digit) >= 0L) continue;
            throw new ArithmeticException("Out of range: when parsing " + charReader.asString(data, offset, length));
        }
        int scale = workingScale + scientificExponentMultiplier * base10exponent;
        long signedValue = negative ? -1L * value : value;
        return number.set(scale >= 0 ? signedValue : signedValue * PowerOf10.pow10(-scale), Math.max(scale, 0));
    }

    private static <Data> boolean isFloatingPoint(CharReader<Data> dataExtractor, int offset, int end, int endDiff, Data data) {
        for (int index = end - endDiff - 1; index > offset; --index) {
            if (dataExtractor.charAt(data, index) != '.') continue;
            return true;
        }
        return false;
    }
}

