/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import org.agrona.Verify;
import uk.co.real_logic.artio.ilink.ILink3SessionHandler;

public class ILink3SessionConfiguration {
    public static final int DEFAULT_REQUESTED_KEEP_ALIVE_INTERVAL = 10000;
    public static final long AUTOMATIC_INITIAL_SEQUENCE_NUMBER = -1L;
    private String host;
    private int port;
    private String sessionId;
    private String firmId;
    private String tradingSystemName = "";
    private String tradingSystemVersion = "";
    private String tradingSystemVendor = "";
    private int requestedKeepAliveIntervalInMs = 10000;
    private String userKey;
    private long initialSentSequenceNumber = -1L;
    private long initialReceivedSequenceNumber = -1L;
    private String accessKeyId;
    private boolean reestablishLastSession = false;
    private ILink3SessionHandler handler;

    public ILink3SessionConfiguration host(String host) {
        this.host = host;
        return this;
    }

    public String host() {
        return this.host;
    }

    public ILink3SessionConfiguration port(int port) {
        this.port = port;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ILink3SessionConfiguration sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public ILink3SessionConfiguration firmId(String firmId) {
        this.firmId = firmId;
        return this;
    }

    public String firmId() {
        return this.firmId;
    }

    public ILink3SessionConfiguration tradingSystemName(String tradingSystemName) {
        this.tradingSystemName = tradingSystemName;
        return this;
    }

    public String tradingSystemName() {
        return this.tradingSystemName;
    }

    public ILink3SessionConfiguration tradingSystemVersion(String tradingSystemVersion) {
        this.tradingSystemVersion = tradingSystemVersion;
        return this;
    }

    public String tradingSystemVersion() {
        return this.tradingSystemVersion;
    }

    public ILink3SessionConfiguration tradingSystemVendor(String tradingSystemVendor) {
        this.tradingSystemVendor = tradingSystemVendor;
        return this;
    }

    public String tradingSystemVendor() {
        return this.tradingSystemVendor;
    }

    public ILink3SessionConfiguration requestedKeepAliveIntervalInMs(int requestedKeepAliveIntervalInMs) {
        this.requestedKeepAliveIntervalInMs = requestedKeepAliveIntervalInMs;
        return this;
    }

    public int requestedKeepAliveIntervalInMs() {
        return this.requestedKeepAliveIntervalInMs;
    }

    public ILink3SessionConfiguration userKey(String userKey) {
        this.userKey = userKey;
        return this;
    }

    public String userKey() {
        return this.userKey;
    }

    public ILink3SessionConfiguration initialSentSequenceNumber(long initialSentSequenceNumber) {
        this.initialSentSequenceNumber = initialSentSequenceNumber;
        return this;
    }

    public long initialSentSequenceNumber() {
        return this.initialSentSequenceNumber;
    }

    public ILink3SessionConfiguration initialReceivedSequenceNumber(long initialReceivedSequenceNumber) {
        this.initialReceivedSequenceNumber = initialReceivedSequenceNumber;
        return this;
    }

    public long initialReceivedSequenceNumber() {
        return this.initialReceivedSequenceNumber;
    }

    public ILink3SessionConfiguration accessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public ILink3SessionConfiguration reestablishLastSession(boolean reestablishLastSession) {
        this.reestablishLastSession = reestablishLastSession;
        return this;
    }

    public boolean reestablishLastSession() {
        return this.reestablishLastSession;
    }

    public ILink3SessionConfiguration handler(ILink3SessionHandler handler) {
        this.handler = handler;
        return this;
    }

    public ILink3SessionHandler handler() {
        return this.handler;
    }

    public void validate() {
        Verify.notNull((Object)this.host, (String)"host");
        Verify.notNull((Object)this.sessionId, (String)"sessionId");
        Verify.notNull((Object)this.firmId, (String)"firmId");
        Verify.notNull((Object)this.userKey, (String)"userKey");
        Verify.notNull((Object)this.accessKeyId, (String)"accessKeyId");
        Verify.notNull((Object)this.handler, (String)"handler");
        if (this.requestedKeepAliveIntervalInMs <= 0) {
            throw new IllegalArgumentException("requestedKeepAliveInterval must be positive, but is: " + this.requestedKeepAliveIntervalInMs);
        }
        if (this.port <= 0) {
            throw new IllegalArgumentException("port must be positive, but is: " + this.port);
        }
    }

    public String toString() {
        return "ILink3SessionConfiguration{host='" + this.host + '\'' + ", port=" + this.port + ", sessionId='" + this.sessionId + '\'' + ", firmId='" + this.firmId + '\'' + ", tradingSystemName='" + this.tradingSystemName + '\'' + ", tradingSystemVersion='" + this.tradingSystemVersion + '\'' + ", tradingSystemVendor='" + this.tradingSystemVendor + '\'' + ", keepAliveInterval=" + this.requestedKeepAliveIntervalInMs + ", userKey='" + this.userKey + '\'' + ", initialSentSequenceNumber=" + this.initialSentSequenceNumber + ", accessKeyId=" + this.accessKeyId + ", handler=" + this.handler + '}';
    }

    public int retransmitRequestMessageLimit() {
        return 2500;
    }
}

