/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.ControlNotificationDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public class ControlNotificationEncoder {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 39;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ControlNotificationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    private final SessionsEncoder sessions = new SessionsEncoder(this);

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 39;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ControlNotificationEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 4);
        return this;
    }

    public ControlNotificationEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(4).templateId(39).schemaId(666).version(4);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ControlNotificationEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long sessionsId() {
        return 2L;
    }

    public SessionsEncoder sessionsCount(int count) {
        this.sessions.wrap(this.buffer, count);
        return this.sessions;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        ControlNotificationDecoder writer = new ControlNotificationDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 4, 4);
        return writer.appendTo(builder);
    }

    public static class SessionsEncoder {
        public static final int HEADER_SIZE = 3;
        private final ControlNotificationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        SessionsEncoder(ControlNotificationEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            this.count = count;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)8, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public SessionsEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SessionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public static int sessionIdId() {
            return 10;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder sessionId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

