/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.lang.reflect.InvocationTargetException;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.builder.AbstractHeartbeatEncoder;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.AbstractLogoutEncoder;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.AbstractResendRequestEncoder;
import uk.co.real_logic.artio.builder.AbstractSequenceResetEncoder;
import uk.co.real_logic.artio.builder.AbstractTestRequestEncoder;
import uk.co.real_logic.artio.decoder.AbstractHeartbeatDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.AbstractLogoutDecoder;
import uk.co.real_logic.artio.decoder.AbstractRejectDecoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.AbstractTestRequestDecoder;
import uk.co.real_logic.artio.decoder.AbstractUserRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;

public interface FixDictionary {
    public static final String DEFAULT_FIX_DICTIONARY_NAME = "uk.co.real_logic.artio.FixDictionaryImpl";

    public static FixDictionary of(Class<? extends FixDictionary> fixDictionaryType) {
        try {
            return fixDictionaryType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            throw new IllegalStateException();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            throw new RuntimeException();
        }
    }

    public static Class<? extends FixDictionary> findDefault() {
        return FixDictionary.find(DEFAULT_FIX_DICTIONARY_NAME);
    }

    public static Class<? extends FixDictionary> find(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No FIX Dictionary specified and default found on the classpath", e);
        }
    }

    public String beginString();

    public AbstractLogonEncoder makeLogonEncoder();

    public AbstractResendRequestEncoder makeResendRequestEncoder();

    public AbstractLogoutEncoder makeLogoutEncoder();

    public AbstractHeartbeatEncoder makeHeartbeatEncoder();

    public AbstractRejectEncoder makeRejectEncoder();

    public AbstractTestRequestEncoder makeTestRequestEncoder();

    public AbstractSequenceResetEncoder makeSequenceResetEncoder();

    public AbstractLogonDecoder makeLogonDecoder();

    public AbstractLogoutDecoder makeLogoutDecoder();

    public AbstractRejectDecoder makeRejectDecoder();

    public AbstractTestRequestDecoder makeTestRequestDecoder();

    public AbstractSequenceResetDecoder makeSequenceResetDecoder();

    public AbstractHeartbeatDecoder makeHeartbeatDecoder();

    public AbstractResendRequestDecoder makeResendRequestDecoder();

    public AbstractUserRequestDecoder makeUserRequestDecoder();

    public SessionHeaderDecoder makeHeaderDecoder();
}

