/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.Verify;

public final class GenerationUtil {
    private static final int MESSAGE_TYPE_BITSHIFT = 8;
    public static final String PARENT_PACKAGE = System.getProperty("fix.codecs.parent_package", "uk.co.real_logic.artio");
    public static final boolean FLYWEIGHTS_ENABLED = Boolean.getBoolean("fix.codecs.flyweight");
    public static final String ENCODER_PACKAGE = PARENT_PACKAGE + ".builder";
    public static final String DECODER_PACKAGE = PARENT_PACKAGE + ".decoder";
    public static final String DECODER_FLYWEIGHT_PACKAGE = PARENT_PACKAGE + ".decoder_flyweight";
    public static final String INDENT = "    ";

    private GenerationUtil() {
    }

    public static String fileHeader(String packageName) {
        return String.format("/* Generated Fix Gateway message codec */\npackage %s;\n\n", packageName);
    }

    public static int packMessageType(String representation) {
        int packed = representation.charAt(0);
        if (representation.length() == 2) {
            char second = representation.charAt(1);
            packed |= second << 8;
        }
        return packed;
    }

    public static String constantName(String name) {
        String replacedName = name.replace("ID", "Id").replace("GroupCounter", "");
        return Character.toUpperCase(replacedName.charAt(0)) + replacedName.substring(1).chars().mapToObj(codePoint -> (Character.isUpperCase(codePoint) ? "_" : "") + (char)Character.toUpperCase(codePoint)).collect(Collectors.joining());
    }

    public static String constructor(String name, Var ... parameters) {
        String binding = Stream.of(parameters).map(var -> String.format("%1$s%1$s this.%2$s = %2$s;", INDENT, ((Var)var).name)).collect(Collectors.joining("\n"));
        return String.format("%s%s(%s)\n%1$s{\n%s\n%1$s}\n\n", INDENT, name, GenerationUtil.paramDeclaration(parameters), binding);
    }

    public static String paramDeclaration(Var[] parameters) {
        return Stream.of(parameters).map(Var::declaration).collect(Collectors.joining(", "));
    }

    public static String importFor(Class<?> cls) {
        return String.format("import %s;\n", cls.getCanonicalName());
    }

    public static String importFor(String className) {
        return String.format("import %s;\n", className);
    }

    public static String importStaticFor(Class<?> cls) {
        return String.format("import static %s.*;\n", cls.getCanonicalName());
    }

    public static String importStaticFor(Class<?> cls, String name) {
        Verify.notNull((Object)name, (String)"name");
        return String.format("import static %s.%s;\n", cls.getCanonicalName(), name);
    }

    public static String optionalStaticInit(String containing) {
        return containing.isEmpty() ? "\n" : "    static\n    {\n" + containing + "    }\n\n";
    }

    public static class Var {
        private final String type;
        private final String methodArgsType;
        private final String name;

        public Var(String type, String methodArgsType, String name) {
            this.type = type;
            this.methodArgsType = methodArgsType;
            this.name = name;
        }

        public String field() {
            return String.format("%sprivate final %s %s;\n\n", GenerationUtil.INDENT, this.type, this.name);
        }

        public String getter() {
            return String.format("%spublic final %s %s() { return %3$s; }\n\n", GenerationUtil.INDENT, this.type, this.name);
        }

        public String declaration() {
            return String.format("final %s %s", this.type, this.name);
        }

        public String methodArgsDeclaration() {
            return String.format("final %s %s", this.methodArgsType, this.name);
        }
    }
}

