/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

public class DecoderGenerator
extends Generator {
    public static final String REQUIRED_FIELDS = "REQUIRED_FIELDS";
    private static final String GROUP_FIELDS = "GROUP_FIELDS";
    public static final int INVALID_TAG_NUMBER = RejectReason.INVALID_TAG_NUMBER.representation();
    public static final int REQUIRED_TAG_MISSING = RejectReason.REQUIRED_TAG_MISSING.representation();
    public static final int TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = RejectReason.TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE.representation();
    public static final int TAG_SPECIFIED_WITHOUT_A_VALUE = RejectReason.TAG_SPECIFIED_WITHOUT_A_VALUE.representation();
    public static final int VALUE_IS_INCORRECT = RejectReason.VALUE_IS_INCORRECT.representation();
    public static final int TAG_APPEARS_MORE_THAN_ONCE = RejectReason.TAG_APPEARS_MORE_THAN_ONCE.representation();
    public static final int TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14;
    private Aggregate currentAggregate = null;
    private final int initialBufferSize;

    static String decoderClassName(Aggregate aggregate) {
        return DecoderGenerator.decoderClassName(aggregate.name());
    }

    static String decoderClassName(String name) {
        return name + "Decoder";
    }

    public DecoderGenerator(Dictionary dictionary, int initialBufferSize, String thisPackage, String commonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownClass, boolean flyweightsEnabled) {
        super(dictionary, thisPackage, commonPackage, outputManager, validationClass, rejectUnknownClass, flyweightsEnabled);
        this.initialBufferSize = initialBufferSize;
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType type) {
        if (type == AggregateType.COMPONENT) {
            this.componentInterface((Component)aggregate);
            return;
        }
        String className = DecoderGenerator.decoderClassName(aggregate);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            this.generateImports("Decoder", type, (Writer)out, new Class[0]);
            this.generateAggregateClass(aggregate, type, className, (Writer)out);
        });
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        Aggregate parentAggregate = this.currentAggregate;
        this.currentAggregate = aggregate;
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        List<String> interfaces = aggregate.entriesWith(element -> element instanceof Component).map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
        interfaces.add(Decoder.class.getSimpleName());
        out.append(this.classDeclaration(className, interfaces, false));
        this.generateValidation(out, aggregate, type);
        if (isMessage) {
            Message message = (Message)aggregate;
            out.append(this.messageType(message.fullType(), message.packedType()));
            List<Field> fields = this.compileAllFieldsFor(message);
            String messageFieldsSet = this.generateFieldDictionary(fields, "messageFields", false);
            out.append(this.commonCompoundImports("Decoder", true, messageFieldsSet));
        }
        this.groupMethods(out, aggregate);
        this.headerMethods(out, aggregate, type);
        this.getters(out, aggregate.entries());
        out.append(this.decodeMethod(aggregate.entries(), aggregate, type));
        out.append(this.completeResetMethod(isMessage, aggregate.entries(), this.additionalReset(isGroup)));
        out.append(this.toString(aggregate, isMessage));
        out.append("}\n");
        this.currentAggregate = parentAggregate;
    }

    private List<Field> compileAllFieldsFor(Message message) {
        Stream<Field> messageBodyFields = this.extractFields(message.entries());
        Stream<Field> headerFields = this.extractFields(this.dictionary.header().entries());
        Stream<Field> trailerFields = this.extractFields(this.dictionary.trailer().entries());
        return Stream.of(headerFields, messageBodyFields, trailerFields).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private void headerMethods(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        if (type == AggregateType.HEADER) {
            out.append("    public HeaderDecoder()\n    {\n        this(new TrailerDecoder());\n    }\n\n");
            this.wrapTrailerInConstructor(out, aggregate);
        }
    }

    private void groupClass(Group group, Writer out) throws IOException {
        String className = DecoderGenerator.decoderClassName(group);
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Decoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        Entry numberField = group.numberField();
        return String.format("    public void %1$s()\n    {\n        for (final %2$s %6$s : %5$s.iterator())\n        {\n            %6$s.reset();\n            if (%6$s.next() == null)\n            {\n                break;\n            }\n        }\n        %3$s = 0;\n        has%4$s = false;\n    }\n\n", this.nameOfResetMethod(name), DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name(), DecoderGenerator.iteratorFieldName(group), JavaUtil.formatPropertyName((String)DecoderGenerator.decoderClassName(name)));
    }

    private static String iteratorClassName(Group group) {
        return group.name() + "Iterator";
    }

    private static String iteratorFieldName(Group group) {
        return JavaUtil.formatPropertyName((String)DecoderGenerator.iteratorClassName(group));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        String lengthReset = this.flyweightsEnabled ? "        %1$sLength = 0;\n" : "";
        return String.format("    public void %2$s()\n    {\n" + lengthReset + "        %1$s.reset();\n    }\n\n", JavaUtil.formatPropertyName((String)name), this.nameOfResetMethod(name));
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetFieldValue(field, "MISSING_INT");
    }

    @Override
    protected String toStringGroupParameters() {
        return "";
    }

    @Override
    protected String toStringGroupSuffix() {
        return "        if (next != null)\n        {\n            entries += \",\\n\" + next.toString();\n        }\n";
    }

    private String additionalReset(boolean isGroup) {
        return "        buffer = null;\n        if (CODEC_VALIDATION_ENABLED)\n        {\n            invalidTagId = NO_ERROR;\n            rejectReason = NO_ERROR;\n            missingRequiredFields.clear();\n" + (isGroup ? "" : "            unknownFields.clear();\n            alreadyVisitedFields.clear();\n") + "        }\n";
    }

    private void generateValidation(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        List<Field> requiredFields = this.requiredFields(aggregate.entries()).collect(Collectors.toList());
        out.append(this.generateFieldDictionary(requiredFields, REQUIRED_FIELDS, true));
        if (aggregate.containsGroup()) {
            List<Field> groupFields = aggregate.allFieldsIncludingComponents().map(Entry::element).map(element -> (Field)element).collect(Collectors.toList());
            String groupFieldString = this.generateFieldDictionary(groupFields, GROUP_FIELDS, true);
            out.append(groupFieldString);
        }
        String enumValidation = aggregate.allFieldsIncludingComponents().filter(entry -> entry.element().isEnumField()).map(entry -> this.validateEnum((Entry)entry, out)).collect(Collectors.joining("\n"));
        String groupValidation = aggregate.entriesWith(element -> element instanceof Group).map(entry -> this.generateGroupValidation((Entry)entry, out)).collect(Collectors.joining("\n"));
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        String messageValidation = isMessage ? "        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())\n        {\n            invalidTagId = unknownFieldsIterator.nextValue();\n            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? " + TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE + " : " + INVALID_TAG_NUMBER + ";\n            return false;\n        }\n        if (!header.validate())\n        {\n            invalidTagId = header.invalidTagId();\n            rejectReason = header.rejectReason();\n            return false;\n        }\n        else if (!trailer.validate())\n        {\n            invalidTagId = trailer.invalidTagId();\n            rejectReason = trailer.rejectReason();\n            return false;\n        }\n" : "";
        out.append(String.format((isGroup ? "" : "    private final IntHashSet alreadyVisitedFields = new IntHashSet(%5$d);\n\n    private final IntHashSet unknownFields = new IntHashSet(10);\n\n") + "    private final IntHashSet missingRequiredFields = new IntHashSet(%1$d);\n\n    private int invalidTagId = NO_ERROR;\n\n    public int invalidTagId()\n    {\n        return invalidTagId;\n    }\n\n    private int rejectReason = NO_ERROR;\n\n    public int rejectReason()\n    {\n        return rejectReason;\n    }\n\n    public boolean validate()\n    {\n        if (rejectReason != NO_ERROR)\n        {\n            return false;\n        }\n        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();\n" + (isMessage ? "        final IntIterator unknownFieldsIterator = unknownFields.iterator();\n" : "") + "%2$s        if (missingFieldsIterator.hasNext())\n        {\n            invalidTagId = missingFieldsIterator.nextValue();\n            rejectReason = " + REQUIRED_TAG_MISSING + ";\n            return false;\n        }\n%3$s%4$s        return true;\n    }\n\n", ConstantGenerator.sizeHashSet(requiredFields), messageValidation, enumValidation, groupValidation, 2L * aggregate.allFieldsIncludingComponents().count()));
    }

    private String generateFieldDictionary(Collection<Field> fields, String name, boolean shouldGenerateValidationGating) {
        String addFields = fields.stream().map(field -> DecoderGenerator.addField(field, name, "            ")).collect(Collectors.joining());
        String generatedFieldEntryCode = shouldGenerateValidationGating ? "        if (CODEC_VALIDATION_ENABLED)\n        {\n%s        }\n" : "%s";
        int hashMapSize = ConstantGenerator.sizeHashSet(fields);
        return String.format("    public final IntHashSet %2$s = new IntHashSet(%1$d);\n    {\n%3$s    }\n\n", hashMapSize, name, String.format(generatedFieldEntryCode, addFields));
    }

    public static String addField(Field field, String name, String prefix) {
        return String.format("%1$s%2$s.add(Constants.%3$s);\n", prefix, name, GenerationUtil.constantName(field.name()));
    }

    private CharSequence validateEnum(Entry entry, Writer out) {
        Field field = (Field)entry.element();
        if (!EnumGenerator.hasEnumGenerated(field)) {
            return "";
        }
        String name = entry.name();
        String optionalCheck = entry.required() ? "" : String.format("has%s && ", name);
        int tagNumber = field.number();
        Field.Type type = field.type();
        String propertyName = JavaUtil.formatPropertyName((String)name);
        boolean isChar = type == Field.Type.CHAR;
        boolean isPrimitive = type.isIntBased() || isChar;
        return String.format("        if (%1$s!%2$s.isValid(%3$s()%5$s))\n        {\n            invalidTagId = %4$s;\n            rejectReason = " + VALUE_IS_INCORRECT + ";\n            return false;\n        }\n", optionalCheck, name, propertyName, tagNumber, isPrimitive ? "" : ", " + propertyName + "Length");
    }

    private CharSequence generateGroupValidation(Entry entry, Writer out) {
        Group group = (Group)entry.element();
        String numberFieldName = group.numberField().name();
        String validationCode = String.format("        for (final %1$s iterator : %2$s.iterator())\n        {\n            if (!iterator.validate())\n            {\n                invalidTagId = iterator.invalidTagId();\n                rejectReason = iterator.rejectReason();\n                return false;\n            }\n        }\n", DecoderGenerator.decoderClassName(group), DecoderGenerator.iteratorFieldName(group));
        if (entry.required()) {
            return validationCode;
        }
        return String.format("        if (has%1$s)\n        {\n            %2$s        }\n", numberFieldName, validationCode);
    }

    private Stream<Field> requiredFields(List<Entry> entries) {
        return entries.stream().filter(Entry::required).flatMap(this::extractRequiredFields);
    }

    private Stream<Field> extractRequiredFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.of((Field)group.numberField().element()), (e, component) -> this.requiredFields(component.entries()));
    }

    private Stream<Field> extractFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.concat(Stream.of((Field)group.numberField().element()), group.entries().stream().flatMap(this::extractFields)), (e, component) -> component.entries().stream().flatMap(this::extractFields));
    }

    private Stream<Field> extractFields(List<Entry> entries) {
        return entries.stream().flatMap(this::extractFields);
    }

    private void componentInterface(Component component) {
        String className = DecoderGenerator.decoderClassName(component);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            List interfaces = component.allComponents().map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
            String interfaceExtension = interfaces.isEmpty() ? "" : " extends " + String.join((CharSequence)", ", interfaces);
            this.generateImports("Decoder", AggregateType.COMPONENT, (Writer)out, new Class[0]);
            out.append(String.format("\npublic interface %1$s %2$s\n{\n\n", className, interfaceExtension));
            for (Entry entry : component.entries()) {
                this.interfaceGetter(component, entry, (Writer)out);
            }
            out.append("\n}\n");
        });
    }

    private void interfaceGetter(Aggregate parent, Entry entry, Writer out) throws IOException {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldInterfaceGetter(entry, (Field)field))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupInterfaceGetter(parent, (Group)group, out)), (ResourceConsumer<Component>)((ResourceConsumer)component -> {}));
    }

    private void groupInterfaceGetter(Aggregate parent, Group group, Writer out) throws IOException {
        this.groupClass(group, out);
        this.generateGroupIterator(parent, out, group);
        Entry numberField = group.numberField();
        out.append(String.format("public %1$s %2$s();\n", DecoderGenerator.iteratorClassName(group), DecoderGenerator.iteratorFieldName(group)));
        out.append(this.fieldInterfaceGetter(numberField, (Field)numberField.element()));
        out.append(String.format("    public %1$s %2$s();\n", DecoderGenerator.decoderClassName(group), JavaUtil.formatPropertyName((String)group.name())));
    }

    private void wrappedForEachEntry(Aggregate aggregate, Writer out, ResourceConsumer<Entry> consumer) throws IOException {
        out.append("\n");
        aggregate.entries().forEach(Exceptions.rethrown(consumer));
        out.append("\n");
    }

    private String fieldInterfaceGetter(Entry entry, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String length = type.isStringBased() ? String.format("    public int %1$sLength();\n", fieldName) : "";
        String stringAsciiView = type.isStringBased() ? String.format("    public void %1$s(AsciiSequenceView view);\n", fieldName) : "";
        String optional = !entry.required() ? String.format("    public boolean has%1$s();\n", name) : "";
        String enumDecoder = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? String.format("    public %s %sAsEnum();\n", name, fieldName) : "";
        return String.format("    public %1$s %2$s();\n%3$s%4$s%5$s%6$s", this.javaTypeOf(type), fieldName, optional, length, enumDecoder, stringAsciiView);
    }

    private void getter(Entry entry, Writer out) throws IOException {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldGetter(entry, (Field)field))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupGetter((Group)group, out)), (ResourceConsumer<Component>)((ResourceConsumer)component -> this.componentGetter((Component)component, out)));
    }

    private void groupMethods(Writer out, Aggregate aggregate) throws IOException {
        if (aggregate instanceof Group) {
            this.wrapTrailerAndMessageFieldsInConstructor(out, aggregate);
            out.append(String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        return next;\n    }\n\n    private IntHashSet seenFields = new IntHashSet(%2$d);\n\n", DecoderGenerator.decoderClassName(aggregate), ConstantGenerator.sizeHashSet(aggregate.entries())));
        }
    }

    private void wrapTrailerAndMessageFieldsInConstructor(Writer out, Aggregate aggregate) throws IOException {
        out.append(String.format("    private final TrailerDecoder trailer;\n    private final IntHashSet %1$s;\n    public %2$s(final TrailerDecoder trailer, final IntHashSet %1$s)\n    {\n        this.trailer = trailer;\n        this.%1$s = %1$s;\n    }\n\n", "messageFields", DecoderGenerator.decoderClassName(aggregate)));
    }

    private void wrapTrailerInConstructor(Writer out, Aggregate aggregate) throws IOException {
        out.append(String.format("    private final TrailerDecoder trailer;\n    public %1$s(final TrailerDecoder trailer)\n    {\n        this.trailer = trailer;\n    }\n\n", DecoderGenerator.decoderClassName(aggregate)));
    }

    private String messageType(String fullType, int packedType) {
        return String.format("    public static final int MESSAGE_TYPE = %1$d;\n\n    public static final String MESSAGE_TYPE_AS_STRING = \"%2$s\";\n\n    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();\n\n    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);\n\n", packedType, fullType);
    }

    private void getters(Writer out, List<Entry> entries) throws IOException {
        for (Entry entry : entries) {
            this.getter(entry, out);
        }
    }

    private void componentGetter(Component component, Writer out) throws IOException {
        Aggregate parentAggregate = this.currentAggregate;
        this.currentAggregate = component;
        this.wrappedForEachEntry(component, out, (ResourceConsumer<Entry>)((ResourceConsumer)entry -> this.getter((Entry)entry, out)));
        this.currentAggregate = parentAggregate;
    }

    private void groupGetter(Group group, Writer out) throws IOException {
        if (!(this.currentAggregate instanceof Component)) {
            this.groupClass(group, out);
            this.generateGroupIterator(this.currentAggregate, out, group);
        }
        Entry numberField = group.numberField();
        String prefix = this.fieldGetter(numberField, (Field)numberField.element());
        out.append(String.format("\n    private %1$s %2$s = null;\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n%3$s\n    private %4$s %5$s = new %4$s(this);\n    public %4$s %5$s()\n    {\n        return %5$s.iterator();\n    }\n\n", DecoderGenerator.decoderClassName(group), JavaUtil.formatPropertyName((String)group.name()), prefix, DecoderGenerator.iteratorClassName(group), DecoderGenerator.iteratorFieldName(group)));
    }

    private void generateGroupIterator(Aggregate parent, Writer out, Group group) throws IOException {
        String numberFieldName = group.numberField().name();
        String formattedNumberFieldName = JavaUtil.formatPropertyName((String)numberFieldName);
        String numberFieldReset = group.numberField().required() ? String.format("parent.%1$s()", formattedNumberFieldName) : String.format("parent.has%1$s() ? parent.%2$s() : 0", numberFieldName, formattedNumberFieldName);
        out.append(String.format("    public class %1$s implements Iterable<%2$s>, java.util.Iterator<%2$s>\n    {\n        private final %3$s parent;\n        private int remainder;\n        private %2$s current;\n\n        public %1$s(final %3$s parent)\n        {\n\n            this.parent = parent;\n        }\n\n        public boolean hasNext()\n        {\n            return remainder > 0;\n        }\n        public %2$s next()\n        {\n            remainder--;\n            final %2$s value = current;\n            current = current.next();\n            return value;\n        }\n        public void reset()\n        {\n            remainder = %4$s;\n            current = parent.%5$s();\n        }\n        public %1$s iterator()\n        {\n            reset();\n            return this;\n        }\n    }\n\n", DecoderGenerator.iteratorClassName(group), DecoderGenerator.decoderClassName(group), DecoderGenerator.decoderClassName(parent), numberFieldReset, JavaUtil.formatPropertyName((String)group.name())));
    }

    private String fieldGetter(Entry entry, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String optionalCheck = this.optionalCheck(entry);
        String asStringBody = this.generateAsStringBody(entry, name, fieldName);
        String enumValueDecoder = String.format(type.isStringBased() ? "%1$s.decode(%2$s(), %2$sLength)" : (this.flyweightsEnabled && (type.isIntBased() || type.isFloatBased()) ? "%1$s.decode(%2$s())" : "%1$s.decode(%2$s)"), name, fieldName);
        String asEnumBody = String.format(entry.required() ? "%1$s" : "has%2$s ? %1$s : %2$s.%3$s", enumValueDecoder, name, "NULL_VAL");
        String extraStringDecode = type.isStringBased() ? String.format("    public String %1$sAsString()\n    {\n        return %3$s;\n    }\n\n    public void %1$s(final AsciiSequenceView view)\n    {\n%2$s        view.wrap(buffer, %1$sOffset, %1$sLength);\n    }\n\n", fieldName, optionalCheck, asStringBody) : "";
        String lengthBasedFields = type.hasLengthField(this.flyweightsEnabled) ? String.format("    private int %1$sLength;\n\n    public int %1$sLength()\n    {\n%2$s        return %1$sLength;\n    }\n\n%3$s", fieldName, optionalCheck, extraStringDecode) : "";
        String offsetField = type.hasOffsetField(this.flyweightsEnabled) ? String.format("    private int %1$sOffset;\n\n%2$s", fieldName, lengthBasedFields) : "";
        String enumDecoder = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? String.format("    public %s %sAsEnum()\n    {\n        return %s;\n    }\n\n", name, fieldName, asEnumBody) : "";
        String lazyInitialisation = DecoderGenerator.fieldLazyInstantialisation(field, fieldName);
        return String.format("    private %1$s %2$s%3$s;\n\n%4$s    public %1$s %2$s()\n    {\n%5$s%9$s        return %2$s;\n    }\n\n%6$s\n%7$s\n%8$s", this.javaTypeOf(type), fieldName, this.fieldInitialisation(type), this.hasField(entry), optionalCheck, this.optionalGetter(entry), offsetField, enumDecoder, this.flyweightsEnabled ? lazyInitialisation : "");
    }

    private String generateAsStringBody(Entry entry, String name, String fieldName) {
        String asStringBody = this.flyweightsEnabled ? String.format(entry.required() ? "buffer != null ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : \"\"" : "has%2$s ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : null", fieldName, name) : String.format(entry.required() ? "new String(%1$s, 0, %1$sLength)" : "has%2$s ? new String(%1$s, 0, %1$sLength) : null", fieldName, name);
        return asStringBody;
    }

    private static String fieldLazyInstantialisation(Field field, String fieldName) {
        String decodeMethod;
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                decodeMethod = String.format("buffer.parseIntAscii(%1$sOffset, %1$sLength)", fieldName);
                break;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                decodeMethod = String.format("buffer.getFloat(%1$s, %1$sOffset, %1$sLength)", fieldName);
                break;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                decodeMethod = String.format("buffer.getChars(%1$s, %1$sOffset, %1$sLength);\n", fieldName);
                break;
            }
            case DATA: 
            case XMLDATA: {
                Field associatedLengthField = field.associatedLengthField();
                if (associatedLengthField == null) {
                    throw new IllegalStateException("No associated length field for: " + field);
                }
                String associatedFieldName = JavaUtil.formatPropertyName((String)associatedLengthField.name());
                return String.format("        if (buffer != null && %2$s > 0)\n        {\n            %1$s = buffer.getBytes(%1$s, %1$sOffset, %2$s);\n        }\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                decodeMethod = String.format("buffer.getBytes(%1$s, %1$sOffset, %1$sLength)", fieldName);
                break;
            }
            default: {
                return "";
            }
        }
        return String.format("        if (buffer != null && %1$sLength > 0)\n        {\n            %1$s = %2$s;\n        }\n", fieldName, decodeMethod);
    }

    private String fieldInitialisation(Field.Type type) {
        switch (type) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return String.format(" = new char[%d]", this.initialBufferSize);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return " = new DecimalFloat()";
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: 
            case BOOLEAN: 
            case CHAR: {
                return "";
            }
            case DATA: 
            case XMLDATA: {
                return this.initByteArray(this.initialBufferSize);
            }
            case UTCTIMESTAMP: {
                return this.initByteArray(24);
            }
            case LOCALMKTDATE: {
                return this.initByteArray(8);
            }
            case UTCTIMEONLY: {
                return this.initByteArray(12);
            }
            case UTCDATEONLY: {
                return this.initByteArray(8);
            }
            case MONTHYEAR: {
                return this.initByteArray(8);
            }
            case TZTIMEONLY: {
                return this.initByteArray(19);
            }
            case TZTIMESTAMP: {
                return this.initByteArray(31);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String initByteArray(int initialBufferSize) {
        return String.format(" = new byte[%d]", initialBufferSize);
    }

    private String optionalGetter(Entry entry) {
        return entry.required() ? "" : this.hasGetter(entry.name());
    }

    private String optionalCheck(Entry entry) {
        return entry.required() ? "" : String.format("        if (!has%s)\n        {\n            throw new IllegalArgumentException(\"No value for optional field: %1$s\");\n        }\n\n", entry.name());
    }

    private String javaTypeOf(Field.Type type) {
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return "int";
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return "DecimalFloat";
            }
            case CHAR: {
                return "char";
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return "char[]";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATA: 
            case XMLDATA: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return "byte[]";
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String decodeMethod(List<Entry> entries, Aggregate aggregate, AggregateType type) {
        boolean hasCommonCompounds = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        boolean isHeader = type == AggregateType.HEADER;
        String endGroupCheck = this.endGroupCheck(aggregate, isGroup);
        String prefix = "    private AsciiBuffer buffer;\n\n    public int decode(final AsciiBuffer buffer, final int offset, final int length)\n    {\n        // Decode " + aggregate.name() + "\n        int seenFieldCount = 0;\n        if (" + "CODEC_VALIDATION_ENABLED" + ")\n        {\n            missingRequiredFields.copy(" + REQUIRED_FIELDS + ");\n" + (isGroup ? "" : "            alreadyVisitedFields.clear();\n") + "        }\n        this.buffer = buffer;\n        final int end = offset + length;\n        int position = offset;\n" + (hasCommonCompounds ? "        position += header.decode(buffer, position, length);\n" : "") + (isGroup ? "        seenFields.clear();\n" : "") + "        int tag;\n\n        while (position < end)\n        {\n            final int equalsPosition = buffer.scan(position, end, '=');\n            tag = buffer.getInt(position, equalsPosition);\n" + endGroupCheck + "            final int valueOffset = equalsPosition + 1;\n            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);\n" + this.malformedMessageCheck() + "            final int valueLength = endOfField - valueOffset;\n            if (" + "CODEC_VALIDATION_ENABLED" + ")\n            {\n                if (tag <= 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + INVALID_TAG_NUMBER + ";\n                }\n                else if (valueLength == 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_SPECIFIED_WITHOUT_A_VALUE + ";\n                }\n" + this.headerValidation(isHeader) + (isGroup ? "" : "                if (!alreadyVisitedFields.add(tag))\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_APPEARS_MORE_THAN_ONCE + ";\n                }\n") + "                missingRequiredFields.remove(tag);\n                seenFieldCount++;\n            }\n            switch (tag)\n            {\n\n";
        String body = entries.stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
        String suffix = "            default:\n                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)\n                {\n" + (isGroup ? "                    seenFields.remove(tag);\n" : "                    alreadyVisitedFields.remove(tag);\n") + "                }\n" + (isGroup ? "" : "                else\n                {\n                    if (!" + this.unknownFieldPredicate(type) + ")\n                    {\n                        unknownFields.add(tag);\n                    }\n                }\n") + "                if (" + "CODEC_REJECT_UNKNOWN_FIELD_ENABLED" + " || " + this.unknownFieldPredicate(type) + ")\n                {\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 5) + "                }\n\n            }\n\n            if (position < (endOfField + 1))\n            {\n                position = endOfField + 1;\n            }\n        }\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 2) + "    }\n\n";
        return prefix + body + suffix;
    }

    private String malformedMessageCheck() {
        return "            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)\n            {\n                rejectReason = " + VALUE_IS_INCORRECT + ";\n                break;\n            }\n";
    }

    private String decodeTrailerOrReturn(boolean hasCommonCompounds, int indent) {
        return (hasCommonCompounds ? this.indent(indent, "position += trailer.decode(buffer, position, end - position);\n") : "") + this.indent(indent, "return position - offset;\n");
    }

    private String unknownFieldPredicate(AggregateType type) {
        if (type == AggregateType.TRAILER) {
            return "REQUIRED_FIELDS.contains(tag)";
        }
        if (type == AggregateType.HEADER) {
            return "true";
        }
        return "(trailer.REQUIRED_FIELDS.contains(tag) || messageFields.contains(tag))";
    }

    private String endGroupCheck(Aggregate aggregate, boolean isGroup) {
        String endGroupCheck = isGroup ? String.format("            if (!seenFields.add(tag))\n            {\n                if (next == null)\n                {\n                    next = new %1$s(trailer, %2$s);\n                }\n                return position - offset;\n            }\n", DecoderGenerator.decoderClassName(aggregate), "messageFields") : "";
        return endGroupCheck;
    }

    private String headerValidation(boolean isHeader) {
        return isHeader ? "                else if (seenFieldCount == 0 && tag != 8)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 1 && tag != 9)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 2 && tag != 35)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n" : "";
    }

    private String decodeEntry(Entry entry) {
        return entry.matchEntry(e -> this.decodeField((Entry)e, ""), this::decodeGroup, this::decodeComponent);
    }

    private String decodeComponent(Entry entry) {
        Component component = (Component)entry.element();
        return component.entries().stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
    }

    @Override
    protected String componentToString(Component component) {
        return component.entries().stream().map(this::entryToString).collect(Collectors.joining(" + \n"));
    }

    private String decodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        String groupNumberField = JavaUtil.formatPropertyName((String)group.numberField().name());
        String parseGroup = String.format("                if (%1$s == null)\n                {\n                    %1$s = new %2$s(trailer, %5$s);\n                }\n                %2$s %1$sCurrent = %1$s;\n                position = endOfField + 1;\n                final int %3$s = %4$s;\n                for (int i = 0; i < %3$s && position < end; i++)\n                {\n                    if (%1$sCurrent != null)\n                    {\n                        position += %1$sCurrent.decode(buffer, position, end - position);\n                        %1$sCurrent = %1$sCurrent.next();\n                    }\n                }\n", JavaUtil.formatPropertyName((String)group.name()), DecoderGenerator.decoderClassName(group), groupNumberField, this.flyweightsEnabled ? groupNumberField + "()" : "this." + groupNumberField, "messageFields");
        return this.decodeField(group.numberField(), parseGroup);
    }

    private String decodeField(Entry entry, String suffix) {
        Field field = (Field)entry.element();
        String name = entry.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        return String.format("            case Constants.%s:\n%s%s%s%s%s                break;\n", GenerationUtil.constantName(name), this.optionalAssign(entry), this.fieldDecodeMethod(field, fieldName), this.storeOffsetForVariableLengthFields(field.type(), fieldName), this.storeLengthForVariableLengthFields(field.type(), fieldName), suffix);
    }

    private String storeLengthForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasLengthField(this.flyweightsEnabled) ? String.format("                %sLength = valueLength;\n", fieldName) : "";
    }

    private String storeOffsetForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasOffsetField(this.flyweightsEnabled) ? String.format("                %sOffset = valueOffset;\n", fieldName) : "";
    }

    private String optionalAssign(Entry entry) {
        return entry.required() ? "" : String.format("                has%s = true;\n", entry.name());
    }

    private String fieldDecodeMethod(Field field, String fieldName) {
        String decodeMethod;
        String prefix = String.format("                %s = ", fieldName);
        switch (field.type()) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = "buffer.getInt(valueOffset, endOfField)";
                break;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getFloat(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            case CHAR: {
                decodeMethod = "buffer.getChar(valueOffset)";
                break;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getChars(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            case BOOLEAN: {
                decodeMethod = "buffer.getBoolean(valueOffset)";
                break;
            }
            case DATA: 
            case XMLDATA: {
                String associatedFieldName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                if (this.flyweightsEnabled) {
                    return String.format("                endOfField = valueOffset + %1$s();\n", associatedFieldName);
                }
                return String.format("                %1$s = buffer.getBytes(%1$s, valueOffset, %2$s);\n                endOfField = valueOffset + %2$s;\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getBytes(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)field.type()) + " in " + fieldName);
            }
        }
        return prefix + decodeMethod + ";\n";
    }

    @Override
    protected String stringToString(String fieldName) {
        return String.format("%1$sAsString()", fieldName);
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        return !entry.required();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetNothing(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        return entries.stream().filter(Entry::isComponent).map(entry -> this.resetEntries(((Component)entry.element()).entries(), methods)).collect(Collectors.joining());
    }

    @Override
    protected String resetStringBasedData(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sOffset = 0;\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    @Override
    protected String groupEntryToString(Group element, String name) {
        return String.format("                (has%3$s ? String.format(\"  \\\"%1$s\\\": [\\n  %%s\\n  ]\\n\", %2$s.toString().replace(\"\\n\", \"\\n  \")) : \"\")", name, JavaUtil.formatPropertyName((String)name), element.numberField().name());
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected boolean toStringChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field);
    }
}

