/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.LocalMktDateDecoder;
import uk.co.real_logic.artio.fields.UtcDateOnlyDecoder;
import uk.co.real_logic.artio.fields.UtcTimeOnlyDecoder;
import uk.co.real_logic.artio.fields.UtcTimestampDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.AsciiEncodingException;

public final class MutableAsciiBuffer
extends UnsafeBuffer
implements AsciiBuffer {
    private static final byte ZERO = 48;
    private static final byte DOT = 46;
    private static final byte SPACE = 32;
    private static final byte Y = 89;
    private static final byte N = 78;
    private static final int[] INT_ROUNDS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] LONG_ROUNDS = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final byte[] MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);

    public MutableAsciiBuffer() {
        super(0L, 0);
    }

    public MutableAsciiBuffer(byte[] buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(ByteBuffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(DirectBuffer buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(DirectBuffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(long address, int length) {
        super(address, length);
    }

    @Override
    public int getNatural(int startInclusive, int endExclusive) {
        int tally = 0;
        for (int index = startInclusive; index < endExclusive; ++index) {
            tally = tally * 10 + this.getDigit(index);
        }
        return tally;
    }

    @Override
    public long getNaturalLong(int startInclusive, int endExclusive) {
        long tally = 0L;
        for (int index = startInclusive; index < endExclusive; ++index) {
            tally = tally * 10L + (long)this.getDigit(index);
        }
        return tally;
    }

    @Override
    public int getInt(int startInclusive, int endExclusive) {
        byte first = this.getByte(startInclusive);
        if (first == 45) {
            ++startInclusive;
        }
        int tally = 0;
        for (int index = startInclusive; index < endExclusive; ++index) {
            tally = tally * 10 + this.getDigit(index);
        }
        if (first == 45) {
            tally *= -1;
        }
        return tally;
    }

    @Override
    public int getDigit(int index) {
        byte value = this.getByte(index);
        return this.getDigit(index, value);
    }

    @Override
    public boolean isDigit(int index) {
        byte value = this.getByte(index);
        return value >= 48 && value <= 57;
    }

    private int getDigit(int index, byte value) {
        if (value < 48 || value > 57) {
            throw new AsciiEncodingException("'" + (char)value + "' isn't a valid digit @ " + index);
        }
        return value - 48;
    }

    @Override
    public char getChar(int index) {
        return (char)this.getByte(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return 89 == this.getByte(index);
    }

    @Override
    public byte[] getBytes(byte[] oldBuffer, int offset, int length) {
        byte[] resultBuffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        this.getBytes(offset, resultBuffer, 0, length);
        return resultBuffer;
    }

    @Override
    public char[] getChars(char[] oldBuffer, int offset, int length) {
        char[] resultBuffer = oldBuffer.length < length ? new char[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            resultBuffer[i] = this.getChar(i + offset);
        }
        return resultBuffer;
    }

    @Override
    public String getAscii(int offset, int length) {
        byte[] buff = new byte[length];
        this.getBytes(offset, buff);
        return new String(buff, 0, length, StandardCharsets.US_ASCII);
    }

    @Override
    public int getMessageType(int offset, int length) {
        if (length == 1) {
            return this.getByte(offset);
        }
        return this.getShort(offset);
    }

    @Override
    public DecimalFloat getFloat(DecimalFloat number, int offset, int length) {
        boolean negative;
        int index;
        int end = offset + length;
        for (int index2 = end - 1; this.isSpace(index2) && index2 > offset; --index2) {
            --end;
        }
        int endDiff = 0;
        for (int index3 = end - 1; this.isZero(index3) && index3 > offset; --index3) {
            ++endDiff;
        }
        boolean isFloatingPoint = false;
        for (index = end - endDiff - 1; index > offset; --index) {
            if (this.getByte(index) != 46) continue;
            isFloatingPoint = true;
            break;
        }
        if (isFloatingPoint) {
            end -= endDiff;
        }
        for (index = offset; this.isSpace(index) && index < end; ++index) {
            ++offset;
        }
        boolean bl = negative = this.getByte(offset) == 45;
        if (negative) {
            ++offset;
        }
        for (int index4 = offset; this.isZero(index4) && index4 < end; ++index4) {
            ++offset;
        }
        int scale = 0;
        long value = 0L;
        for (int index5 = offset; index5 < end; ++index5) {
            byte byteValue = this.getByte(index5);
            if (byteValue == 46) {
                scale = end - (index5 + 1);
                continue;
            }
            int digit = this.getDigit(index5, byteValue);
            value = value * 10L + (long)digit;
        }
        number.set(negative ? -1L * value : value, scale);
        return number;
    }

    private boolean isSpace(int index) {
        return this.getByte(index) == 32;
    }

    private boolean isZero(int index) {
        return this.getByte(index) == 48;
    }

    @Override
    public int getLocalMktDate(int offset, int length) {
        return LocalMktDateDecoder.decode(this, offset, length);
    }

    @Override
    public long getUtcTimestamp(int offset, int length) {
        return UtcTimestampDecoder.decode(this, offset, length);
    }

    @Override
    public long getUtcTimeOnly(int offset, int length) {
        return UtcTimeOnlyDecoder.decode(this, offset, length);
    }

    @Override
    public int getUtcDateOnly(int offset) {
        return UtcDateOnlyDecoder.decode(this, offset);
    }

    @Override
    public int scanBack(int startInclusive, int endExclusive, char terminatingCharacter) {
        return this.scanBack(startInclusive, endExclusive, (byte)terminatingCharacter);
    }

    @Override
    public int scanBack(int startInclusive, int endExclusive, byte terminator) {
        for (int index = startInclusive; index >= endExclusive; --index) {
            byte value = this.getByte(index);
            if (value != terminator) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int scan(int startInclusive, int endInclusive, char terminatingCharacter) {
        return this.scan(startInclusive, endInclusive, (byte)terminatingCharacter);
    }

    @Override
    public int scan(int startInclusive, int endInclusive, byte terminator) {
        int indexValue = -1;
        for (int i = startInclusive; i <= endInclusive; ++i) {
            byte value = this.getByte(i);
            if (value != terminator) continue;
            indexValue = i;
            break;
        }
        return indexValue;
    }

    @Override
    public int computeChecksum(int offset, int end) {
        int total = 0;
        for (int index = offset; index < end; ++index) {
            total += this.getByte(index);
        }
        return total % 256;
    }

    public int putAscii(int index, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.US_ASCII);
        this.putBytes(index, bytes);
        return bytes.length;
    }

    public void putSeparator(int index) {
        this.putByte(index, (byte)1);
    }

    public int putAsciiBoolean(int offset, boolean value) {
        this.putByte(offset, value ? (byte)89 : 78);
        return 1;
    }

    public void putNatural(int offset, int length, int value) {
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            this.putByte(index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new AsciiEncodingException(String.format("Cannot write %d in %d bytes", value, length));
        }
    }

    public int putNaturalFromEnd(int value, int endExclusive) {
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            this.putByte(--index, (byte)(48 + digit));
        }
        return index;
    }

    public static int lengthInAscii(int value) {
        int characterCount = 0;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            ++characterCount;
        }
        return characterCount;
    }

    public int putAsciiInt(int offset, int value) {
        int i;
        if (this.zero(offset, value)) {
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            this.putBytes(offset, MIN_INTEGER_VALUE);
            return MIN_INTEGER_VALUE.length;
        }
        int start = offset;
        int quotient = value;
        int length = 1;
        if (value < 0) {
            this.putChar(offset, '-');
            ++start;
            ++length;
            quotient = -quotient;
        }
        length += i;
        for (i = MutableAsciiBuffer.endOffset(quotient); i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            this.putByte(i + start, (byte)(48 + remainder));
        }
        return length;
    }

    private static int endOffset(int value) {
        int i = 0;
        while (value > INT_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public int putAsciiLong(int offset, long value) {
        int i;
        if (this.zero(offset, value)) {
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            this.putBytes(offset, MIN_LONG_VALUE);
            return MIN_LONG_VALUE.length;
        }
        int start = offset;
        long quotient = value;
        int length = 1;
        if (value < 0L) {
            this.putChar(offset, '-');
            ++start;
            ++length;
            quotient = -quotient;
        }
        length += i;
        for (i = MutableAsciiBuffer.endOffset(quotient); i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            this.putByte(i + start, (byte)(48L + remainder));
        }
        return length;
    }

    public int putAsciiChar(int index, char value) {
        this.putByte(index, (byte)value);
        return 1;
    }

    private static int endOffset(long value) {
        int i = 0;
        while (value > LONG_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public int putAsciiFloat(int offset, DecimalFloat price) {
        long value = price.value();
        int scale = price.scale();
        if (this.zero(offset, value)) {
            return 1;
        }
        long remainder = this.calculateRemainderAndPutMinus(offset, value);
        int minusAdj = value < 0L ? 1 : 0;
        int start = offset + minusAdj;
        int tmpEnd = start + LONGEST_LONG_LENGTH;
        int tmpStart = this.putLong(remainder, tmpEnd) + 1;
        int length = tmpEnd - tmpStart + 1;
        if (scale > 0) {
            int end = start + length;
            int split = end - scale;
            int digitsBeforeDot = length - scale;
            if (digitsBeforeDot <= 0) {
                int cursor = start;
                this.putByte(cursor++, (byte)48);
                this.putByte(cursor++, (byte)46);
                int numberOfZeros = -digitsBeforeDot;
                int endOfZeros = cursor + numberOfZeros;
                while (cursor < endOfZeros) {
                    this.putByte(cursor, (byte)48);
                    ++cursor;
                }
                this.putBytes(cursor, this, tmpStart, length);
                return minusAdj + 1 + 1 + numberOfZeros + length;
            }
            this.putBytes(start, this, tmpStart, digitsBeforeDot);
            this.putByte(split, (byte)46);
            this.putBytes(split + 1, this, tmpStart + digitsBeforeDot, scale);
            return minusAdj + length + 1;
        }
        this.putBytes(start, this, tmpStart, length);
        return length + minusAdj;
    }

    private boolean zero(int offset, long value) {
        if (value == 0L) {
            this.putByte(offset, (byte)48);
            return true;
        }
        return false;
    }

    private long calculateRemainderAndPutMinus(int offset, long value) {
        if (value < 0L) {
            this.putChar(offset, '-');
            return value;
        }
        return -1L * value;
    }

    private int putLong(long remainder, int end) {
        int index = end;
        while (remainder < 0L) {
            long digit = remainder % 10L;
            remainder /= 10L;
            this.putByte(index, (byte)(48L + -1L * digit));
            --index;
        }
        return index;
    }
}

