/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.util.Map;
import java.util.stream.Collectors;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;

public final class CharArrayMap<V> {
    private final CharArrayWrapper wrapper = new CharArrayWrapper();
    private final Map<CharArrayWrapper, V> map;

    public CharArrayMap(Map<String, V> buildFrom) {
        this.map = buildFrom.entrySet().stream().collect(Collectors.toMap(entry -> new CharArrayWrapper((String)entry.getKey()), Map.Entry::getValue));
    }

    public V get(char[] value, int length) {
        this.wrapper.wrap(value, length);
        return this.map.get(this.wrapper);
    }

    public boolean containsKey(char[] value, int length) {
        this.wrapper.wrap(value, length);
        return this.map.containsKey(this.wrapper);
    }

    public boolean containsKey(char[] value, int offset, int length) {
        this.wrapper.wrap(value, offset, length);
        return this.map.containsKey(this.wrapper);
    }
}

