/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.LibraryTimeoutDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class LibraryTimeoutEncoder {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 40;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 27;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LibraryTimeoutEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final SessionsEncoder sessions = new SessionsEncoder(this);

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 40;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 27;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LibraryTimeoutEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 12);
        return this;
    }

    public LibraryTimeoutEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(12).templateId(40).schemaId(666).version(27);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryTimeoutEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int connectCorrelationIdId() {
        return 2;
    }

    public static int connectCorrelationIdSinceVersion() {
        return 0;
    }

    public static int connectCorrelationIdEncodingOffset() {
        return 4;
    }

    public static int connectCorrelationIdEncodingLength() {
        return 8;
    }

    public static String connectCorrelationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectCorrelationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectCorrelationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long connectCorrelationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public LibraryTimeoutEncoder connectCorrelationId(long value) {
        this.buffer.putLong(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static long sessionsId() {
        return 3L;
    }

    public SessionsEncoder sessionsCount(int count) {
        this.sessions.wrap(this.buffer, count);
        return this.sessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        LibraryTimeoutDecoder decoder = new LibraryTimeoutDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 12, 27);
        return decoder.appendTo(builder);
    }

    public static final class SessionsEncoder {
        public static final int HEADER_SIZE = 3;
        private final LibraryTimeoutEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SessionsEncoder(LibraryTimeoutEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)8, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public SessionsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SessionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public static int sessionIdId() {
            return 4;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SessionsEncoder sessionId(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }
    }
}

