/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;

public final class ReplayMessagesReplyDecoder {
    public static final int BLOCK_LENGTH = 13;
    public static final int TEMPLATE_ID = 54;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 26;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ReplayMessagesReplyDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 13;
    }

    public int sbeTemplateId() {
        return 54;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 26;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ReplayMessagesReplyDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ReplayMessagesReplyDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (54 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ReplayMessagesReplyDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int replyToIdId() {
        return 2;
    }

    public static int replyToIdSinceVersion() {
        return 0;
    }

    public static int replyToIdEncodingOffset() {
        return 4;
    }

    public static int replyToIdEncodingLength() {
        return 8;
    }

    public static String replyToIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long replyToIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long replyToIdMinValue() {
        return -9223372036854775807L;
    }

    public static long replyToIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long replyToId() {
        return this.buffer.getLong(this.offset + 4, BYTE_ORDER);
    }

    public static int statusId() {
        return 3;
    }

    public static int statusSinceVersion() {
        return 0;
    }

    public static int statusEncodingOffset() {
        return 12;
    }

    public static int statusEncodingLength() {
        return 1;
    }

    public static String statusMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short statusRaw() {
        return (short)(this.buffer.getByte(this.offset + 12) & 0xFF);
    }

    public ReplayMessagesStatus status() {
        return ReplayMessagesStatus.get((short)(this.buffer.getByte(this.offset + 12) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ReplayMessagesReplyDecoder decoder = new ReplayMessagesReplyDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ReplayMessagesReply](sbeTemplateId=");
        builder.append(54);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 26) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(26);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 13) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(13);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("replyToId=");
        builder.append(this.replyToId());
        builder.append('|');
        builder.append("status=");
        builder.append((Object)this.status());
        this.limit(originalLimit);
        return builder;
    }

    public ReplayMessagesReplyDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

